/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.util.Iterator;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MonitorCallback;
import org.jboss.mx.util.ObservedObject;
import org.jboss.mx.util.RunnableScheduler;
import org.jboss.mx.util.SchedulableRunnable;

public class MonitorRunnable
extends SchedulableRunnable {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$mx$util$MonitorRunnable == null ? (class$org$jboss$mx$util$MonitorRunnable = MonitorRunnable.class$("org.jboss.mx.util.MonitorRunnable")) : class$org$jboss$mx$util$MonitorRunnable));
    static RunnableScheduler scheduler = new RunnableScheduler();
    private Monitor monitor;
    private ObjectName monitorName;
    private MonitorCallback callback;
    private Map observedObjects;
    private MBeanServer server;
    static /* synthetic */ Class class$org$jboss$mx$util$MonitorRunnable;

    public MonitorRunnable(Monitor monitor, ObjectName monitorName, MonitorCallback callback, Map observedObjects, MBeanServer server) {
        this.monitor = monitor;
        this.monitorName = monitorName;
        this.callback = callback;
        this.observedObjects = observedObjects;
        this.server = server;
        this.setScheduler(scheduler);
    }

    void runMonitor(ObservedObject object) {
        try {
            MBeanInfo mbeanInfo = null;
            try {
                mbeanInfo = this.server.getMBeanInfo(object.getObjectName());
            }
            catch (InstanceNotFoundException e) {
                this.sendObjectErrorNotification(object, "The observed object is not registered.");
                return;
            }
            MBeanAttributeInfo[] mbeanAttributeInfo = mbeanInfo.getAttributes();
            MBeanAttributeInfo attributeInfo = null;
            for (int i = 0; i < mbeanAttributeInfo.length; ++i) {
                if (!mbeanAttributeInfo[i].getName().equals(this.monitor.getObservedAttribute())) continue;
                attributeInfo = mbeanAttributeInfo[i];
                break;
            }
            if (attributeInfo == null) {
                this.sendAttributeErrorNotification(object, "The observed attribute does not exist");
                return;
            }
            if (!attributeInfo.isReadable()) {
                this.sendAttributeErrorNotification(object, "Attribute not readable.");
                return;
            }
            Object value = null;
            try {
                value = this.server.getAttribute(object.getObjectName(), this.monitor.getObservedAttribute());
            }
            catch (InstanceNotFoundException e) {
                this.sendObjectErrorNotification(object, "The observed object is not registered.");
                return;
            }
            if (value == null) {
                this.sendAttributeTypeErrorNotification(object, "Attribute is null");
                return;
            }
            this.callback.monitorCallback(object, attributeInfo, value);
        }
        catch (Throwable e) {
            log.debug((Object)"Error in monitor ", e);
            this.sendRuntimeErrorNotification(object, "General error: " + e.toString());
        }
    }

    public void doRun() {
        this.runMonitor();
        this.setNextRun(System.currentTimeMillis() + this.monitor.getGranularityPeriod());
    }

    void runMonitor() {
        boolean isActive = this.monitor.isActive();
        Iterator i = this.observedObjects.values().iterator();
        while (i.hasNext() && isActive) {
            this.runMonitor((ObservedObject)i.next());
        }
    }

    void sendNotification(ObservedObject object, String type, long timestamp, String message, String attribute, Object gauge, Object trigger) {
        MonitorNotification n = this.callback.createNotification(type, this.monitorName, timestamp, message, gauge, attribute, object.getObjectName(), trigger);
        this.monitor.sendNotification(n);
    }

    void sendRuntimeErrorNotification(ObservedObject object, String message) {
        if (object.notAlreadyNotified(8)) {
            this.sendNotification(object, "jmx.monitor.error.runtime", 0L, message, this.monitor.getObservedAttribute(), null, null);
        }
    }

    void sendObjectErrorNotification(ObservedObject object, String message) {
        if (object.notAlreadyNotified(1)) {
            this.sendNotification(object, "jmx.monitor.error.mbean", 0L, message, this.monitor.getObservedAttribute(), null, null);
        }
    }

    void sendAttributeErrorNotification(ObservedObject object, String message) {
        if (object.notAlreadyNotified(2)) {
            this.sendNotification(object, "jmx.monitor.error.attribute", 0L, message, this.monitor.getObservedAttribute(), null, null);
        }
    }

    void sendAttributeTypeErrorNotification(ObservedObject object, String message) {
        if (object.notAlreadyNotified(4)) {
            this.sendNotification(object, "jmx.monitor.error.type", 0L, message, this.monitor.getObservedAttribute(), null, null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        scheduler.start();
    }
}

