/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SA01;

import CoreFS.SA01.CoreException;
import CoreFS.SA06.CoreICommunicationService;
import CoreFS.SA06.CoreParamObject;
import CoreFS.SA06.CoreReturnObject;
import CoreFS.SB03.CoreIvokeManage;
import CoreFS.SC01.CorePerformanceMonitor;
import CoreFS.SC01.StoreFactory;
import CoreFS.Util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoreCommunicationService
implements CoreICommunicationService {
    public static CoreIvokeManage imanage = null;
    protected final Log log = LogFactory.getLog(this.getClass());

    static {
        if (imanage == null) {
            imanage = new CoreIvokeManage();
        }
    }

    @Override
    public CoreReturnObject MethodHandler(CoreParamObject ctx) {
        CoreReturnObject rtnContext = new CoreReturnObject();
        String id = ctx.v_id;
        Object[] strParms = ctx.v_reqParameters;
        return imanage.callActivity(id, strParms);
    }

    @Override
    public CoreReturnObject runActivtity(CoreParamObject ctx) {
        CoreReturnObject rtnContext = new CoreReturnObject();
        Object message = null;
        boolean isover = false;
        String overDate = "2011-12-31";
        SimpleDateFormat tempDate = new SimpleDateFormat("yyyy-MM-dd");
        String datetime = tempDate.format(new Date());
        Date od = null;
        try {
            od = tempDate.parse(overDate);
        }
        catch (ParseException e2) {
            this.log.error((Object)e2.getMessage());
        }
        if (!isover) {
            String className = ctx.v_serviceName;
            String methodName = ctx.v_method;
            Object[] strParms = ctx.v_reqParameters;
            StringUtils.Sysid = ctx.v_mid;
            this.log.info((Object)("className--> " + className + " method-->" + methodName));
            Object instance = null;
            Method method = null;
            Object errmsg = null;
            try {
                if (this.isSupport(className)) {
                    instance = Class.forName(className).newInstance();
                }
                if (instance == null) {
                    rtnContext = rtnContext.SetErrInfo("\u670d\u52a1\uff1a" + className + " \u672a\u627e\u5230");
                    return rtnContext;
                }
                Class[] types = null;
                if (strParms != null) {
                    int len = strParms.length;
                    types = new Class[len];
                    int i = 0;
                    while (i < len) {
                        types[i] = strParms[i] == null ? Object.class : strParms[i].getClass();
                        ++i;
                    }
                }
                method = instance.getClass().getMethod(methodName, types);
                rtnContext = (CoreReturnObject)method.invoke(instance, strParms);
                long time = System.currentTimeMillis();
                Date callTime = new Date(time);
                StoreFactory.getStore().AddComponents(String.valueOf(className) + "." + methodName, callTime);
            }
            catch (CoreException ce) {
                rtnContext = rtnContext.SetErrInfo(ce.getMessage());
            }
            catch (Exception e) {
                Throwable t = null;
                if (e instanceof InvocationTargetException) {
                    InvocationTargetException targetEx = (InvocationTargetException)e;
                    t = targetEx.getTargetException();
                    rtnContext = rtnContext.SetErrInfo(t.getMessage());
                }
                rtnContext = rtnContext.SetErrInfo(e.getMessage());
            }
        }
        this.log.info((Object)("result-->\n" + (rtnContext.getResult() == null ? "" : "SUCCESS")));
        return rtnContext;
    }

    private boolean isSupport(String classname) {
        try {
            Class.forName(classname).newInstance();
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            return false;
        }
    }

    public synchronized List getMonitorInfo() {
        return (List)((Object)CorePerformanceMonitor.getMonitorInfo());
    }

    public String runXFire(String classname, String methodname, Object[] params) {
        CoreParamObject ctx = new CoreParamObject();
        ctx.setV_serviceName(classname);
        ctx.setV_method(methodname);
        ctx.setV_reqParameters(params);
        return this.runActivtity(ctx).getResult().toString();
    }
}

