/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SA03;

import CoreFS.SA01.CoreCommunicationService;
import CoreFS.SA03.CoreIWebServiceService;
import CoreFS.SA06.CoreICommunicationService;
import CoreFS.SA06.CoreParamObject;
import CoreFS.SA06.CoreReturnObject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.springframework.jdbc.support.rowset.SqlRowSet;

@WebService(endpointInterface="CoreFS.SA03.CoreIWebServiceService")
public class CoreWebServiceServiceImpl
implements CoreIWebServiceService {
    public static final String WS_XML_TB_NODE_NAME = "ROWDATA";
    public static final String WS_XML_ROW_NODE_NAME = "ROW";
    public static final String WS_XML_SEQ_NODE_NAME = "C0";
    private CoreICommunicationService communicationService = null;
    protected final Log log = LogFactory.getLog(this.getClass());

    public CoreWebServiceServiceImpl() {
        this.communicationService = new CoreCommunicationService();
    }

    public String setToXml(SqlRowSet rs, String rootStr, String rootchild) {
        String xmlStr = "";
        String[] colName = null;
        try {
            Element root = new Element(rootStr);
            int colLen = 0;
            if (rs.getRow() >= 0) {
                colName = rs.getMetaData().getColumnNames();
                colLen = colName.length;
                int i = 0;
                while (i < colLen) {
                    root.setAttribute(colName[i], String.valueOf(i));
                    ++i;
                }
            }
            while (rs.next()) {
                Element rootchildelement = new Element(rootchild);
                int n = 0;
                while (n < colLen) {
                    Element colEle = new Element("col");
                    rootchildelement.addContent((Content)colEle);
                    colEle.addContent(rs.getString(colName[n]));
                    ++n;
                }
                root.addContent((Content)rootchildelement);
            }
            Document doc = new Document(root);
            Format f = Format.getPrettyFormat();
            XMLOutputter outer = new XMLOutputter(f);
            xmlStr = String.valueOf(xmlStr) + outer.outputString(doc);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        return xmlStr;
    }

    public String arrayListToXml(ArrayList rs, String rootStr, String rootchild) {
        String xmlStr = "";
        try {
            if (rs.size() < 1) {
                return xmlStr;
            }
            Element root = new Element(rootStr);
            Map elelist = (Map)rs.get(0);
            int index = 0;
            for (Object key : elelist.keySet()) {
                root.setAttribute(key.toString(), Integer.toString(index));
                ++index;
            }
            int len = rs.size();
            try {
                int i = 0;
                while (i < len) {
                    Element rootchildelement = new Element(rootchild);
                    elelist = (Map)rs.get(i);
                    for (Object o : elelist.keySet()) {
                        Element colEle = new Element("col");
                        rootchildelement.addContent((Content)colEle);
                        Object obj = elelist.get(o);
                        String strTemp = "";
                        strTemp = obj == null ? "" : obj.toString();
                        colEle.addContent(strTemp);
                    }
                    root.addContent((Content)rootchildelement);
                    ++i;
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage());
            }
            Document doc = new Document(root);
            Format f = Format.getPrettyFormat();
            XMLOutputter outer = new XMLOutputter(f);
            xmlStr = String.valueOf(xmlStr) + outer.outputString(doc);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        return xmlStr;
    }

    public String listToXml(List rs, String rootStr, String rootchild) {
        String rtnStr = "";
        if (rs instanceof LinkedList) {
            rtnStr = this.linkedListToXml((LinkedList)rs, rootStr, rootchild);
        }
        if (rs instanceof ArrayList) {
            rtnStr = this.arrayListToXml((ArrayList)rs, rootStr, rootchild);
        }
        return rtnStr;
    }

    public String linkedListToXml(LinkedList rs, String rootStr, String rootchild) {
        String xmlStr = "";
        try {
            if (rs.size() < 1) {
                return xmlStr;
            }
            Element root = new Element(rootStr);
            Map elelist = (Map)rs.get(0);
            int index = 0;
            for (Object key : elelist.keySet()) {
                root.setAttribute(key.toString(), Integer.toString(index));
                ++index;
            }
            int len = rs.size();
            try {
                int i = 0;
                while (i < len) {
                    Element rootchildelement = new Element(rootchild);
                    elelist = (Map)rs.get(i);
                    for (Object o : elelist.keySet()) {
                        Element colEle = new Element("col");
                        rootchildelement.addContent((Content)colEle);
                        Object obj = elelist.get(o);
                        String strTemp = "";
                        strTemp = obj == null ? "" : obj.toString();
                        colEle.addContent(strTemp);
                    }
                    root.addContent((Content)rootchildelement);
                    ++i;
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage());
            }
            Document doc = new Document(root);
            Format f = Format.getPrettyFormat();
            XMLOutputter outer = new XMLOutputter(f);
            xmlStr = String.valueOf(xmlStr) + outer.outputString(doc);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        return xmlStr;
    }

    public String croToXml(CoreReturnObject cro, String rootStr, String rootchild) {
        String rtStr = "";
        if (cro.getResult() != null) {
            if (cro.getResult() instanceof List) {
                rtStr = this.listToXml((List)cro.getResult(), rootStr, rootchild);
            }
            if (cro.getResult() instanceof SqlRowSet) {
                rtStr = this.setToXml((SqlRowSet)cro.getResult(), rootStr, rootchild);
            }
        }
        return rtStr;
    }

    @Override
    public String say(String name) {
        return "hello cxf " + name;
    }

    @Override
    public String runCXF(String classname, String methodname, String[] params) {
        CoreParamObject ctx = new CoreParamObject();
        ctx.setV_serviceName(classname);
        ctx.setV_method(methodname);
        ctx.setV_reqParameters(params);
        CoreReturnObject cro = this.communicationService.runActivtity(ctx);
        return String.valueOf(cro.getV_errCode().toString()) + " " + cro.getV_errMsg();
    }
}

