/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SA05;

import CoreFS.SA01.CoreException;
import CoreFS.SA01.CoreGlobalConstants;
import CoreFS.SA05.CoreIFileOperation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CoreFileOperation
implements CoreIFileOperation {
    protected final Log log = LogFactory.getLog(this.getClass());
    private String cfgpath = Thread.currentThread().getContextClassLoader().getResource("../cfgfiles").getPath();

    @Override
    public Map ReadText(String srcpath, String splitFlag) {
        HashMap<String, String> properties = new HashMap<String, String>();
        BufferedReader br = null;
        FileReader fr = null;
        String mapKey = "";
        String mapValue = "";
        try {
            fr = new FileReader(srcpath);
            br = new BufferedReader(fr);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            while (br.ready()) {
                String myreadline = br.readLine();
                String[] linecontent = myreadline.split(splitFlag);
                mapKey = linecontent[0].trim();
                mapValue = linecontent[1].trim();
                properties.put(mapKey, mapValue);
                System.out.println(myreadline);
            }
            br.close();
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public String ReadText(String srcpath) {
        String str = "";
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(srcpath);
            if (doc.getChildNodes().getLength() > 1) {
                doc.removeChild(doc.getFirstChild());
            }
            StringWriter sw = new StringWriter();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.transform(new DOMSource(doc), new StreamResult(sw));
            str = sw.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    public Document ReadTextToXml(String srcpath) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            doc = builder.parse(srcpath);
        }
        catch (Exception ex) {
            doc = null;
        }
        return doc;
    }

    @Override
    public List<String> ReadXml(String srcpath, String parNode, String[] args) {
        ArrayList<String> ls = new ArrayList<String>();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        HashMap<String, String> map = null;
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            try {
                doc = docBuilder.parse(new File(srcpath));
                doc.getDocumentElement().normalize();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Root element of the doc is " + doc.getDocumentElement().getNodeName());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        NodeList dbList = doc.getElementsByTagName(parNode);
        if (dbList != null && dbList.getLength() != 0) {
            int s = 0;
            while (s < dbList.getLength()) {
                Node firstNode = dbList.item(s);
                if (firstNode.getNodeType() == 1) {
                    Element dbElement = (Element)firstNode;
                    map = new HashMap<String, String>();
                    int i = 0;
                    while (i < args.length) {
                        NodeList urlList = dbElement.getElementsByTagName(args[i]);
                        Element urlElement = (Element)urlList.item(0);
                        if (urlElement == null) break;
                        NodeList texturlList = urlElement.getChildNodes();
                        String value = (texturlList.item(0) == null ? "" : texturlList.item(0).getNodeValue()).trim();
                        System.out.println("args : " + args[i].toString() + "  >>" + value);
                        map.put(args[i].trim(), value);
                        ++i;
                    }
                    ls.add((String)((Object)map));
                }
                ++s;
            }
        }
        return ls;
    }

    public List<String> delXmlById(String srcpath, String parNode, String[] args, String idname, String idvalue) {
        ArrayList<String> ls = new ArrayList<String>();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        HashMap<String, String> map = null;
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            try {
                doc = docBuilder.parse(new File(srcpath));
                doc.getDocumentElement().normalize();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Root element of the doc is " + doc.getDocumentElement().getNodeName());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        NodeList dbList = doc.getElementsByTagName(parNode);
        int s = 0;
        while (s < dbList.getLength()) {
            Node firstNode = dbList.item(s);
            if (firstNode.getNodeType() == 1) {
                Element dbElement = (Element)firstNode;
                map = new HashMap<String, String>();
                boolean addflag = false;
                int i = 0;
                while (i < args.length) {
                    NodeList urlList = dbElement.getElementsByTagName(args[i]);
                    Element urlElement = (Element)urlList.item(0);
                    NodeList texturlList = urlElement.getChildNodes();
                    String value = (texturlList.item(0) == null ? "" : texturlList.item(0).getNodeValue()).trim();
                    System.out.println("args : " + args[i].toString() + "  >>" + value);
                    if (idvalue.equals(value) && args[i].equals(idname)) {
                        addflag = false;
                        break;
                    }
                    addflag = true;
                    map.put(args[i].trim(), value);
                    ++i;
                }
                if (addflag) {
                    ls.add((String)((Object)map));
                }
            }
            ++s;
        }
        return ls;
    }

    public List<String> updateXml(String srcpath, String parNode, String[] args, HashMap hm, String idname, String idvalue) {
        ArrayList<String> ls = new ArrayList<String>();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        HashMap<String, String> map = null;
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            try {
                doc = docBuilder.parse(new File(srcpath));
                doc.getDocumentElement().normalize();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Root element of the doc is " + doc.getDocumentElement().getNodeName());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        NodeList dbList = doc.getElementsByTagName(parNode);
        int s = 0;
        while (s < dbList.getLength()) {
            Node firstNode = dbList.item(s);
            if (firstNode.getNodeType() == 1) {
                Element dbElement = (Element)firstNode;
                map = new HashMap<String, String>();
                boolean updflag = false;
                int flgcnt = 0;
                int i = 0;
                while (i < args.length) {
                    NodeList urlList = dbElement.getElementsByTagName(args[i]);
                    Element urlElement = (Element)urlList.item(0);
                    NodeList texturlList = urlElement.getChildNodes();
                    String value = (texturlList.item(0) == null ? "" : texturlList.item(0).getNodeValue()).trim();
                    System.out.println("args : " + args[i].toString() + "  >>" + value);
                    if (value.equals(idvalue) && args[i].equals(idname)) {
                        updflag = true;
                        ++flgcnt;
                    }
                    if (updflag && flgcnt != 0) {
                        value = (String)hm.get(args[i]);
                    }
                    map.put(args[i].trim(), value);
                    ++i;
                }
                ls.add((String)((Object)map));
            }
            ++s;
        }
        return ls;
    }

    @Override
    public List<String> ReadXml(String srcpath, String parNode, String[] args, boolean webflag) {
        if (webflag) {
            srcpath = this.getWebDir(srcpath);
        }
        return this.ReadXml(srcpath, parNode, args);
    }

    public List<String> ReadQueryXml(String srcpath, String parNode, String[] args, String[] quyparams, String[] quyvalues) {
        ArrayList<String> ls = new ArrayList<String>();
        String path = this.getWebDir(srcpath);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            try {
                doc = docBuilder.parse(new File(path));
                doc.getDocumentElement().normalize();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Root element of the doc is " + doc.getDocumentElement().getNodeName());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        NodeList dbList = doc.getElementsByTagName(parNode);
        int s = 0;
        while (s < dbList.getLength()) {
            Node firstNode = dbList.item(s);
            HashMap<String, String> map = null;
            if (firstNode.getNodeType() == 1) {
                String value;
                NodeList texturlList;
                Element urlElement;
                NodeList urlList;
                boolean isfind = false;
                Element dbElement = (Element)firstNode;
                int m = 0;
                int j = 0;
                while (j < quyparams.length) {
                    urlList = dbElement.getElementsByTagName(quyparams[j]);
                    urlElement = (Element)urlList.item(0);
                    texturlList = urlElement.getChildNodes();
                    value = (texturlList.item(0) == null ? "" : texturlList.item(0).getNodeValue()).trim();
                    if (value.equals(quyvalues[j]) && ++m == quyparams.length) {
                        isfind = true;
                    }
                    ++j;
                }
                if (isfind) {
                    map = new HashMap<String, String>();
                    int i = 0;
                    while (i < args.length) {
                        urlList = dbElement.getElementsByTagName(args[i]);
                        urlElement = (Element)urlList.item(0);
                        texturlList = urlElement.getChildNodes();
                        value = (texturlList.item(0) == null ? "" : texturlList.item(0).getNodeValue()).trim();
                        System.out.println("args : " + args[i].toString() + "  >>" + value);
                        map.put(args[i].trim(), value);
                        ++i;
                    }
                }
            }
            if (map != null) {
                ls.add((String)((Object)map));
            }
            ++s;
        }
        return ls;
    }

    public ArrayList<String> ReadQueryXml(String srcpath, String parNode, String[] args, HashMap paramMap, HashMap paramMapType) {
        ArrayList<String> ls = new ArrayList<String>();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            try {
                doc = docBuilder.parse(new File(srcpath));
                doc.getDocumentElement().normalize();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Root element of the doc is " + doc.getDocumentElement().getNodeName());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        NodeList dbList = doc.getElementsByTagName(parNode);
        int s = 0;
        while (s < dbList.getLength()) {
            HashMap<String, String> map = null;
            Node firstNode = dbList.item(s);
            if (firstNode.getNodeType() == 1) {
                Element dbElement = (Element)firstNode;
                int m = 0;
                boolean isfind = false;
                int j = 0;
                while (j < paramMap.size()) {
                    Set keyset = paramMap.keySet();
                    Object[] keyarr = keyset.toArray();
                    System.out.println(keyarr.length);
                    int n = 0;
                    while (n < keyarr.length) {
                        System.out.println("keyarr[n]  " + keyarr[n]);
                        ++n;
                    }
                    NodeList urlList = dbElement.getElementsByTagName(keyarr[j].toString());
                    Element urlElement = (Element)urlList.item(0);
                    NodeList texturlList = urlElement.getChildNodes();
                    String value = (texturlList.item(0) == null ? "" : texturlList.item(0).getNodeValue()).trim();
                    if (paramMapType.get(keyarr[j]).equals("1")) {
                        if (!value.equals(paramMap.get(keyarr[j]))) break;
                        if (++m == paramMap.size()) {
                            isfind = true;
                        }
                    } else if (paramMapType.get(keyarr[j]).equals("2")) {
                        if (!value.contains((CharSequence)paramMap.get(keyarr[j]))) break;
                        if (++m == paramMap.size()) {
                            isfind = true;
                        }
                    }
                    ++j;
                }
                if (paramMap.size() == 0) {
                    isfind = true;
                }
                if (isfind) {
                    map = new HashMap<String, String>();
                    int i = 0;
                    while (i < args.length) {
                        NodeList urlList = dbElement.getElementsByTagName(args[i]);
                        Element urlElement = (Element)urlList.item(0);
                        NodeList texturlList = urlElement.getChildNodes();
                        String value = (texturlList.item(0) == null ? "" : texturlList.item(0).getNodeValue()).trim();
                        System.out.println("args : " + args[i].toString() + "  >>" + value);
                        map.put(args[i].trim(), value);
                        ++i;
                    }
                }
                if (map != null) {
                    ls.add((String)((Object)map));
                }
            }
            ++s;
        }
        return ls;
    }

    public String codeToString(String str) {
        String s = str;
        try {
            byte[] temp = s.getBytes("UTF-8");
            s = new String(temp);
            return s;
        }
        catch (Exception e) {
            return s;
        }
    }

    public static void main(String[] args) {
        CoreFileOperation test = new CoreFileOperation();
        System.out.println(System.getProperty("ContextTransService.java"));
    }

    public boolean isFileExists(String path) {
        File f = new File(path);
        if (!f.exists()) {
            String errMsg = "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6...";
            this.log.error((Object)errMsg);
            throw new CoreException(errMsg);
        }
        return f.exists();
    }

    public boolean isFileContentNull(String path) {
        File f = new File(path);
        Long l = f.length();
        boolean contentIsNull = false;
        contentIsNull = l == 0L;
        return contentIsNull;
    }

    public String getWebDir(String path) {
        String dir = CoreFileOperation.class.getClassLoader().getResource(path).getPath();
        return dir;
    }

    public void SaveAsXmlFiles(String xmlfilename, String strXML) {
        String filePath = String.valueOf(CoreGlobalConstants.ROLEBEAN_REMOTEXMLCONFIGPATH) + xmlfilename + ".xml";
        strXML = this.codeToString(strXML);
        if (!this.isFileExists(filePath)) {
            File file = new File(filePath);
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileOutputStream(xmlfilename));
            pw.write(strXML);
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void SaveDesignMainXml(String xmlfilename, String strXML) {
        String filePath = String.valueOf(this.cfgpath) + xmlfilename + ".xml";
        strXML = this.codeToString(strXML);
        if (!this.isFileExists(filePath)) {
            File file = new File(filePath);
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileOutputStream(filePath));
            pw.write(strXML);
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void SaveStringAsXml(String xmlfilename, String strXML) {
        String filePath = String.valueOf(this.cfgpath) + xmlfilename + ".xml";
        filePath = filePath.substring(1);
        File f = new File(filePath = filePath.replace("%20", " "));
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            try {
                PrintWriter pw = new PrintWriter(filePath, "utf-8");
                pw.write(strXML);
                pw.flush();
                pw.close();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }
}

