/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SA07;

import CoreFS.SA01.CoreIComponent;
import CoreFS.SA06.CoreReturnObject;
import CoreFS.SC01.CoreConstantData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.classic.Session;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class CoreWFManager
extends CoreIComponent {
    public CoreReturnObject getTreeData() {
        CoreReturnObject cro = new CoreReturnObject();
        try {
            JbpmContext jbpmContext = this.getJbpmContext();
            Session session = jbpmContext.getSessionFactory().openSession();
            List ls = jbpmContext.getGraphSession().findLatestProcessDefinitions();
            ArrayList result = new ArrayList();
            int i = 0;
            while (i < ls.size()) {
                ProcessDefinition pd = (ProcessDefinition)ls.get(i);
                List lss = pd.getNodes();
                LinkedHashMap<String, String> table = new LinkedHashMap<String, String>();
                Long id = pd.getId();
                table.put("ID", id.toString());
                table.put("NAME", pd.getName());
                table.put("LVL", "0");
                table.put("PID", "");
                table.put("HASEND", "");
                result.add(table);
                try {
                    result = this.getActorIDForTree(id.toString(), result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            cro.setResult(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cro;
    }

    private ArrayList getActorIDForTree(String processId, ArrayList result) throws Exception {
        JbpmContext jbpm = this.getJbpmContext();
        Session session = jbpm.getSessionFactory().openSession();
        try {
            String hql = "from org.jbpm.taskmgmt.def.Task as task where  task.processDefinition.id='" + processId + "' order by task.id asc";
            List ls = session.createQuery(hql).list();
            Task task = (Task)ls.get(0);
            hql = "from org.jbpm.taskmgmt.exe.TaskInstance as ti where  ti.task.id='" + task.getId() + "'";
            List lss = session.createQuery(hql).list();
            HashMap<String, Long> map = new HashMap<String, Long>();
            int i = 0;
            while (i < lss.size()) {
                LinkedHashMap<String, Object> pitable;
                ProcessInstance pi;
                int j;
                List piList;
                TaskInstance ti = (TaskInstance)lss.get(i);
                if (map.containsKey(ti.getActorId())) {
                    piList = this.getProcessInstance(Long.toString(ti.getProcessInstance().getId()));
                    j = 0;
                    while (j < piList.size()) {
                        pi = (ProcessInstance)piList.get(j);
                        pitable = new LinkedHashMap<String, Object>();
                        pitable.put("ID", Long.toString(pi.getId()));
                        pitable.put("NAME", pi.getKey());
                        pitable.put("LVL", "2");
                        pitable.put("PID", ti.getActorId());
                        pitable.put("HASEND", pi.hasEnded());
                        result.add(pitable);
                        ++j;
                    }
                } else {
                    map.put(ti.getActorId(), ti.getId());
                    piList = this.getProcessInstance(Long.toString(ti.getProcessInstance().getId()));
                    j = 0;
                    while (j < piList.size()) {
                        pi = (ProcessInstance)piList.get(j);
                        pitable = new LinkedHashMap();
                        pitable.put("ID", Long.toString(pi.getId()));
                        pitable.put("NAME", pi.getKey());
                        pitable.put("LVL", "2");
                        pitable.put("PID", ti.getActorId());
                        pitable.put("HASEND", pi.hasEnded());
                        result.add(pitable);
                        ++j;
                    }
                }
                ++i;
            }
            for (Map.Entry entry : map.entrySet()) {
                LinkedHashMap table = new LinkedHashMap();
                table.put("ID", entry.getKey());
                table.put("NAME", entry.getKey());
                table.put("LVL", "1");
                table.put("PID", processId);
                table.put("HASEND", "");
                result.add(table);
            }
        }
        finally {
            session.close();
            jbpm.close();
        }
        return result;
    }

    private List getProcessInstance(String processId) {
        JbpmContext jbpm = this.getJbpmContext();
        Session session = jbpm.getSessionFactory().openSession();
        try {
            List lss;
            String hql = "from org.jbpm.graph.exe.ProcessInstance as pi where  pi.id='" + processId + "' order by pi.start desc";
            List list = lss = session.createQuery(hql).list();
            return list;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            session.close();
            jbpm.close();
        }
        return null;
    }

    public CoreReturnObject DeleteProcessDefine(String pdid) {
        CoreReturnObject cro = new CoreReturnObject();
        try {
            JbpmContext jbpmContext = this.getJbpmContext();
            ProcessDefinition pdf = jbpmContext.getGraphSession().getProcessDefinition(Long.parseLong(pdid));
            jbpmContext.getGraphSession().deleteProcessDefinition(pdf);
        }
        catch (Exception e) {
            cro = cro.SetErrInfo(e.getMessage());
        }
        return cro;
    }

    public CoreReturnObject getProcessInstanceInfo(String processId, String pdid) {
        CoreReturnObject cro = new CoreReturnObject();
        ArrayList result = new ArrayList();
        List list = this.getProcessInstance(processId);
        if (list.size() > 0) {
            ProcessInstance pi = (ProcessInstance)list.get(0);
            LinkedHashMap<String, Object> table = new LinkedHashMap<String, Object>();
            table.put("ID", Long.toString(pi.getId()));
            table.put("NAME", pi.getKey());
            table.put("ACTORID", "");
            table.put("START", pi.getStart());
            table.put("END", pi.getEnd());
            table.put("HASEND", pi.hasEnded());
            table.put("TYPE", "process");
            result.add(table);
        }
        HashMap map = this.LoadAllTaskNode(pdid);
        ArrayList al = this.getTaskInstanceInfo(processId, map, result);
        cro.setResult(al);
        return cro;
    }

    private ArrayList getTaskInstanceInfo(String processId, HashMap map, ArrayList result) {
        JbpmContext jbpm = this.getJbpmContext();
        Session session = jbpm.getSessionFactory().openSession();
        try {
            try {
                String hql = "from org.jbpm.taskmgmt.exe.TaskInstance as ti where  ti.processInstance.id='" + processId + "' order by ti.id asc";
                List lss = session.createQuery(hql).list();
                int i = 0;
                while (i < lss.size()) {
                    TaskInstance ti = (TaskInstance)lss.get(i);
                    if (map.containsKey(ti.getName())) {
                        map.remove(ti.getName());
                    }
                    LinkedHashMap<String, Object> table = new LinkedHashMap<String, Object>();
                    table.put("ID", Long.toString(ti.getId()));
                    table.put("NAME", ti.getName());
                    table.put("ACTORID", ti.getActorId());
                    table.put("START", ti.getCreate());
                    table.put("END", ti.getEnd());
                    table.put("HASEND", ti.hasEnded());
                    table.put("TYPE", "task");
                    result.add(table);
                    ++i;
                }
                for (Map.Entry entry : map.entrySet()) {
                    Task task = (Task)entry.getValue();
                    LinkedHashMap<String, String> table = new LinkedHashMap<String, String>();
                    table.put("ID", Long.toString(task.getId()));
                    table.put("NAME", task.getName());
                    table.put("ACTORID", "");
                    table.put("START", null);
                    table.put("END", null);
                    table.put("HASEND", "False");
                    table.put("TYPE", "task");
                    result.add(table);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                session.close();
                jbpm.close();
            }
        }
        finally {
            session.close();
            jbpm.close();
        }
        return result;
    }

    private HashMap LoadAllTaskNode(String pdid) {
        JbpmContext jbpm = this.getJbpmContext();
        Session session = jbpm.getSessionFactory().openSession();
        HashMap<String, Task> map = new HashMap<String, Task>();
        try {
            try {
                String hql = "from org.jbpm.taskmgmt.def.Task as ti where  ti.processDefinition.id='" + pdid + "' order by ti.id asc";
                List lss = session.createQuery(hql).list();
                int i = 0;
                while (i < lss.size()) {
                    Task task = (Task)lss.get(i);
                    map.put(task.getName(), task);
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                session.close();
                jbpm.close();
            }
        }
        finally {
            session.close();
            jbpm.close();
        }
        return map;
    }

    public CoreReturnObject getProcessDefinitionInfo(String pdid) {
        CoreReturnObject cro = new CoreReturnObject();
        JbpmContext jbpm = this.getJbpmContext();
        ArrayList result = new ArrayList();
        Session session = jbpm.getSessionFactory().openSession();
        try {
            try {
                String hql = "from org.jbpm.graph.def.ProcessDefinition where id='" + pdid + "'";
                List lss = session.createQuery(hql).list();
                if (lss.size() > 0) {
                    ProcessDefinition pd = (ProcessDefinition)lss.get(0);
                    LinkedHashMap<String, Object> table = new LinkedHashMap<String, Object>();
                    Long id = pd.getId();
                    table.put("ID", id.toString());
                    table.put("NAME", pd.getName());
                    table.put("LVL", "0");
                    table.put("PID", "");
                    table.put("DESCRIPTION", pd.getDescription());
                    int pdVersion = pd.getVersion();
                    table.put("VERSION", Integer.toString(pdVersion));
                    table.put("START", null);
                    table.put("END", null);
                    table.put("HASEND", true);
                    table.put("ISSUSPENDED", true);
                    table.put("TYPE", "pdefinition");
                    result.add(table);
                    result = this.getProcessInfo(id.toString(), result);
                    cro.setResult(result);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                session.close();
                jbpm.close();
            }
        }
        finally {
            session.close();
            jbpm.close();
        }
        return cro;
    }

    private ArrayList getProcessInfo(String processId, ArrayList result) throws Exception {
        JbpmContext jbpm = this.getJbpmContext();
        Session session = jbpm.getSessionFactory().openSession();
        try {
            String hql = "from org.jbpm.graph.exe.ProcessInstance as pi where  pi.processDefinition.id='" + processId + "' order by pi.start desc";
            List ls = session.createQuery(hql).list();
            int i = 0;
            while (i < ls.size()) {
                ProcessInstance pi = (ProcessInstance)ls.get(i);
                Long id = pi.getId();
                LinkedHashMap<String, Object> table = new LinkedHashMap<String, Object>();
                table.put("ID", id.toString());
                table.put("NAME", pi.getKey());
                table.put("LVL", "1");
                table.put("PID", processId);
                table.put("DESCRIPTION", "");
                table.put("VERSION", Integer.toString(pi.getVersion()));
                table.put("START", pi.getStart());
                table.put("END", pi.getEnd());
                table.put("HASEND", pi.hasEnded());
                table.put("ISSUSPENDED", pi.isSuspended());
                table.put("TYPE", "pinstance");
                result.add(table);
                ++i;
            }
        }
        finally {
            session.close();
            jbpm.close();
        }
        return result;
    }

    public CoreReturnObject ProcessInstaceSuspend(ArrayList al, Integer OPType) {
        CoreReturnObject cro = new CoreReturnObject();
        int i = 0;
        while (i < al.size()) {
            Long processInstanceId = Long.parseLong(al.get(i).toString());
            try {
                this.ProcessInstanceOpe(processInstanceId, OPType);
            }
            catch (Exception e) {
                cro.SetErrInfo(e.getMessage());
            }
            ++i;
        }
        return cro;
    }

    private boolean ProcessInstanceOpe(Long processInstanceId, Integer OPType) throws Exception {
        JbpmContext jbpm = this.getJbpmContext();
        boolean isdeal = false;
        try {
            try {
                ProcessInstance pi = jbpm.getProcessInstance(processInstanceId.longValue());
                switch (OPType) {
                    case 1: {
                        pi.suspend();
                        isdeal = true;
                        break;
                    }
                    case 2: {
                        pi.resume();
                        isdeal = true;
                        break;
                    }
                    case 3: {
                        pi.end();
                        isdeal = true;
                        break;
                    }
                    case 4: {
                        jbpm.getGraphSession().deleteProcessInstance(pi);
                        isdeal = true;
                    }
                }
            }
            catch (Exception ex) {
                isdeal = false;
                throw ex;
            }
        }
        finally {
            jbpm.close();
        }
        return isdeal;
    }

    public CoreReturnObject TaskInstaceOP(ArrayList al, Integer OPType) {
        CoreReturnObject cro = new CoreReturnObject();
        int i = 0;
        while (i < al.size()) {
            Long taskinstancesId = Long.parseLong(al.get(i).toString());
            try {
                this.TaskInstanceOpe(taskinstancesId, OPType);
            }
            catch (Exception e) {
                cro.SetErrInfo(e.getMessage());
            }
            ++i;
        }
        return cro;
    }

    private boolean TaskInstanceOpe(Long taskInstanceId, Integer OPType) throws Exception {
        JbpmContext jbpm = this.getJbpmContext();
        boolean isdeal = false;
        try {
            try {
                TaskInstance ti = jbpm.getTaskInstance(taskInstanceId.longValue());
                switch (OPType) {
                    case 1: {
                        ti.suspend();
                        isdeal = true;
                        break;
                    }
                    case 2: {
                        ti.resume();
                        isdeal = true;
                        break;
                    }
                    case 3: {
                        ti.end();
                        isdeal = true;
                    }
                }
            }
            catch (Exception ex) {
                isdeal = false;
                throw ex;
            }
        }
        finally {
            jbpm.close();
        }
        return isdeal;
    }

    public CoreReturnObject Deploy(ArrayList processList) {
        CoreReturnObject cro = new CoreReturnObject();
        int i = 0;
        while (i < processList.size()) {
            String processName = processList.get(i).toString();
            String sql = "SELECT CONTENT FROM PT4DEV_JBPMDATA WHERE ID=?";
            try {
                String xmlStr = this.getDao(CoreConstantData.sysbeanstr).LoadXMLFromDB(sql, processName);
                this.getbpm().Deploy(xmlStr);
            }
            catch (SQLException e) {
                cro = cro.SetErrInfo(e.getMessage());
            }
            ++i;
        }
        return cro;
    }

    public CoreReturnObject LoadProcess() {
        CoreReturnObject cro = new CoreReturnObject();
        String sqlStr = "SELECT ID,NAME FROM PT4DEV_JBPMDATA";
        cro = this.getDao(CoreConstantData.sysbeanstr).ExcuteQuery(sqlStr);
        return cro;
    }

    private JbpmContext getJbpmContext() {
        JbpmConfiguration jbpmConfiguration = JbpmConfiguration.getInstance();
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        return jbpmContext;
    }

    public static void main(String[] args) {
        CoreWFManager cwm = new CoreWFManager();
        cwm.getTreeData();
    }
}

