/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SA08;

import CoreFS.SA08.CoreFileStorageImpl;
import CoreFS.SC01.CoreConstantData;
import java.io.File;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoreFileRollDelete {
    private static int maxBackupIndex = 0;
    private static long gapTime = 0L;
    protected final Log log = LogFactory.getLog(this.getClass());

    public CoreFileRollDelete() {
        this.depositPath();
    }

    public void deleteImageByCount(File file) {
        if (maxBackupIndex <= 0) {
            return;
        }
        File[] files = CoreFileRollDelete.sort(file.listFiles());
        int count = files.length;
        if (count >= maxBackupIndex) {
            int i = 0;
            while (i < count - maxBackupIndex) {
                files[i].delete();
                ++i;
            }
        }
    }

    public void deleteImageByDate(File file) {
        if (gapTime <= 0L) {
            return;
        }
        File[] files = file.listFiles();
        long nextCheck = System.currentTimeMillis();
        int i = 0;
        while (i < files.length) {
            if (nextCheck - files[i].lastModified() >= gapTime * 24L * 60L * 60L * 1000L) {
                files[i].delete();
            }
            ++i;
        }
    }

    private static File[] sort(File[] files) {
        int i = 0;
        while (i < files.length) {
            int j = 0;
            while (j < files.length) {
                if (files[i].lastModified() < files[j].lastModified()) {
                    File temp = files[j];
                    files[j] = files[i];
                    files[i] = temp;
                }
                ++j;
            }
            ++i;
        }
        return files;
    }

    private void depositPath() {
        try {
            Properties pro = new Properties();
            pro.load(CoreFileStorageImpl.class.getResourceAsStream("/imagePath.properties"));
            String str = pro.getProperty("maxBackupIndex");
            String str1 = pro.getProperty("gapTime");
            maxBackupIndex = Integer.parseInt(str);
            gapTime = Long.parseLong(str1);
        }
        catch (Exception e) {
            this.log.error((Object)"\u8bfb\u53d6\u56fe\u7247\u914d\u7f6e\u6587\u4ef6[imagePath.properties]\u9519\u8bef ");
        }
    }

    public static void main(String[] args) {
        CoreFileRollDelete ird = new CoreFileRollDelete();
        File file = new File("D:/123/234/345/2013-01-29");
        if (CoreConstantData.delCondition.booleanValue()) {
            ird.deleteImageByCount(file);
        } else {
            ird.deleteImageByDate(file);
        }
    }
}

