/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SD03;

import CoreFS.SA06.CoreReturnObject;
import CoreFS.SA08.CoreImageStorageImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Properties;

public class CoreLogFileReader {
    public static StringBuffer pageContents = new StringBuffer();

    public static CoreReturnObject readLog(String byDateTime, String LogName) {
        CoreReturnObject cro = new CoreReturnObject();
        try {
            String systempath = System.getProperty("catalina.home");
            String path = "";
            path = byDateTime.equals("") ? String.valueOf(systempath) + "\\logs\\" + LogName + ".log" : String.valueOf(systempath) + "\\logs\\" + LogName + ".log" + byDateTime;
            FileInputStream is = new FileInputStream(path);
            byte[] buffer = new byte[((InputStream)is).available()];
            pageContents.setLength(0);
            pageContents.append(new String(buffer, 0, ((InputStream)is).read(buffer)));
            ((InputStream)is).close();
            cro.setResult(pageContents.toString());
        }
        catch (Exception e) {
            cro = cro.SetErrInfo(e.getMessage());
            e.printStackTrace();
        }
        return cro;
    }

    public static CoreReturnObject readLog(String byDateTime, String LogName, Integer beg) {
        CoreReturnObject cro = new CoreReturnObject();
        MappedByteBuffer inputBuffer = null;
        File f = null;
        try {
            String systempath = CoreLogFileReader.LoadLogspath();
            File file = new File(systempath);
            File[] files = file.listFiles();
            String path = "";
            if (byDateTime.equals("")) {
                String tempName = String.valueOf(LogName) + ".log";
                path = String.valueOf(systempath) + "/" + tempName;
            } else {
                int i = 0;
                while (i < files.length) {
                    String tempPath = files[i].getPath();
                    if (tempPath.contains(LogName) && tempPath.contains(byDateTime)) {
                        path = tempPath;
                        break;
                    }
                    ++i;
                }
            }
            if (path.equals("")) {
                cro.setResult("");
                CoreReturnObject coreReturnObject = cro;
                return coreReturnObject;
            }
            try {
                int BUFFER_SIZE = 0x300000;
                pageContents.setLength(0);
                f = new File(path);
                int num = (int)f.length() / 20480 + 1;
                int begin = (int)f.length() * beg / num;
                inputBuffer = new RandomAccessFile(f, "rw").getChannel().map(FileChannel.MapMode.READ_ONLY, begin, f.length() / (long)num);
                byte[] dst = new byte[0x300000];
                long start = System.currentTimeMillis();
                int offset = 0;
                while (offset < inputBuffer.capacity()) {
                    int i;
                    if (inputBuffer.capacity() - offset >= 0x300000) {
                        i = 0;
                        while (i < 0x300000) {
                            dst[i] = inputBuffer.get(offset + i);
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < inputBuffer.capacity() - offset) {
                            dst[i] = inputBuffer.get(offset + i);
                            ++i;
                        }
                    }
                    int length = inputBuffer.capacity() % 0x300000 == 0 ? 0x300000 : inputBuffer.capacity() % 0x300000;
                    pageContents.setLength(0);
                    pageContents.append(new String(dst, 0, length));
                    offset += 0x300000;
                }
                cro.setResult(pageContents.toString());
            }
            catch (Exception ex) {
                cro.setResult("");
                cro = cro.SetErrInfo(ex.getMessage());
                ex.printStackTrace();
            }
        }
        finally {
            inputBuffer = null;
            f = null;
        }
        return cro;
    }

    private static String LoadLogspath() {
        String logpath = null;
        try {
            Properties pro = new Properties();
            pro.load(CoreImageStorageImpl.class.getResourceAsStream("/imagePath.properties"));
            logpath = pro.getProperty("logpath");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return logpath;
    }
}

