/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.metadata.unmarshalling.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.metadata.unmarshalling.AttributeBinding;

public class AttributeBindingImpl
implements AttributeBinding {
    private final QName attributeName;
    private final Class javaType;
    private final Field field;
    private final Method getter;
    private final Method setter;
    private final Class fieldType;

    public AttributeBindingImpl(QName attributeName, Class javaType, Class parentClass, String fieldName) {
        this.attributeName = attributeName;
        Field field = null;
        Method getter = null;
        Method setter = null;
        if (fieldName != null) {
            try {
                field = parentClass.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                String baseMethodName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                try {
                    getter = parentClass.getMethod("get" + baseMethodName, null);
                    setter = parentClass.getMethod("set" + baseMethodName, getter.getReturnType());
                }
                catch (NoSuchMethodException e1) {
                    throw new JBossXBRuntimeException("Failed to bind attribute " + attributeName + ": neither field nor getter/setter were found for field " + fieldName + " in " + parentClass);
                }
            }
        }
        this.field = field;
        this.getter = getter;
        this.setter = setter;
        Object object = field == null ? (getter == null ? null : getter.getReturnType()) : (this.fieldType = field.getType());
        if (this.fieldType == null) {
            throw new JBossXBRuntimeException("Failed to bind attribute " + attributeName + " to field " + fieldName + " in " + parentClass + ": failed to resolve field's type.");
        }
        this.javaType = javaType == null ? this.fieldType : javaType;
    }

    public QName getAttributeName() {
        return this.attributeName;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public Field getField() {
        return this.field;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public Class getFieldType() {
        return this.fieldType;
    }
}

