/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jbpm.JbpmException;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.instantiation.Delegation;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.def.TaskController;
import org.jbpm.util.ClassLoaderUtil;

public abstract class HibernateHelper {
    static Map configurations = new HashMap();
    private static Log log = LogFactory.getLog((Class)HibernateHelper.class);

    public static void clearConfigurationsCache() {
        configurations = new HashMap();
    }

    public static SessionFactory createSessionFactory() {
        return HibernateHelper.createSessionFactory(null, null, true);
    }

    public static SessionFactory createSessionFactory(String cfgXmlResource) {
        return HibernateHelper.createSessionFactory(cfgXmlResource, null, true);
    }

    public static SessionFactory createSessionFactory(String cfgXmlResource, String propertiesResource) {
        return HibernateHelper.createSessionFactory(cfgXmlResource, propertiesResource, true);
    }

    public static SessionFactory createSessionFactory(String cfgXmlResource, String propertiesResource, boolean isConfigLookupEnabled) {
        Configuration configuration = HibernateHelper.createConfiguration(cfgXmlResource, propertiesResource);
        return HibernateHelper.createSessionFactory(configuration, isConfigLookupEnabled);
    }

    public static SessionFactory createSessionFactory(Configuration configuration, boolean isConfigLookupEnabled) {
        SessionFactory sessionFactory = configuration.buildSessionFactory();
        if (isConfigLookupEnabled) {
            configurations.put(sessionFactory, configuration);
        }
        return sessionFactory;
    }

    public static Configuration createConfiguration(String cfgXmlResource, String propertiesResource) {
        Configuration configuration = new Configuration();
        if (cfgXmlResource != null) {
            log.debug((Object)("creating hibernate configuration resource '" + cfgXmlResource + "'"));
            configuration.configure(cfgXmlResource);
        } else {
            log.debug((Object)"using default hibernate configuration resource (hibernate.cfg.xml)");
            configuration.configure();
        }
        if (propertiesResource != null) {
            log.debug((Object)("using hibernate properties from resource '" + propertiesResource + "'"));
            Properties properties = HibernateHelper.loadPropertiesFromResource(propertiesResource);
            if (properties != null) {
                configuration.setProperties(properties);
            }
        }
        return configuration;
    }

    public static Configuration getConfiguration(SessionFactory sessionFactory) {
        return (Configuration)configurations.get(sessionFactory);
    }

    public static SchemaExport createSchemaExport(SessionFactory sessionFactory) {
        return new SchemaExport(HibernateHelper.getConfiguration(sessionFactory));
    }

    public static boolean createSchemaExportScript(SessionFactory sessionFactory) {
        boolean script = false;
        String showSql = HibernateHelper.getConfiguration(sessionFactory).getProperty("hibernate.show_sql");
        if ("true".equalsIgnoreCase(showSql)) {
            script = true;
        }
        return script;
    }

    public static void clearHibernateCache(SessionFactory sessionFactory) {
        sessionFactory.evictQueries();
        sessionFactory.evict(VariableAccess.class);
        sessionFactory.evict(Action.class);
        sessionFactory.evict(Event.class);
        sessionFactory.evict(ExceptionHandler.class);
        sessionFactory.evict(Node.class);
        sessionFactory.evict(ProcessDefinition.class);
        sessionFactory.evict(Transition.class);
        sessionFactory.evict(Delegation.class);
        sessionFactory.evict(ModuleDefinition.class);
        sessionFactory.evict(Task.class);
        sessionFactory.evict(TaskController.class);
        sessionFactory.evictCollection("org.jbpm.graph.def.ProcessDefinition.events");
        sessionFactory.evictCollection("org.jbpm.graph.def.ProcessDefinition.exceptionHandlers");
        sessionFactory.evictCollection("org.jbpm.graph.def.ProcessDefinition.nodes");
        sessionFactory.evictCollection("org.jbpm.graph.def.ProcessDefinition.actions");
        sessionFactory.evictCollection("org.jbpm.graph.def.ProcessDefinition.definitions");
        sessionFactory.evictCollection("org.jbpm.graph.def.Node.events");
        sessionFactory.evictCollection("org.jbpm.graph.def.Node.exceptionHandlers");
        sessionFactory.evictCollection("org.jbpm.graph.def.Node.leavingTransitions");
        sessionFactory.evictCollection("org.jbpm.graph.def.Node.arrivingTransitions");
        sessionFactory.evictCollection("org.jbpm.graph.def.Transition.events");
        sessionFactory.evictCollection("org.jbpm.graph.def.Transition.exceptionHandlers");
        sessionFactory.evictCollection("org.jbpm.graph.def.Event.actions");
        sessionFactory.evictCollection("org.jbpm.graph.def.SuperState.nodes");
        sessionFactory.evictCollection("org.jbpm.graph.def.ExceptionHandler.actions");
        sessionFactory.evictCollection("org.jbpm.graph.node.ProcessState.variableAccesses");
        sessionFactory.evictCollection("org.jbpm.graph.node.TaskNode.tasks");
        sessionFactory.evictCollection("org.jbpm.taskmgmt.def.Swimlane.tasks");
        sessionFactory.evictCollection("org.jbpm.taskmgmt.def.Task.events");
        sessionFactory.evictCollection("org.jbpm.taskmgmt.def.Task.exceptionHandlers");
        sessionFactory.evictCollection("org.jbpm.taskmgmt.def.TaskController.variableAccesses");
        sessionFactory.evictCollection("org.jbpm.file.def.FileDefinition.processFiles");
        sessionFactory.evictCollection("org.jbpm.taskmgmt.def.TaskMgmtDefinition.swimlanes");
        sessionFactory.evictCollection("org.jbpm.taskmgmt.def.TaskMgmtDefinition.tasks");
        sessionFactory.evictCollection("org.jbpm.graph.action.Script.variableAccesses");
    }

    static Properties loadPropertiesFromResource(String resource) {
        Properties properties = null;
        InputStream inputStream = ClassLoaderUtil.getStream(resource);
        if (inputStream != null) {
            properties = new Properties();
            try {
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException e) {
                throw new JbpmException("couldn't load hibernate properties from resource '" + resource + "'", e);
            }
        } else {
            log.warn((Object)("couldn't find resource '" + resource + "' to load hibernate properties from"));
        }
        return properties;
    }
}

