/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.xml;

import java.io.IOException;
import java.io.Serializable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.jpdl.xml.ProblemListener;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class JpdlParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final EntityResolver JPDL_ENTITY_RESOLVER = new JpdlEntityResolver();
    private static final Log log = LogFactory.getLog((Class)JpdlParser.class);

    public static Document parse(InputSource inputSource, ProblemListener problemListener) throws Exception {
        Document document = null;
        SAXReader saxReader = JpdlParser.createSaxReader(problemListener);
        document = saxReader.read(inputSource);
        return document;
    }

    public static SAXReader createSaxReader(ProblemListener problemListener) throws Exception {
        XMLReader xmlReader = JpdlParser.createXmlReader();
        SAXReader saxReader = new SAXReader(xmlReader);
        saxReader.setErrorHandler((ErrorHandler)new JpdlErrorHandler(problemListener));
        saxReader.setEntityResolver(JPDL_ENTITY_RESOLVER);
        return saxReader;
    }

    public static XMLReader createXmlReader() throws Exception {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setValidating(true);
        saxParserFactory.setNamespaceAware(true);
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        try {
            saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        catch (SAXException e) {
            log.warn((Object)"couldn't set xml parser property 'http://java.sun.com/xml/jaxp/properties/schemaLanguage' to 'http://www.w3.org/2001/XMLSchema'", (Throwable)e);
        }
        try {
            saxParser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://jbpm.org/3/jpdl http://jbpm.org/jpdl-3.0.xsd urn:jbpm.org:jpdl-3.0 http://jbpm.org/jpdl-3.0.xsd urn:jbpm.org:jpdl-3.1 http://jbpm.org/jpdl-3.1.xsd");
        }
        catch (SAXException e) {
            log.warn((Object)"couldn't set xml parser property 'http://apache.org/xml/properties/schema/external-schemaLocation'", (Throwable)e);
        }
        try {
            xmlReader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
        }
        catch (SAXException e) {
            log.warn((Object)"couldn't set xml parser feature 'http://apache.org/xml/features/validation/dynamic'", (Throwable)e);
        }
        return xmlReader;
    }

    static class JpdlEntityResolver
    implements EntityResolver,
    Serializable {
        private static final long serialVersionUID = 1L;

        JpdlEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource inputSource = null;
            log.debug((Object)("resolving schema reference publicId(" + publicId + ") systemId(" + systemId + ")"));
            if ("http://jbpm.org/jpdl-3.1.xsd".equals(systemId)) {
                log.debug((Object)"providing input source to local 'jpdl-3.1.xsd' resource");
                inputSource = new InputSource(this.getClass().getResourceAsStream("jpdl-3.1.xsd"));
            } else if ("http://jbpm.org/jpdl-3.0.xsd".equals(systemId)) {
                log.debug((Object)"providing input source to local 'jpdl-3.0.xsd' resource");
                inputSource = new InputSource(this.getClass().getResourceAsStream("jpdl-3.0.xsd"));
            } else {
                log.debug((Object)"original systemId as input source");
                inputSource = new InputSource(systemId);
            }
            return inputSource;
        }
    }

    static class JpdlErrorHandler
    implements ErrorHandler,
    Serializable {
        private static final long serialVersionUID = 1L;
        ProblemListener problemListener = null;

        JpdlErrorHandler(ProblemListener problemListener) {
            this.problemListener = problemListener;
        }

        public void warning(SAXParseException pe) {
            this.addProblem(3, "line " + pe.getLineNumber() + ": " + pe.getMessage(), pe);
        }

        public void error(SAXParseException pe) {
            this.addProblem(2, "line " + pe.getLineNumber() + ": " + pe.getMessage(), pe);
        }

        public void fatalError(SAXParseException pe) {
            this.addProblem(1, "line " + pe.getLineNumber() + ": " + pe.getMessage(), pe);
        }

        void addProblem(int level, String description, Throwable exception) {
            this.problemListener.addProblem(new Problem(level, description, exception));
        }
    }
}

