/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.hibernate.Session;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.ant.AntHelper;
import org.jbpm.identity.Entity;
import org.jbpm.identity.xml.IdentityXmlParser;

public class LoadIdentitiesTask
extends Task {
    private String file = null;
    private String cfg = null;
    private String properties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        JbpmConfiguration jbpmConfiguration = AntHelper.getJbpmConfiguration((String)this.cfg, (String)this.properties);
        if (this.file == null) {
            throw new BuildException("no file specified in the loadidentities task");
        }
        this.log("loading identities from " + this.file + " ...");
        File identitiesFile = new File(this.file);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(identitiesFile);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("identities file '" + this.file + "' not found");
        }
        Entity[] entities = IdentityXmlParser.parseEntitiesResource(fileInputStream);
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        try {
            Session session = jbpmContext.getSession();
            for (int i = 0; i < entities.length; ++i) {
                session.save((Object)entities[i]);
            }
        }
        finally {
            jbpmContext.close();
        }
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setCfg(String cfg) {
        this.cfg = cfg;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }
}

