/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleTimeoutThreadPerVM;

class OracleTimeoutPollingThread
extends Thread {
    protected static final String threadName = "OracleTimeoutPollingThread";
    public static final String pollIntervalProperty = "oracle.jdbc.TimeoutPollInterval";
    public static final String pollIntervalDefault = "1000";
    private OracleTimeoutThreadPerVM[] knownTimeouts;
    private int count;
    private long sleepMillis;

    public OracleTimeoutPollingThread() {
        super(threadName);
        this.setDaemon(true);
        this.setPriority(10);
        this.knownTimeouts = new OracleTimeoutThreadPerVM[2];
        this.count = 0;
        this.sleepMillis = Long.parseLong(OracleDriver.getSystemProperty(pollIntervalProperty, pollIntervalDefault));
        this.start();
    }

    public synchronized void addTimeout(OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM) {
        int n = 0;
        if (this.count >= this.knownTimeouts.length) {
            OracleTimeoutThreadPerVM[] oracleTimeoutThreadPerVMArray = new OracleTimeoutThreadPerVM[this.knownTimeouts.length * 4];
            System.arraycopy(this.knownTimeouts, 0, oracleTimeoutThreadPerVMArray, 0, this.knownTimeouts.length);
            n = this.knownTimeouts.length;
            this.knownTimeouts = oracleTimeoutThreadPerVMArray;
        }
        while (n < this.knownTimeouts.length) {
            if (this.knownTimeouts[n] == null) {
                this.knownTimeouts[n] = oracleTimeoutThreadPerVM;
                ++this.count;
                break;
            }
            ++n;
        }
    }

    public synchronized void removeTimeout(OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM) {
        int n = 0;
        while (n < this.knownTimeouts.length) {
            if (this.knownTimeouts[n] == oracleTimeoutThreadPerVM) {
                this.knownTimeouts[n] = null;
                --this.count;
                break;
            }
            ++n;
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.pollOnce();
        }
    }

    private void pollOnce() {
        if (this.count > 0) {
            long l = System.currentTimeMillis();
            int n = 0;
            while (n < this.knownTimeouts.length) {
                try {
                    if (this.knownTimeouts[n] != null) {
                        this.knownTimeouts[n].interruptIfAppropriate(l);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ++n;
            }
        }
    }
}

