/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.CharConvBuilder;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;

public class TokenParser {
    static final String NAME = "name";
    static final String ID = "id";
    static final String FLAGS = "flags";
    static final String BASECHAR = "base_char_set";
    static final String REPLACEMENTCHAR = "default_replacement_char";
    static final String MBREPLACEMENTCHAR = "default_multibyte_replacement_char";
    static final String CHARACTERDATA = "character_data";
    static final String XTRAUNICODEMAPPING = "replacement_chars";
    static final String MULTIBYTEEQUIVALENT = "multi_byte_equivalent";
    static final int ST_UNKNOWN = -1;
    static final int ST_BEGIN = 0;
    static final int ST_STRING = 1;
    static final int ST_STRINGCONNECTION = 2;
    static final int ST_EQUALSIGN = 3;
    static final int ST_HEXZERO0 = 4;
    static final int ST_HEXNUMBER0 = 5;
    static final int ST_BEGINMAPPING = 6;
    static final int ST_OPENBRACE = 6;
    static final int ST_HEXZERO1 = 7;
    static final int ST_HEXNUMBER1 = 8;
    static final int ST_MAPSEPARATOR = 9;
    static final int ST_HEXZERO2 = 10;
    static final int ST_HEXNUMBER2 = 11;
    static final int ST_PAIRSEPARATOR = 12;
    static final int ST_ENDMAPPING = 13;
    static final int ST_ENDBRACE = 13;
    static final int ST_HAVESOURCECP = 14;
    static final int ST_HAVETARGETCP = 15;
    static final int DT_LINE = 1;
    static final int DT_BRACE = 2;

    static final int processSyntaxError(StreamTokenizer streamTokenizer, int n) throws IOException {
        System.err.println("Syntax error at line " + streamTokenizer.lineno());
        TokenParser.skipToEndOfDelimiter(streamTokenizer, n);
        return 0;
    }

    static String getString(StreamTokenizer streamTokenizer, int n) throws IOException {
        int n2;
        if (streamTokenizer.ttype == n || streamTokenizer.ttype == -1 || streamTokenizer.ttype == 10) {
            return "";
        }
        String string = streamTokenizer.sval;
        while ((n2 = streamTokenizer.nextToken()) != -1 && n2 != 10 && n2 != n) {
            string = string + streamTokenizer.sval;
        }
        return string;
    }

    static int getInteger(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.ttype != -2) {
            throw new NumberFormatException();
        }
        if (streamTokenizer.nval != 0.0) {
            return (int)streamTokenizer.nval;
        }
        int n = streamTokenizer.nextToken();
        if (n == -3) {
            return TokenParser.hexToInt(streamTokenizer.sval);
        }
        throw new NumberFormatException();
    }

    static final int hexToInt(String string) throws NumberFormatException {
        string.toLowerCase();
        if (string.length() < 2 || string.indexOf(120) != 0) {
            throw new NumberFormatException();
        }
        return Integer.parseInt(string.substring(1), 16);
    }

    static long getLong(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.ttype != -2) {
            throw new NumberFormatException();
        }
        if (streamTokenizer.nval != 0.0) {
            return (long)streamTokenizer.nval & 0xFFFFFFFFL;
        }
        int n = streamTokenizer.nextToken();
        if (n == -3) {
            return TokenParser.hexToLong(streamTokenizer.sval);
        }
        throw new NumberFormatException();
    }

    static final long hexToLong(String string) throws NumberFormatException {
        string.toLowerCase();
        if (string.length() < 2 || string.indexOf(120) != 0) {
            throw new NumberFormatException();
        }
        return Long.parseLong(string.substring(1), 16);
    }

    static String intToHex(int n) {
        String string = Integer.toHexString(n);
        return "0x000".substring(0, 6 - string.length()) + string;
    }

    static final void skipToEndOfDelimiter(StreamTokenizer streamTokenizer, int n) throws IOException {
        if (n == 2) {
            TokenParser.skipToCloseBrace(streamTokenizer);
        } else {
            TokenParser.skipToEol(streamTokenizer);
        }
    }

    static final void skipToEol(StreamTokenizer streamTokenizer) throws IOException {
        int n;
        streamTokenizer.eolIsSignificant(true);
        while ((n = streamTokenizer.nextToken()) != 10 && n != -1) {
        }
        streamTokenizer.eolIsSignificant(false);
    }

    static final void skipToCloseBrace(StreamTokenizer streamTokenizer) throws IOException {
        int n;
        int n2 = 1;
        while ((n = streamTokenizer.nextToken()) != -1) {
            switch (n) {
                case 123: {
                    ++n2;
                    break;
                }
                case 125: {
                    if (--n2 >= 1) break;
                    return;
                }
            }
        }
    }

    static StreamTokenizer getTokenizer(FileInputStream fileInputStream) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new InputStreamReader(fileInputStream)));
        streamTokenizer.commentChar(35);
        streamTokenizer.lowerCaseMode(true);
        streamTokenizer.quoteChar(34);
        return streamTokenizer;
    }

    static final void printToken(StreamTokenizer streamTokenizer, int n) {
        switch (n) {
            case -3: {
                System.err.println(streamTokenizer.sval);
                break;
            }
            case -2: {
                System.err.println("Number " + streamTokenizer.nval);
                break;
            }
            case 10: {
                System.err.println("End of line");
                break;
            }
            default: {
                System.err.println("Unknown token " + (char)n);
            }
        }
    }

    static final boolean searchKeyword(String string, StreamTokenizer streamTokenizer) throws IOException {
        int n;
        boolean bl = false;
        String string2 = "";
        while ((n = streamTokenizer.nextToken()) != -1) {
            if (n == -3) {
                string2 = "";
                if ((string2 = string2 + streamTokenizer.sval).equals(string)) {
                    return true;
                }
            }
            TokenParser.skipToEol(streamTokenizer);
        }
        return false;
    }
}

