/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.util.builder.CharConvBuilder;
import oracle.i18n.util.builder.CharSetParser;
import oracle.i18n.util.builder.NLTParserException;
import oracle.sql.ConverterArchive;
import oracle.sql.converter.CharacterConverter1Byte;
import oracle.sql.converter.CharacterConverters;

public class CharConv1ByteBuilderJDBC
extends CharConvBuilder {
    static final boolean DEBUG = false;
    CharacterConverter1Byte charConv1ByteObj = new CharacterConverter1Byte();

    public void buildGLB(CharacterConverters characterConverters, String string, String string2, String string3, boolean bl) throws IOException {
        try {
            CharSetParser charSetParser = new CharSetParser(string3);
            String string4 = charSetParser.getName();
            this.charConv1ByteObj.m_oracleId = Integer.parseInt(charSetParser.getId());
            this.charConv1ByteObj.m_ucsReplacement = 65533;
            String string5 = charSetParser.getDefaultReplacementChar();
            if (string5 != null) {
                int n = CharConvBuilder.stringToInt(string5);
                if (((long)n & 0xFFFFFFFFL) > 255L) {
                    throw new NLTParserException("ReplacementChar too big");
                }
                this.charConv1ByteObj.m_oraCharReplacement = (byte)(n & 0xFF);
            }
            if (string4 == null || this.charConv1ByteObj.m_oracleId == 0) {
                System.err.println("Missing data in file " + string3);
                System.err.println("No output file created");
                return;
            }
            String string6 = CharConvBuilder.formatCharConvClassName(this.charConv1ByteObj.m_oracleId);
            if (characterConverters != null) {
                if (this.charConv1ByteObj.m_ucsReplacement == 0) {
                    this.charConv1ByteObj.m_ucsReplacement = characterConverters.getUCS2CharRep();
                }
                if (this.charConv1ByteObj.m_oraCharReplacement == 0) {
                    this.charConv1ByteObj.m_oraCharReplacement = (byte)(characterConverters.getOraChar1ByteRep() & 0xFF);
                }
            }
            if (this.charConv1ByteObj.m_oraCharReplacement == 0) {
                this.charConv1ByteObj.m_oraCharReplacement = (byte)63;
            }
            this.setUcsChar(charSetParser, characterConverters);
            this.setExtraUnicodeMapping(charSetParser, characterConverters);
            if (this.charConv1ByteObj != null) {
                ConverterArchive converterArchive = new ConverterArchive();
                try {
                    if (bl) {
                        converterArchive.insertObjtoFile(string, string6 + ".glb", (Object)this.charConv1ByteObj);
                    } else {
                        converterArchive.insertSingleObj(string2, (Object)this.charConv1ByteObj, "/oracle/i18n/data/" + string6 + ".glb");
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                    return;
                }
            }
            return;
        }
        catch (NLTParserException nLTParserException) {
            System.out.println(nLTParserException.getMessage());
            return;
        }
    }

    private void setExtraUnicodeMapping(CharSetParser charSetParser, CharacterConverters characterConverters) throws NLTParserException {
        Vector vector;
        Vector vector2 = new Vector();
        if (characterConverters != null) {
            characterConverters.extractExtraMappings(vector2);
        }
        if (this.charConv1ByteObj.extraUnicodeToOracleMapping != null) {
            this.charConv1ByteObj.extractExtraMappings(vector2);
        }
        if ((vector = charSetParser.getReplacementChars()) != null) {
            int n = vector.size();
            try {
                int n2 = 0;
                while (n2 < n) {
                    Object[] objectArray = (Object[])vector.elementAt(n2);
                    int n3 = ((int[])objectArray[0])[0];
                    int n4 = ((int[])objectArray[1])[0];
                    this.setExtraUnicodeMappingPair(n3, n4, vector2);
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new NLTParserException("bad number");
            }
        }
        this.finishExtraUnicodeMapping(vector2);
    }

    private void setExtraUnicodeMappingPair(int n, int n2, Vector vector) throws IOException {
        int[] nArray = new int[]{n = (int)CharConvBuilder.convertUTF32toUTF16((long)n & 0xFFFFFFFFL), n2};
        vector.addElement(nArray);
    }

    private void finishExtraUnicodeMapping(Vector vector) {
        int n = 0;
        int[] nArray = null;
        int n2 = vector.size();
        this.charConv1ByteObj.extraUnicodeToOracleMapping = new int[n2][2];
        n = 0;
        while (n < vector.size()) {
            nArray = (int[])vector.elementAt(n);
            this.charConv1ByteObj.extraUnicodeToOracleMapping[n][0] = nArray[0];
            this.charConv1ByteObj.extraUnicodeToOracleMapping[n][1] = nArray[1];
            ++n;
        }
    }

    private void setUcsChar(CharSetParser charSetParser, CharacterConverters characterConverters) throws NLTParserException {
        this.charConv1ByteObj.m_ucsChar = new int[256];
        int n = 0;
        while (n < 256) {
            this.charConv1ByteObj.m_ucsChar[n] = -1;
            ++n;
        }
        try {
            int n2;
            Vector vector;
            if (characterConverters != null) {
                vector = new Vector(65535, 28671);
                characterConverters.extractCodepoints(vector);
                n2 = 0;
                while (n2 < vector.size()) {
                    int[] nArray = (int[])vector.elementAt(n2);
                    this.setUcsCharPair(nArray[0], nArray[1]);
                    ++n2;
                }
            }
            vector = charSetParser.getCharacterData();
            int n3 = vector.size();
            n2 = 0;
            while (n2 < n3) {
                Object[] objectArray = (Object[])vector.elementAt(n2);
                int n4 = ((int[])objectArray[0])[0];
                int n5 = ((int[])objectArray[1])[0];
                this.setUcsCharPair(n4, n5);
                ++n2;
            }
            this.finishUcsChar();
        }
        catch (IOException iOException) {
            throw new NLTParserException("bad number");
        }
    }

    private void setUcsCharPair(int n, int n2) throws IOException {
        if (n >= 256) {
            System.err.println("***** Error: source code point " + Integer.toHexString(n) + " is too big for 1 byte converter");
            return;
        }
        if ((n2 = (int)CharConvBuilder.convertUTF32toUTF16((long)n2 & 0xFFFFFFFFL)) == 65533) {
            return;
        }
        this.charConv1ByteObj.m_ucsChar[n] = n2;
    }

    private void finishUcsChar() {
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Hashtable hashtable2 = new Hashtable();
        int n = 0;
        while (n <= 255) {
            int n2 = this.charConv1ByteObj.m_ucsChar[n];
            if (n2 != -1) {
                if (hashtable.get(new Integer(n2)) == null) {
                    hashtable.put(new Integer(n2), new Integer(n));
                } else {
                    hashtable2.put(new Integer(n2), hashtable.get(new Integer(n2)));
                }
            }
            ++n;
        }
        this.setDuplicateMapping(hashtable2);
    }

    private void setDuplicateMapping(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        this.charConv1ByteObj.extraUnicodeToOracleMapping = new int[hashtable.size()][2];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.charConv1ByteObj.extraUnicodeToOracleMapping[n][0] = (Integer)k;
            this.charConv1ByteObj.extraUnicodeToOracleMapping[n++][1] = (Integer)hashtable.get(k);
        }
    }
}

