/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.print.PrinterGraphics;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.plaf.IconUIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import sun.awt.AppContext;
import sun.font.FontDesignMetrics;
import sun.print.ProxyPrintGraphics;
import sun.security.action.GetPropertyAction;
import sun.swing.PrintColorUIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingUtilities2 {
    private static LSBCacheEntry[] fontCache;
    private static final int CACHE_SIZE = 6;
    private static int nextIndex;
    private static LSBCacheEntry searchKey;
    private static final int MIN_CHAR_INDEX = 87;
    private static final int MAX_CHAR_INDEX = 88;
    private static final FontRenderContext DEFAULT_FRC;
    public static final FontRenderContext AA_FRC;
    private static final boolean AA_TEXT;
    private static final boolean AA_TEXT_DEFINED;
    public static final Object AA_TEXT_PROPERTY_KEY;
    private static final StringBuilder SKIP_CLICK_COUNT;
    public static final boolean DRAG_FIX;
    private static Field inputEvent_CanAccessSystemClipboard_Field;
    private static final String UntrustedClipboardAccess = "UNTRUSTED_CLIPBOARD_ACCESS_KEY";

    private static boolean drawTextAntialiased(JComponent jComponent) {
        if (!AA_TEXT_DEFINED) {
            if (jComponent != null) {
                return (Boolean)jComponent.getClientProperty(AA_TEXT_PROPERTY_KEY);
            }
            return false;
        }
        return AA_TEXT;
    }

    public static boolean drawTextAntialiased(boolean bl) {
        if (!AA_TEXT_DEFINED) {
            return bl;
        }
        return AA_TEXT;
    }

    public static int getLeftSideBearing(JComponent jComponent, FontMetrics fontMetrics, String string) {
        return SwingUtilities2.getLeftSideBearing(jComponent, fontMetrics, string.charAt(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLeftSideBearing(JComponent jComponent, FontMetrics fontMetrics, char c) {
        char c2 = c;
        if (c2 < 'X' && c2 >= 'W') {
            Object var4_4 = null;
            FontRenderContext fontRenderContext = SwingUtilities2.getFRC(jComponent, fontMetrics);
            Font font = fontMetrics.getFont();
            Class<SwingUtilities2> clazz = SwingUtilities2.class;
            synchronized (SwingUtilities2.class) {
                LSBCacheEntry lSBCacheEntry = null;
                if (searchKey == null) {
                    searchKey = new LSBCacheEntry(fontRenderContext, font);
                } else {
                    searchKey.reset(fontRenderContext, font);
                }
                for (LSBCacheEntry lSBCacheEntry2 : fontCache) {
                    if (!searchKey.equals(lSBCacheEntry2)) continue;
                    lSBCacheEntry = lSBCacheEntry2;
                    break;
                }
                if (lSBCacheEntry == null) {
                    lSBCacheEntry = searchKey;
                    SwingUtilities2.fontCache[SwingUtilities2.nextIndex] = searchKey;
                    searchKey = null;
                    nextIndex = (nextIndex + 1) % 6;
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return lSBCacheEntry.getLeftSideBearing(c);
            }
        }
        return 0;
    }

    public static FontMetrics getFontMetrics(JComponent jComponent, Graphics graphics) {
        return SwingUtilities2.getFontMetrics(jComponent, graphics, graphics.getFont());
    }

    public static FontMetrics getFontMetrics(JComponent jComponent, Graphics graphics, Font font) {
        if (jComponent != null) {
            return jComponent.getFontMetrics(font);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static int stringWidth(JComponent jComponent, FontMetrics fontMetrics, String string) {
        return fontMetrics.stringWidth(string);
    }

    public static String clipStringIfNecessary(JComponent jComponent, FontMetrics fontMetrics, String string, int n) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n2 = SwingUtilities2.stringWidth(jComponent, fontMetrics, string);
        if (n2 > n) {
            return SwingUtilities2.clipString(jComponent, fontMetrics, string, n);
        }
        return string;
    }

    public static String clipString(JComponent jComponent, FontMetrics fontMetrics, String string, int n) {
        int n2;
        String string2 = "...";
        int n3 = SwingUtilities2.stringWidth(jComponent, fontMetrics, string2);
        int n4 = string.length();
        for (n2 = 0; n2 < n4 && (n3 += fontMetrics.charWidth(string.charAt(n2))) <= n; ++n2) {
        }
        string = string.substring(0, n2) + string2;
        return string;
    }

    private static FontRenderContext getFRC(JComponent jComponent, FontMetrics fontMetrics) {
        if (fontMetrics instanceof FontDesignMetrics) {
            return ((FontDesignMetrics)fontMetrics).getFRC();
        }
        if (fontMetrics == null && jComponent != null) {
            return SwingUtilities2.getFRC(jComponent, jComponent.getFontMetrics(jComponent.getFont()));
        }
        assert (false);
        return DEFAULT_FRC;
    }

    public static void drawString(JComponent jComponent, Graphics graphics, String string, int n, int n2) {
        Graphics2D graphics2D;
        if (string == null || string.length() <= 0) {
            return;
        }
        if (SwingUtilities2.isPrinting(graphics) && (graphics2D = SwingUtilities2.getGraphics2D(graphics)) != null) {
            TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), DEFAULT_FRC);
            Color color = graphics2D.getColor();
            if (color instanceof PrintColorUIResource) {
                graphics2D.setColor(((PrintColorUIResource)color).getPrintColor());
            }
            textLayout.draw(graphics2D, n, n2);
            graphics2D.setColor(color);
            return;
        }
        if (SwingUtilities2.drawTextAntialiased(jComponent) && graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawString(string, n, n2);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            graphics.drawString(string, n, n2);
        }
    }

    public static void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n, int n2, int n3) {
        SwingUtilities2.drawString(jComponent, graphics, string, n2, n3);
        if (n >= 0 && n < string.length()) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = n2 + SwingUtilities2.stringWidth(jComponent, fontMetrics, string.substring(0, n));
            int n5 = n3;
            int n6 = fontMetrics.charWidth(string.charAt(n));
            int n7 = 1;
            graphics.fillRect(n4, n5 + 1, n6, n7);
        }
    }

    public static int loc2IndexFileList(JList jList, Point point) {
        Object object;
        int n = jList.locationToIndex(point);
        if (n != -1 && (object = jList.getClientProperty("List.isFileList")) instanceof Boolean && ((Boolean)object).booleanValue() && !SwingUtilities2.pointIsInActualBounds(jList, n, point)) {
            n = -1;
        }
        return n;
    }

    private static boolean pointIsInActualBounds(JList jList, int n, Point point) {
        ListCellRenderer listCellRenderer = jList.getCellRenderer();
        ListModel listModel = jList.getModel();
        Object object = listModel.getElementAt(n);
        Component component = listCellRenderer.getListCellRendererComponent(jList, object, n, false, false);
        Dimension dimension = component.getPreferredSize();
        Rectangle rectangle = jList.getCellBounds(n, n);
        if (!component.getComponentOrientation().isLeftToRight()) {
            rectangle.x += rectangle.width - dimension.width;
        }
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        return rectangle.contains(point);
    }

    public static boolean pointOutsidePrefSize(JTable jTable, int n, int n2, Point point) {
        if (jTable.convertColumnIndexToModel(n2) != 0 || n == -1) {
            return true;
        }
        TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, n2);
        Object object = jTable.getValueAt(n, n2);
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, n, n2);
        Dimension dimension = component.getPreferredSize();
        Rectangle rectangle = jTable.getCellRect(n, n2, false);
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        assert (point.x >= rectangle.x && point.y >= rectangle.y);
        return point.x > rectangle.x + rectangle.width || point.y > rectangle.y + rectangle.height;
    }

    public static boolean shouldIgnore(MouseEvent mouseEvent, JComponent jComponent) {
        return jComponent == null || !jComponent.isEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent);
    }

    public static void adjustFocus(JComponent jComponent) {
        if (!jComponent.hasFocus() && jComponent.isRequestFocusEnabled()) {
            jComponent.requestFocus();
        }
    }

    public static int drawChars(JComponent jComponent, Graphics graphics, char[] cArray, int n, int n2, int n3, int n4) {
        Object object;
        Graphics2D graphics2D;
        if (n2 <= 0) {
            return n3;
        }
        int n5 = n3 + SwingUtilities2.getFontMetrics(jComponent, graphics).charsWidth(cArray, n, n2);
        if (SwingUtilities2.isPrinting(graphics) && (graphics2D = SwingUtilities2.getGraphics2D(graphics)) != null) {
            object = graphics2D.getFontRenderContext();
            FontRenderContext fontRenderContext = SwingUtilities2.getFRC(jComponent, null);
            if (fontRenderContext.isAntiAliased() || fontRenderContext.usesFractionalMetrics()) {
                fontRenderContext = new FontRenderContext(fontRenderContext.getTransform(), false, false);
            }
            if (fontRenderContext != null && !SwingUtilities2.isFontRenderContextCompatible((FontRenderContext)object, fontRenderContext)) {
                TextLayout textLayout = new TextLayout(new String(cArray, n, n2), graphics2D.getFont(), fontRenderContext);
                Color color = graphics2D.getColor();
                if (color instanceof PrintColorUIResource) {
                    graphics2D.setColor(((PrintColorUIResource)color).getPrintColor());
                }
                textLayout.draw(graphics2D, n3, n4);
                graphics2D.setColor(color);
                return n5;
            }
        }
        if (SwingUtilities2.drawTextAntialiased(jComponent) && graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawChars(cArray, n, n2, n3, n4);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            graphics.drawChars(cArray, n, n2, n3, n4);
        }
        return n5;
    }

    public static float drawString(JComponent jComponent, Graphics graphics, AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        float f;
        Graphics2D graphics2D;
        boolean bl = SwingUtilities2.isPrinting(graphics);
        Color color = graphics.getColor();
        if (bl && color instanceof PrintColorUIResource) {
            graphics.setColor(((PrintColorUIResource)color).getPrintColor());
        }
        if ((graphics2D = SwingUtilities2.getGraphics2D(graphics)) == null) {
            graphics.drawString(attributedCharacterIterator, n, n2);
            f = n;
        } else {
            FontRenderContext fontRenderContext;
            if (bl) {
                fontRenderContext = SwingUtilities2.getFRC(jComponent, null);
                if (fontRenderContext.isAntiAliased() || fontRenderContext.usesFractionalMetrics()) {
                    fontRenderContext = new FontRenderContext(fontRenderContext.getTransform(), false, false);
                }
            } else {
                fontRenderContext = SwingUtilities2.drawTextAntialiased(jComponent) ? AA_FRC : graphics2D.getFontRenderContext();
            }
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, fontRenderContext);
            textLayout.draw(graphics2D, n, n2);
            f = textLayout.getAdvance();
        }
        if (bl) {
            graphics.setColor(color);
        }
        return f;
    }

    public static boolean isFontRenderContextCompatible(FontRenderContext fontRenderContext, FontRenderContext fontRenderContext2) {
        return fontRenderContext != null ? fontRenderContext.equals(fontRenderContext2) : fontRenderContext2 == null;
    }

    public static Graphics2D getGraphics2D(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            return (Graphics2D)graphics;
        }
        if (graphics instanceof ProxyPrintGraphics) {
            return (Graphics2D)((ProxyPrintGraphics)graphics).getGraphics();
        }
        return null;
    }

    public static FontRenderContext getFontRenderContext(Component component) {
        if (component == null) {
            return DEFAULT_FRC;
        }
        return SwingUtilities2.getFRC(null, component.getFontMetrics(component.getFont()));
    }

    static boolean isPrinting(Graphics graphics) {
        return graphics instanceof PrinterGraphics || graphics instanceof PrintGraphics;
    }

    public static boolean useSelectedTextColor(Highlighter.Highlight highlight, JTextComponent jTextComponent) {
        Highlighter.HighlightPainter highlightPainter = highlight.getPainter();
        String string = highlightPainter.getClass().getName();
        if (string.indexOf("javax.swing.text.DefaultHighlighter") != 0 && string.indexOf("com.sun.java.swing.plaf.windows.WindowsTextUI") != 0) {
            return false;
        }
        try {
            DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = (DefaultHighlighter.DefaultHighlightPainter)highlightPainter;
            if (defaultHighlightPainter.getColor() != null && !defaultHighlightPainter.getColor().equals(jTextComponent.getSelectionColor())) {
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }

    public static boolean canAccessSystemClipboard() {
        boolean bl = false;
        if (!GraphicsEnvironment.isHeadless()) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                bl = true;
            } else {
                try {
                    securityManager.checkSystemClipboardAccess();
                    bl = true;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (bl && !SwingUtilities2.isTrustedContext()) {
                    bl = SwingUtilities2.canCurrentEventAccessSystemClipboard(true);
                }
            }
        }
        return bl;
    }

    public static boolean canCurrentEventAccessSystemClipboard() {
        return SwingUtilities2.isTrustedContext() || SwingUtilities2.canCurrentEventAccessSystemClipboard(false);
    }

    public static boolean canEventAccessSystemClipboard(AWTEvent aWTEvent) {
        return SwingUtilities2.isTrustedContext() || SwingUtilities2.canEventAccessSystemClipboard(aWTEvent, false);
    }

    private static synchronized boolean inputEvent_canAccessSystemClipboard(InputEvent inputEvent) {
        if (inputEvent_CanAccessSystemClipboard_Field == null) {
            inputEvent_CanAccessSystemClipboard_Field = (Field)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Field field = null;
                    try {
                        field = InputEvent.class.getDeclaredField("canAccessSystemClipboard");
                        field.setAccessible(true);
                        return field;
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        if (inputEvent_CanAccessSystemClipboard_Field == null) {
            return false;
        }
        boolean bl = false;
        try {
            bl = inputEvent_CanAccessSystemClipboard_Field.getBoolean(inputEvent);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return bl;
    }

    private static boolean isAccessClipboardGesture(InputEvent inputEvent) {
        boolean bl = false;
        if (inputEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getModifiers();
            switch (n) {
                case 67: 
                case 86: 
                case 88: {
                    bl = n2 == 2;
                    break;
                }
                case 155: {
                    bl = n2 == 2 || n2 == 1;
                    break;
                }
                case 65485: 
                case 65487: 
                case 65489: {
                    bl = true;
                    break;
                }
                case 127: {
                    bl = n2 == 1;
                }
            }
        }
        return bl;
    }

    private static boolean canEventAccessSystemClipboard(AWTEvent aWTEvent, boolean bl) {
        if (EventQueue.isDispatchThread()) {
            if (aWTEvent instanceof InputEvent && (!bl || SwingUtilities2.isAccessClipboardGesture((InputEvent)aWTEvent))) {
                return SwingUtilities2.inputEvent_canAccessSystemClipboard((InputEvent)aWTEvent);
            }
            return false;
        }
        return true;
    }

    private static boolean canCurrentEventAccessSystemClipboard(boolean bl) {
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        return SwingUtilities2.canEventAccessSystemClipboard(aWTEvent, bl);
    }

    private static boolean isTrustedContext() {
        return System.getSecurityManager() == null || AppContext.getAppContext().get(UntrustedClipboardAccess) == null;
    }

    public static String displayPropertiesToCSS(Font font, Color color) {
        StringBuffer stringBuffer = new StringBuffer("body {");
        if (font != null) {
            stringBuffer.append(" font-family: ");
            stringBuffer.append(font.getFamily());
            stringBuffer.append(" ; ");
            stringBuffer.append(" font-size: ");
            stringBuffer.append(font.getSize());
            stringBuffer.append("pt ;");
            if (font.isBold()) {
                stringBuffer.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                stringBuffer.append(" font-style: italic ; ");
            }
        }
        if (color != null) {
            stringBuffer.append(" color: #");
            if (color.getRed() < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(color.getRed()));
            if (color.getGreen() < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(color.getGreen()));
            if (color.getBlue() < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(color.getBlue()));
            stringBuffer.append(" ; ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public static Object makeIcon(final Class<?> clazz, final Class<?> clazz2, final String string) {
        return new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                byte[] byArray = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            int n;
                            InputStream inputStream = null;
                            for (Class clazz = clazz; clazz != null && (inputStream = clazz.getResourceAsStream(string)) == null && clazz != clazz2; clazz = clazz.getSuperclass()) {
                            }
                            if (inputStream == null) {
                                return null;
                            }
                            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                            byte[] byArray = new byte[1024];
                            while ((n = bufferedInputStream.read(byArray)) > 0) {
                                byteArrayOutputStream.write(byArray, 0, n);
                            }
                            bufferedInputStream.close();
                            byteArrayOutputStream.flush();
                            return byteArrayOutputStream.toByteArray();
                        }
                        catch (IOException iOException) {
                            System.err.println(iOException.toString());
                            return null;
                        }
                    }
                });
                if (byArray == null) {
                    return null;
                }
                if (byArray.length == 0) {
                    System.err.println("warning: " + string + " is zero-length");
                    return null;
                }
                return new IconUIResource(new ImageIcon(byArray));
            }
        };
    }

    public static void setSkipClickCount(Component component, int n) {
        if (component instanceof JTextComponent && ((JTextComponent)component).getCaret() instanceof DefaultCaret) {
            ((JTextComponent)component).putClientProperty(SKIP_CLICK_COUNT, n);
        }
    }

    public static int getAdjustedClickCount(JTextComponent jTextComponent, MouseEvent mouseEvent) {
        int n = mouseEvent.getClickCount();
        if (n == 1) {
            jTextComponent.putClientProperty(SKIP_CLICK_COUNT, null);
        } else {
            Integer n2 = (Integer)jTextComponent.getClientProperty(SKIP_CLICK_COUNT);
            if (n2 != null) {
                return n - n2;
            }
        }
        return n;
    }

    static {
        DEFAULT_FRC = new FontRenderContext(null, false, false);
        AA_TEXT_PROPERTY_KEY = new StringBuffer("AATextPropertyKey");
        SKIP_CLICK_COUNT = new StringBuilder("skipClickCount");
        inputEvent_CanAccessSystemClipboard_Field = null;
        fontCache = new LSBCacheEntry[6];
        Object t = AccessController.doPrivileged(new GetPropertyAction("swing.aatext"));
        AA_TEXT_DEFINED = t != null;
        AA_TEXT = "true".equals(t);
        AA_FRC = new FontRenderContext(null, true, false);
        Object t2 = AccessController.doPrivileged(new GetPropertyAction("sun.swing.enableImprovedDragGesture"));
        DRAG_FIX = t2 != null;
    }

    private static class LSBCacheEntry {
        private static final byte UNSET = 127;
        private static final char[] oneChar = new char[1];
        private byte[] lsbCache = new byte[1];
        private Font font;
        private FontRenderContext frc;

        public LSBCacheEntry(FontRenderContext fontRenderContext, Font font) {
            this.reset(fontRenderContext, font);
        }

        public void reset(FontRenderContext fontRenderContext, Font font) {
            this.font = font;
            this.frc = fontRenderContext;
            for (int i = this.lsbCache.length - 1; i >= 0; --i) {
                this.lsbCache[i] = 127;
            }
        }

        public int getLeftSideBearing(char c) {
            int n = c - 87;
            assert (n >= 0 && n < 1);
            byte by = this.lsbCache[n];
            if (by == 127) {
                LSBCacheEntry.oneChar[0] = c;
                GlyphVector glyphVector = this.font.createGlyphVector(this.frc, oneChar);
                this.lsbCache[n] = by = (byte)glyphVector.getGlyphPixelBounds((int)0, (FontRenderContext)this.frc, (float)0.0f, (float)0.0f).x;
            }
            return by;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof LSBCacheEntry)) {
                return false;
            }
            LSBCacheEntry lSBCacheEntry = (LSBCacheEntry)object;
            return this.font.equals(lSBCacheEntry.font) && this.frc.equals(lSBCacheEntry.frc);
        }

        public int hashCode() {
            int n = 17;
            if (this.font != null) {
                n = 37 * n + this.font.hashCode();
            }
            if (this.frc != null) {
                n = 37 * n + this.frc.hashCode();
            }
            return n;
        }
    }
}

