/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jlex.internal;

import com.sun.jlex.internal.CNfa;
import com.sun.jlex.internal.CSet;
import com.sun.jlex.internal.CSpec;
import com.sun.jlex.internal.SparseBitSet;
import java.util.Enumeration;
import java.util.Hashtable;

class CSimplifyNfa {
    private int[] ccls;
    private int original_charset_size;
    private int mapped_charset_size;

    CSimplifyNfa() {
    }

    void simplify(CSpec cSpec) {
        this.computeClasses(cSpec);
        Enumeration enumeration = cSpec.m_nfa_states.elements();
        while (enumeration.hasMoreElements()) {
            CNfa cNfa = (CNfa)enumeration.nextElement();
            if (cNfa.m_edge == -2 || cNfa.m_edge == -3) continue;
            if (cNfa.m_edge == -1) {
                CSet cSet = new CSet();
                cSet.map(cNfa.m_set, this.ccls);
                cNfa.m_set = cSet;
                continue;
            }
            cNfa.m_edge = this.ccls[cNfa.m_edge];
        }
        cSpec.m_ccls_map = this.ccls;
        cSpec.m_dtrans_ncols = this.mapped_charset_size;
    }

    private void computeClasses(CSpec cSpec) {
        this.original_charset_size = cSpec.m_dtrans_ncols;
        this.ccls = new int[this.original_charset_size];
        int n = 1;
        SparseBitSet sparseBitSet = new SparseBitSet();
        SparseBitSet sparseBitSet2 = new SparseBitSet();
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        System.out.print("Working on character classes.");
        Enumeration enumeration = cSpec.m_nfa_states.elements();
        while (enumeration.hasMoreElements()) {
            int n2;
            CNfa cNfa = (CNfa)enumeration.nextElement();
            if (cNfa.m_edge == -2 || cNfa.m_edge == -3) continue;
            sparseBitSet.clearAll();
            sparseBitSet2.clearAll();
            for (n2 = 0; n2 < this.ccls.length; ++n2) {
                if (cNfa.m_edge == n2 || cNfa.m_edge == -1 && cNfa.m_set.contains(n2)) {
                    sparseBitSet.set(this.ccls[n2]);
                    continue;
                }
                sparseBitSet2.set(this.ccls[n2]);
            }
            sparseBitSet.and(sparseBitSet2);
            System.out.print(sparseBitSet.size() == 0 ? "." : ":");
            if (sparseBitSet.size() == 0) continue;
            hashtable.clear();
            for (n2 = 0; n2 < this.ccls.length; ++n2) {
                if (!sparseBitSet.get(this.ccls[n2]) || cNfa.m_edge != n2 && (cNfa.m_edge != -1 || !cNfa.m_set.contains(n2))) continue;
                Integer n3 = new Integer(this.ccls[n2]);
                if (!hashtable.containsKey(n3)) {
                    hashtable.put(n3, new Integer(n++));
                }
                this.ccls[n2] = (Integer)hashtable.get(n3);
            }
        }
        System.out.println();
        System.out.println("NFA has " + n + " distinct character classes.");
        this.mapped_charset_size = n;
    }
}

