/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthPopupMenuUI;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;
import sun.swing.plaf.synth.SynthIcon;
import sun.swing.plaf.synth.SynthUI;

class SynthMenuItemUI
extends BasicMenuItemUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private SynthStyle accStyle;
    private String acceleratorDelimiter;
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    SynthMenuItemUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthMenuItemUI();
    }

    static Dimension getPreferredMenuItemSize(SynthContext synthContext, SynthContext synthContext2, boolean bl, JComponent jComponent, Icon icon, Icon icon2, int n, String string) {
        Object object;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = jMenuItem.getIcon();
        String string2 = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string3 = "";
        if (keyStroke != null) {
            int n2;
            int n3 = keyStroke.getModifiers();
            if (n3 > 0) {
                string3 = KeyEvent.getKeyModifiersText(n3);
                string3 = string3 + string;
            }
            string3 = (n2 = keyStroke.getKeyCode()) != 0 ? string3 + KeyEvent.getKeyText(n2) : string3 + keyStroke.getKeyChar();
        }
        Font font = synthContext.getStyle().getFont(synthContext);
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getFontMetrics(synthContext2.getStyle().getFont(synthContext2));
        SynthMenuItemUI.resetRects();
        SynthMenuItemUI.layoutMenuItem(synthContext, fontMetrics, synthContext2, string2, fontMetrics2, string3, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, string2 == null ? 0 : n, n, bl);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(SynthMenuItemUI.iconRect.x, SynthMenuItemUI.iconRect.y, SynthMenuItemUI.iconRect.width, SynthMenuItemUI.iconRect.height, r);
        Container container = jMenuItem.getParent();
        if (container instanceof JPopupMenu) {
            object = (SynthPopupMenuUI)SynthLookAndFeel.getUIOfType(((JPopupMenu)container).getUI(), SynthPopupMenuUI.class);
            if (object != null) {
                SynthMenuItemUI.r.width = ((SynthPopupMenuUI)object).adjustTextWidth(SynthMenuItemUI.r.width);
                ((SynthPopupMenuUI)object).adjustAcceleratorWidth(SynthMenuItemUI.acceleratorRect.width);
                SynthMenuItemUI.r.width += ((SynthPopupMenuUI)object).getMaxAcceleratorWidth();
            }
        } else if (!(container == null || jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu())) {
            SynthMenuItemUI.r.width += SynthMenuItemUI.acceleratorRect.width;
        }
        if (bl) {
            SynthMenuItemUI.r.width += SynthMenuItemUI.checkIconRect.width;
            SynthMenuItemUI.r.width += n;
            SynthMenuItemUI.r.width += n;
            SynthMenuItemUI.r.width += SynthMenuItemUI.arrowIconRect.width;
        }
        SynthMenuItemUI.r.width += 2 * n;
        object = jMenuItem.getInsets();
        if (object != null) {
            SynthMenuItemUI.r.width += ((Insets)object).left + ((Insets)object).right;
            SynthMenuItemUI.r.height += ((Insets)object).top + ((Insets)object).bottom;
        }
        if (SynthMenuItemUI.r.width % 2 == 0) {
            ++SynthMenuItemUI.r.width;
        }
        if (SynthMenuItemUI.r.height % 2 == 0) {
            ++SynthMenuItemUI.r.height;
        }
        return r.getSize();
    }

    static void paint(SynthContext synthContext, SynthContext synthContext2, Graphics graphics, Icon icon, Icon icon2, boolean bl, String string, int n) {
        int n2;
        JComponent jComponent = synthContext.getComponent();
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        Insets insets = jMenuItem.getInsets();
        SynthMenuItemUI.resetRects();
        viewRect.setBounds(0, 0, jMenuItem.getWidth(), jMenuItem.getHeight());
        SynthMenuItemUI.viewRect.x += insets.left;
        SynthMenuItemUI.viewRect.y += insets.top;
        SynthMenuItemUI.viewRect.width -= insets.right + SynthMenuItemUI.viewRect.x;
        SynthMenuItemUI.viewRect.height -= insets.bottom + SynthMenuItemUI.viewRect.y;
        SynthStyle synthStyle = synthContext.getStyle();
        Font font = synthStyle.getFont(synthContext);
        graphics.setFont(font);
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics, font);
        FontMetrics fontMetrics2 = SwingUtilities2.getFontMetrics(jComponent, graphics, synthContext2.getStyle().getFont(synthContext2));
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        if (keyStroke != null) {
            int n3 = keyStroke.getModifiers();
            if (n3 > 0) {
                string2 = KeyEvent.getKeyModifiersText(n3);
                string2 = string2 + string;
            }
            string2 = (n2 = keyStroke.getKeyCode()) != 0 ? string2 + KeyEvent.getKeyText(n2) : string2 + keyStroke.getKeyChar();
        }
        String string3 = SynthMenuItemUI.layoutMenuItem(synthContext, fontMetrics, synthContext2, jMenuItem.getText(), fontMetrics2, string2, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, jMenuItem.getText() == null ? 0 : n, n, bl);
        if (icon != null && bl) {
            SynthIcon.paintIcon(icon, synthContext, graphics, SynthMenuItemUI.checkIconRect.x, SynthMenuItemUI.checkIconRect.y, SynthMenuItemUI.checkIconRect.width, SynthMenuItemUI.checkIconRect.height);
        }
        if (jMenuItem.getIcon() != null) {
            Icon icon3;
            if (!buttonModel.isEnabled()) {
                icon3 = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon3 = jMenuItem.getPressedIcon();
                if (icon3 == null) {
                    icon3 = jMenuItem.getIcon();
                }
            } else {
                icon3 = jMenuItem.getIcon();
            }
            if (icon3 != null) {
                SynthIcon.paintIcon(icon3, synthContext, graphics, SynthMenuItemUI.iconRect.x, SynthMenuItemUI.iconRect.y, SynthMenuItemUI.iconRect.width, SynthMenuItemUI.iconRect.height);
            }
        }
        if (string3 != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textRect);
            } else {
                graphics.setColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
                graphics.setFont(synthStyle.getFont(synthContext));
                synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, string3, SynthMenuItemUI.textRect.x, SynthMenuItemUI.textRect.y, jMenuItem.getDisplayedMnemonicIndex());
            }
        }
        if (string2 != null && !string2.equals("")) {
            int n4;
            Object object;
            n2 = 0;
            Container container = jMenuItem.getParent();
            if (container != null && container instanceof JPopupMenu && (object = (SynthPopupMenuUI)((JPopupMenu)container).getUI()) != null && (n4 = ((SynthPopupMenuUI)object).getMaxAcceleratorWidth()) > 0) {
                n2 = n4 - SynthMenuItemUI.acceleratorRect.width;
            }
            object = synthContext2.getStyle();
            graphics.setColor(((SynthStyle)object).getColor(synthContext2, ColorType.TEXT_FOREGROUND));
            graphics.setFont(((SynthStyle)object).getFont(synthContext2));
            ((SynthStyle)object).getGraphicsUtils(synthContext2).paintText(synthContext2, graphics, string2, SynthMenuItemUI.acceleratorRect.x - n2, SynthMenuItemUI.acceleratorRect.y, -1);
        }
        if (icon2 != null && bl) {
            SynthIcon.paintIcon(icon2, synthContext, graphics, SynthMenuItemUI.arrowIconRect.x, SynthMenuItemUI.arrowIconRect.y, SynthMenuItemUI.arrowIconRect.width, SynthMenuItemUI.arrowIconRect.height);
        }
    }

    private static String layoutMenuItem(SynthContext synthContext, FontMetrics fontMetrics, SynthContext synthContext2, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, int n6, boolean bl) {
        Object object;
        synthContext.getStyle().getGraphicsUtils(synthContext).layoutText(synthContext, fontMetrics, string, icon, n2, n, n4, n3, rectangle, rectangle2, rectangle3, n5);
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            object = synthContext2.getStyle();
            rectangle4.width = ((SynthStyle)object).getGraphicsUtils(synthContext2).computeStringWidth(synthContext2, fontMetrics2.getFont(), fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (bl) {
            if (icon2 != null) {
                rectangle5.width = SynthIcon.getIconWidth(icon2, synthContext);
                rectangle5.height = SynthIcon.getIconHeight(icon2, synthContext);
            } else {
                rectangle5.height = 0;
                rectangle5.width = 0;
            }
            if (icon3 != null) {
                rectangle6.width = SynthIcon.getIconWidth(icon3, synthContext);
                rectangle6.height = SynthIcon.getIconHeight(icon3, synthContext);
            } else {
                rectangle6.height = 0;
                rectangle6.width = 0;
            }
        }
        object = rectangle2.union(rectangle3);
        if (SynthLookAndFeel.isLeftToRight(synthContext.getComponent())) {
            rectangle3.x += n6;
            rectangle2.x += n6;
            rectangle4.x = rectangle.x + rectangle.width - rectangle6.width - n6 - rectangle4.width;
            if (bl) {
                rectangle5.x = rectangle.x + n6;
                rectangle3.x += n6 + rectangle5.width;
                rectangle2.x += n6 + rectangle5.width;
                rectangle6.x = rectangle.x + rectangle.width - n6 - rectangle6.width;
            }
        } else {
            rectangle3.x -= n6;
            rectangle2.x -= n6;
            rectangle4.x = rectangle.x + rectangle6.width + n6;
            if (bl) {
                rectangle5.x = rectangle.x + rectangle.width - n6 - rectangle5.width;
                rectangle3.x -= n6 + rectangle5.width;
                rectangle2.x -= n6 + rectangle5.width;
                rectangle6.x = rectangle.x + n6;
            }
        }
        rectangle4.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - rectangle4.height / 2;
        if (bl) {
            rectangle6.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - rectangle6.height / 2;
            rectangle5.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - rectangle5.height / 2;
        }
        return string;
    }

    private static void resetRects() {
        iconRect.setBounds(0, 0, 0, 0);
        textRect.setBounds(0, 0, 0, 0);
        acceleratorRect.setBounds(0, 0, 0, 0);
        checkIconRect.setBounds(0, 0, 0, 0);
        arrowIconRect.setBounds(0, 0, 0, 0);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(0, 0, 0, 0);
    }

    protected void installDefaults() {
        this.updateStyle(this.menuItem);
    }

    protected void installListeners() {
        super.installListeners();
        this.menuItem.addPropertyChangeListener(this);
    }

    private void updateStyle(JMenuItem jMenuItem) {
        Object object;
        SynthContext synthContext = this.getContext((JComponent)jMenuItem, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (synthStyle != this.style) {
            object = this.getPropertyPrefix();
            this.defaultTextIconGap = this.style.getInt(synthContext, (String)object + ".textIconGap", 4);
            if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
                Insets insets = (Insets)this.style.get(synthContext, (String)object + ".margin");
                if (insets == null) {
                    insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
                }
                this.menuItem.setMargin(insets);
            }
            this.acceleratorDelimiter = this.style.getString(synthContext, (String)object + ".acceleratorDelimiter", "+");
            this.arrowIcon = this.style.getIcon(synthContext, (String)object + ".arrowIcon");
            this.checkIcon = this.style.getIcon(synthContext, (String)object + ".checkIcon");
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
        object = this.getContext(jMenuItem, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle = SynthLookAndFeel.updateStyle((SynthContext)object, this);
        ((SynthContext)object).dispose();
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.menuItem, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        SynthContext synthContext2 = this.getContext(this.menuItem, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle.uninstallDefaults(synthContext2);
        synthContext2.dispose();
        this.accStyle = null;
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener(this);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    public SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, region, this.accStyle, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        if (!jComponent.isEnabled()) {
            return 8;
        }
        int n = this.menuItem.isArmed() ? 2 : SynthLookAndFeel.getComponentState(jComponent);
        if (this.menuItem.isSelected()) {
            n |= 0x200;
        }
        return n;
    }

    private int getComponentState(JComponent jComponent, Region region) {
        return this.getComponentState(jComponent);
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthContext synthContext2 = this.getContext(jComponent, Region.MENU_ITEM_ACCELERATOR);
        Dimension dimension = SynthMenuItemUI.getPreferredMenuItemSize(synthContext, synthContext2, true, jComponent, icon, icon2, n, this.acceleratorDelimiter);
        synthContext.dispose();
        synthContext2.dispose();
        return dimension;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paintBackground(synthContext, graphics, jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        SynthContext synthContext2 = this.getContext((JComponent)this.menuItem, Region.MENU_ITEM_ACCELERATOR);
        String string = this.getPropertyPrefix();
        SynthMenuItemUI.paint(synthContext, synthContext2, graphics, this.style.getIcon(this.getContext(synthContext.getComponent()), string + ".checkIcon"), this.style.getIcon(this.getContext(synthContext.getComponent()), string + ".arrowIcon"), true, this.acceleratorDelimiter, this.defaultTextIconGap);
        synthContext2.dispose();
    }

    void paintBackground(SynthContext synthContext, Graphics graphics, JComponent jComponent) {
        synthContext.getPainter().paintMenuItemBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintMenuItemBorder(synthContext, graphics, n, n2, n3, n4);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JMenuItem)propertyChangeEvent.getSource());
        }
    }
}

