// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package Glacier2;

// <auto-generated>
//
// Generated from file `PermissionsVerifier.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * The SSL Glacier2 permissions verifier. This is called through the
 * process of establishing a session.
 * 
 * @see Router
 * 
 **/
public interface SSLPermissionsVerifierPrx extends Ice.ObjectPrx
{
    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param reason The reason why access was denied.
     * 
     * @return True if access is granted, or false otherwise.
     * 
     * @see SSLInfo
     * 
     **/
    public boolean authorize(SSLInfo info, Ice.StringHolder reason);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param reason The reason why access was denied.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return True if access is granted, or false otherwise.
     * 
     * @see SSLInfo
     * 
     **/
    public boolean authorize(SSLInfo info, Ice.StringHolder reason, java.util.Map<String, String> __ctx);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, java.util.Map<String, String> __ctx);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, Ice.Callback __cb);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, Callback_SSLPermissionsVerifier_authorize __cb);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, java.util.Map<String, String> __ctx, Callback_SSLPermissionsVerifier_authorize __cb);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param reason The reason why access was denied.
     * 
     * @param __result The asynchronous result object.
     * @return True if access is granted, or false otherwise.
     * 
     * @see SSLInfo
     * 
     **/
    public boolean end_authorize(Ice.StringHolder reason, Ice.AsyncResult __result);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL information.
     * 
     **/
    public boolean authorize_async(AMI_SSLPermissionsVerifier_authorize __cb, SSLInfo info);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL information.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean authorize_async(AMI_SSLPermissionsVerifier_authorize __cb, SSLInfo info, java.util.Map<String, String> __ctx);
}
