// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package Ice;

// <auto-generated>
//
// Generated from file `Process.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * An administrative interface for process management. Managed servers must
 * implement this interface.
 * 
 * <p class="Note">A servant implementing this interface is a potential target
 * for denial-of-service attacks, therefore proper security precautions
 * should be taken. For example, the servant can use a UUID to make its
 * identity harder to guess, and be registered in an object adapter with
 * a secured endpoint.
 * 
 **/
public final class ProcessPrxHelper extends Ice.ObjectPrxHelperBase implements ProcessPrx
{
    /**
     * Initiate a graceful shut-down.
     * 
     * @see Communicator#shutdown
     * 
     **/
    public void
    shutdown()
    {
        shutdown(null, false);
    }

    /**
     * Initiate a graceful shut-down.
     * 
     * @see Communicator#shutdown
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    shutdown(java.util.Map<String, String> __ctx)
    {
        shutdown(__ctx, true);
    }

    private void
    shutdown(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _ProcessDel __del = (_ProcessDel)__delBase;
                __del.shutdown(__ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __shutdown_name = "shutdown";

    /**
     * Initiate a graceful shut-down.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_shutdown()
    {
        return begin_shutdown(null, false, null);
    }

    /**
     * Initiate a graceful shut-down.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> __ctx)
    {
        return begin_shutdown(__ctx, true, null);
    }

    /**
     * Initiate a graceful shut-down.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_shutdown(Ice.Callback __cb)
    {
        return begin_shutdown(null, false, __cb);
    }

    /**
     * Initiate a graceful shut-down.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_shutdown(__ctx, true, __cb);
    }

    /**
     * Initiate a graceful shut-down.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_shutdown(Callback_Process_shutdown __cb)
    {
        return begin_shutdown(null, false, __cb);
    }

    /**
     * Initiate a graceful shut-down.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> __ctx, Callback_Process_shutdown __cb)
    {
        return begin_shutdown(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_shutdown(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __shutdown_name, __cb);
        try
        {
            __result.__prepare(__shutdown_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_shutdown(Ice.AsyncResult __result)
    {
        __end(__result, __shutdown_name);
    }

    /**
     * Initiate a graceful shut-down.
     * 
     * @param __cb The callback object for the operation.
     **/
    public boolean
    shutdown_async(AMI_Process_shutdown __cb)
    {
        Ice.AsyncResult __r = begin_shutdown(null, false, __cb);
        return __r.sentSynchronously();
    }

    /**
     * Initiate a graceful shut-down.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    shutdown_async(AMI_Process_shutdown __cb, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r = begin_shutdown(__ctx, true, __cb);
        return __r.sentSynchronously();
    }

    /**
     * Write a message on the process' stdout or stderr.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     **/
    public void
    writeMessage(String message, int fd)
    {
        writeMessage(message, fd, null, false);
    }

    /**
     * Write a message on the process' stdout or stderr.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    writeMessage(String message, int fd, java.util.Map<String, String> __ctx)
    {
        writeMessage(message, fd, __ctx, true);
    }

    private void
    writeMessage(String message, int fd, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _ProcessDel __del = (_ProcessDel)__delBase;
                __del.writeMessage(message, fd, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __writeMessage_name = "writeMessage";

    /**
     * Write a message on the process' stdout or stderr.
     * 
     * @param __cb The callback object for the operation.
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     **/
    public Ice.AsyncResult begin_writeMessage(String message, int fd)
    {
        return begin_writeMessage(message, fd, null, false, null);
    }

    /**
     * Write a message on the process' stdout or stderr.
     * 
     * @param __cb The callback object for the operation.
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_writeMessage(String message, int fd, java.util.Map<String, String> __ctx)
    {
        return begin_writeMessage(message, fd, __ctx, true, null);
    }

    /**
     * Write a message on the process' stdout or stderr.
     * 
     * @param __cb The callback object for the operation.
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     **/
    public Ice.AsyncResult begin_writeMessage(String message, int fd, Ice.Callback __cb)
    {
        return begin_writeMessage(message, fd, null, false, __cb);
    }

    /**
     * Write a message on the process' stdout or stderr.
     * 
     * @param __cb The callback object for the operation.
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_writeMessage(String message, int fd, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_writeMessage(message, fd, __ctx, true, __cb);
    }

    /**
     * Write a message on the process' stdout or stderr.
     * 
     * @param __cb The callback object for the operation.
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     **/
    public Ice.AsyncResult begin_writeMessage(String message, int fd, Callback_Process_writeMessage __cb)
    {
        return begin_writeMessage(message, fd, null, false, __cb);
    }

    /**
     * Write a message on the process' stdout or stderr.
     * 
     * @param __cb The callback object for the operation.
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_writeMessage(String message, int fd, java.util.Map<String, String> __ctx, Callback_Process_writeMessage __cb)
    {
        return begin_writeMessage(message, fd, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_writeMessage(String message, int fd, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __writeMessage_name, __cb);
        try
        {
            __result.__prepare(__writeMessage_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(message);
            __os.writeInt(fd);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_writeMessage(Ice.AsyncResult __result)
    {
        __end(__result, __writeMessage_name);
    }

    /**
     * Write a message on the process' stdout or stderr.
     * 
     * @param __cb The callback object for the operation.
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     **/
    public boolean
    writeMessage_async(AMI_Process_writeMessage __cb, String message, int fd)
    {
        Ice.AsyncResult __r = begin_writeMessage(message, fd, null, false, __cb);
        return __r.sentSynchronously();
    }

    /**
     * Write a message on the process' stdout or stderr.
     * 
     * @param __cb The callback object for the operation.
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    writeMessage_async(AMI_Process_writeMessage __cb, String message, int fd, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r = begin_writeMessage(message, fd, __ctx, true, __cb);
        return __r.sentSynchronously();
    }

    public static ProcessPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        ProcessPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (ProcessPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::Ice::Process"))
                {
                    ProcessPrxHelper __h = new ProcessPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static ProcessPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        ProcessPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (ProcessPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::Ice::Process", __ctx))
                {
                    ProcessPrxHelper __h = new ProcessPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static ProcessPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        ProcessPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::Ice::Process"))
                {
                    ProcessPrxHelper __h = new ProcessPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static ProcessPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        ProcessPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::Ice::Process", __ctx))
                {
                    ProcessPrxHelper __h = new ProcessPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static ProcessPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        ProcessPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (ProcessPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                ProcessPrxHelper __h = new ProcessPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static ProcessPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        ProcessPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            ProcessPrxHelper __h = new ProcessPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _ProcessDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _ProcessDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, ProcessPrx v)
    {
        __os.writeProxy(v);
    }

    public static ProcessPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            ProcessPrxHelper result = new ProcessPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
