// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Descriptor.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * An Ice object adapter descriptor.
 * 
 **/
public class AdapterDescriptor implements java.lang.Cloneable, java.io.Serializable
{
    /**
     * The object adapter name.
     * 
     **/
    public String name;

    /**
     * The description of this object adapter.
     * 
     **/
    public String description;

    /**
     * The object adapter id.
     * 
     **/
    public String id;

    /**
     * The replica id of this adapter.
     * 
     **/
    public String replicaGroupId;

    /**
     * The adapter priority. This is eventually used when the adapter
     * is member of a replica group to sort the adapter endpoints by
     * priority.
     * 
     **/
    public String priority;

    /**
     * Flag to specify if the object adapter will register a process object.
     * 
     **/
    public boolean registerProcess;

    /**
     * If true the lifetime of this object adapter is the same of the
     * server lifetime. This information is used by the IceGrid node
     * to figure out the server state: the server is active only if
     * all its "server lifetime" adapters are active.
     * 
     **/
    public boolean serverLifetime;

    /**
     * The well-known object descriptors associated with this object adapter.
     * 
     **/
    public java.util.List<ObjectDescriptor> objects;

    /**
     * The allocatable object descriptors associated with this object adapter.
     * 
     **/
    public java.util.List<ObjectDescriptor> allocatables;

    public AdapterDescriptor()
    {
    }

    public AdapterDescriptor(String name, String description, String id, String replicaGroupId, String priority, boolean registerProcess, boolean serverLifetime, java.util.List<ObjectDescriptor> objects, java.util.List<ObjectDescriptor> allocatables)
    {
        this.name = name;
        this.description = description;
        this.id = id;
        this.replicaGroupId = replicaGroupId;
        this.priority = priority;
        this.registerProcess = registerProcess;
        this.serverLifetime = serverLifetime;
        this.objects = objects;
        this.allocatables = allocatables;
    }

    public boolean
    equals(java.lang.Object rhs)
    {
        if(this == rhs)
        {
            return true;
        }
        AdapterDescriptor _r = null;
        try
        {
            _r = (AdapterDescriptor)rhs;
        }
        catch(ClassCastException ex)
        {
        }

        if(_r != null)
        {
            if(name != _r.name)
            {
                if(name == null || _r.name == null || !name.equals(_r.name))
                {
                    return false;
                }
            }
            if(description != _r.description)
            {
                if(description == null || _r.description == null || !description.equals(_r.description))
                {
                    return false;
                }
            }
            if(id != _r.id)
            {
                if(id == null || _r.id == null || !id.equals(_r.id))
                {
                    return false;
                }
            }
            if(replicaGroupId != _r.replicaGroupId)
            {
                if(replicaGroupId == null || _r.replicaGroupId == null || !replicaGroupId.equals(_r.replicaGroupId))
                {
                    return false;
                }
            }
            if(priority != _r.priority)
            {
                if(priority == null || _r.priority == null || !priority.equals(_r.priority))
                {
                    return false;
                }
            }
            if(registerProcess != _r.registerProcess)
            {
                return false;
            }
            if(serverLifetime != _r.serverLifetime)
            {
                return false;
            }
            if(objects != _r.objects)
            {
                if(objects == null || _r.objects == null || !objects.equals(_r.objects))
                {
                    return false;
                }
            }
            if(allocatables != _r.allocatables)
            {
                if(allocatables == null || _r.allocatables == null || !allocatables.equals(_r.allocatables))
                {
                    return false;
                }
            }

            return true;
        }

        return false;
    }

    public int
    hashCode()
    {
        int __h = 0;
        if(name != null)
        {
            __h = 5 * __h + name.hashCode();
        }
        if(description != null)
        {
            __h = 5 * __h + description.hashCode();
        }
        if(id != null)
        {
            __h = 5 * __h + id.hashCode();
        }
        if(replicaGroupId != null)
        {
            __h = 5 * __h + replicaGroupId.hashCode();
        }
        if(priority != null)
        {
            __h = 5 * __h + priority.hashCode();
        }
        __h = 5 * __h + (registerProcess ? 1 : 0);
        __h = 5 * __h + (serverLifetime ? 1 : 0);
        if(objects != null)
        {
            __h = 5 * __h + objects.hashCode();
        }
        if(allocatables != null)
        {
            __h = 5 * __h + allocatables.hashCode();
        }
        return __h;
    }

    public java.lang.Object
    clone()
    {
        java.lang.Object o = null;
        try
        {
            o = super.clone();
        }
        catch(CloneNotSupportedException ex)
        {
            assert false; // impossible
        }
        return o;
    }

    public void
    __write(IceInternal.BasicStream __os)
    {
        __os.writeString(name);
        __os.writeString(description);
        __os.writeString(id);
        __os.writeString(replicaGroupId);
        __os.writeString(priority);
        __os.writeBool(registerProcess);
        __os.writeBool(serverLifetime);
        ObjectDescriptorSeqHelper.write(__os, objects);
        ObjectDescriptorSeqHelper.write(__os, allocatables);
    }

    public void
    __read(IceInternal.BasicStream __is)
    {
        name = __is.readString();
        description = __is.readString();
        id = __is.readString();
        replicaGroupId = __is.readString();
        priority = __is.readString();
        registerProcess = __is.readBool();
        serverLifetime = __is.readBool();
        objects = ObjectDescriptorSeqHelper.read(__is);
        allocatables = ObjectDescriptorSeqHelper.read(__is);
    }
}
