// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Descriptor.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * An application update descriptor to describe the updates to apply
 * to a deployed application.
 * 
 **/
public class ApplicationUpdateDescriptor implements java.lang.Cloneable, java.io.Serializable
{
    /**
     * The name of the application to update.
     * 
     **/
    public String name;

    /**
     * The updated description (or null if the description wasn't
     * updated.)
     * 
     **/
    public BoxedString description;

    /**
     * The updated distribution application descriptor.
     * 
     **/
    public BoxedDistributionDescriptor distrib;

    /**
     * The variables to update.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String> variables;

    /**
     * The variables to remove.
     * 
     **/
    public String[] removeVariables;

    /**
     * The property sets to update.
     * 
     **/
    public java.util.Map<java.lang.String, PropertySetDescriptor> propertySets;

    /**
     * The property sets to remove.
     * 
     **/
    public String[] removePropertySets;

    /**
     * The replica groups to update.
     * 
     **/
    public java.util.List<ReplicaGroupDescriptor> replicaGroups;

    /**
     * The replica groups to remove.
     * 
     **/
    public String[] removeReplicaGroups;

    /**
     * The server templates to update.
     * 
     **/
    public java.util.Map<java.lang.String, TemplateDescriptor> serverTemplates;

    /**
     * The ids of the server template to remove.
     * 
     **/
    public String[] removeServerTemplates;

    /**
     * The service templates to update.
     * 
     **/
    public java.util.Map<java.lang.String, TemplateDescriptor> serviceTemplates;

    /**
     * The ids of the service template to remove.
     * 
     **/
    public String[] removeServiceTemplates;

    /**
     * The application nodes to update.
     * 
     **/
    public java.util.List<NodeUpdateDescriptor> nodes;

    /**
     * The nodes to remove.
     * 
     **/
    public String[] removeNodes;

    public ApplicationUpdateDescriptor()
    {
    }

    public ApplicationUpdateDescriptor(String name, BoxedString description, BoxedDistributionDescriptor distrib, java.util.Map<java.lang.String, java.lang.String> variables, String[] removeVariables, java.util.Map<java.lang.String, PropertySetDescriptor> propertySets, String[] removePropertySets, java.util.List<ReplicaGroupDescriptor> replicaGroups, String[] removeReplicaGroups, java.util.Map<java.lang.String, TemplateDescriptor> serverTemplates, String[] removeServerTemplates, java.util.Map<java.lang.String, TemplateDescriptor> serviceTemplates, String[] removeServiceTemplates, java.util.List<NodeUpdateDescriptor> nodes, String[] removeNodes)
    {
        this.name = name;
        this.description = description;
        this.distrib = distrib;
        this.variables = variables;
        this.removeVariables = removeVariables;
        this.propertySets = propertySets;
        this.removePropertySets = removePropertySets;
        this.replicaGroups = replicaGroups;
        this.removeReplicaGroups = removeReplicaGroups;
        this.serverTemplates = serverTemplates;
        this.removeServerTemplates = removeServerTemplates;
        this.serviceTemplates = serviceTemplates;
        this.removeServiceTemplates = removeServiceTemplates;
        this.nodes = nodes;
        this.removeNodes = removeNodes;
    }

    public boolean
    equals(java.lang.Object rhs)
    {
        if(this == rhs)
        {
            return true;
        }
        ApplicationUpdateDescriptor _r = null;
        try
        {
            _r = (ApplicationUpdateDescriptor)rhs;
        }
        catch(ClassCastException ex)
        {
        }

        if(_r != null)
        {
            if(name != _r.name)
            {
                if(name == null || _r.name == null || !name.equals(_r.name))
                {
                    return false;
                }
            }
            if(description != _r.description)
            {
                if(description == null || _r.description == null || !description.equals(_r.description))
                {
                    return false;
                }
            }
            if(distrib != _r.distrib)
            {
                if(distrib == null || _r.distrib == null || !distrib.equals(_r.distrib))
                {
                    return false;
                }
            }
            if(variables != _r.variables)
            {
                if(variables == null || _r.variables == null || !variables.equals(_r.variables))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(removeVariables, _r.removeVariables))
            {
                return false;
            }
            if(propertySets != _r.propertySets)
            {
                if(propertySets == null || _r.propertySets == null || !propertySets.equals(_r.propertySets))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(removePropertySets, _r.removePropertySets))
            {
                return false;
            }
            if(replicaGroups != _r.replicaGroups)
            {
                if(replicaGroups == null || _r.replicaGroups == null || !replicaGroups.equals(_r.replicaGroups))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(removeReplicaGroups, _r.removeReplicaGroups))
            {
                return false;
            }
            if(serverTemplates != _r.serverTemplates)
            {
                if(serverTemplates == null || _r.serverTemplates == null || !serverTemplates.equals(_r.serverTemplates))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(removeServerTemplates, _r.removeServerTemplates))
            {
                return false;
            }
            if(serviceTemplates != _r.serviceTemplates)
            {
                if(serviceTemplates == null || _r.serviceTemplates == null || !serviceTemplates.equals(_r.serviceTemplates))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(removeServiceTemplates, _r.removeServiceTemplates))
            {
                return false;
            }
            if(nodes != _r.nodes)
            {
                if(nodes == null || _r.nodes == null || !nodes.equals(_r.nodes))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(removeNodes, _r.removeNodes))
            {
                return false;
            }

            return true;
        }

        return false;
    }

    public int
    hashCode()
    {
        int __h = 0;
        if(name != null)
        {
            __h = 5 * __h + name.hashCode();
        }
        if(description != null)
        {
            __h = 5 * __h + description.hashCode();
        }
        if(distrib != null)
        {
            __h = 5 * __h + distrib.hashCode();
        }
        if(variables != null)
        {
            __h = 5 * __h + variables.hashCode();
        }
        if(removeVariables != null)
        {
            for(int __i0 = 0; __i0 < removeVariables.length; __i0++)
            {
                if(removeVariables[__i0] != null)
                {
                    __h = 5 * __h + removeVariables[__i0].hashCode();
                }
            }
        }
        if(propertySets != null)
        {
            __h = 5 * __h + propertySets.hashCode();
        }
        if(removePropertySets != null)
        {
            for(int __i1 = 0; __i1 < removePropertySets.length; __i1++)
            {
                if(removePropertySets[__i1] != null)
                {
                    __h = 5 * __h + removePropertySets[__i1].hashCode();
                }
            }
        }
        if(replicaGroups != null)
        {
            __h = 5 * __h + replicaGroups.hashCode();
        }
        if(removeReplicaGroups != null)
        {
            for(int __i2 = 0; __i2 < removeReplicaGroups.length; __i2++)
            {
                if(removeReplicaGroups[__i2] != null)
                {
                    __h = 5 * __h + removeReplicaGroups[__i2].hashCode();
                }
            }
        }
        if(serverTemplates != null)
        {
            __h = 5 * __h + serverTemplates.hashCode();
        }
        if(removeServerTemplates != null)
        {
            for(int __i3 = 0; __i3 < removeServerTemplates.length; __i3++)
            {
                if(removeServerTemplates[__i3] != null)
                {
                    __h = 5 * __h + removeServerTemplates[__i3].hashCode();
                }
            }
        }
        if(serviceTemplates != null)
        {
            __h = 5 * __h + serviceTemplates.hashCode();
        }
        if(removeServiceTemplates != null)
        {
            for(int __i4 = 0; __i4 < removeServiceTemplates.length; __i4++)
            {
                if(removeServiceTemplates[__i4] != null)
                {
                    __h = 5 * __h + removeServiceTemplates[__i4].hashCode();
                }
            }
        }
        if(nodes != null)
        {
            __h = 5 * __h + nodes.hashCode();
        }
        if(removeNodes != null)
        {
            for(int __i5 = 0; __i5 < removeNodes.length; __i5++)
            {
                if(removeNodes[__i5] != null)
                {
                    __h = 5 * __h + removeNodes[__i5].hashCode();
                }
            }
        }
        return __h;
    }

    public java.lang.Object
    clone()
    {
        java.lang.Object o = null;
        try
        {
            o = super.clone();
        }
        catch(CloneNotSupportedException ex)
        {
            assert false; // impossible
        }
        return o;
    }

    public void
    __write(IceInternal.BasicStream __os)
    {
        __os.writeString(name);
        __os.writeObject(description);
        __os.writeObject(distrib);
        StringStringDictHelper.write(__os, variables);
        Ice.StringSeqHelper.write(__os, removeVariables);
        PropertySetDescriptorDictHelper.write(__os, propertySets);
        Ice.StringSeqHelper.write(__os, removePropertySets);
        ReplicaGroupDescriptorSeqHelper.write(__os, replicaGroups);
        Ice.StringSeqHelper.write(__os, removeReplicaGroups);
        TemplateDescriptorDictHelper.write(__os, serverTemplates);
        Ice.StringSeqHelper.write(__os, removeServerTemplates);
        TemplateDescriptorDictHelper.write(__os, serviceTemplates);
        Ice.StringSeqHelper.write(__os, removeServiceTemplates);
        NodeUpdateDescriptorSeqHelper.write(__os, nodes);
        Ice.StringSeqHelper.write(__os, removeNodes);
    }

    private class Patcher implements IceInternal.Patcher
    {
        Patcher(int member)
        {
            __member = member;
        }

        public void
        patch(Ice.Object v)
        {
            try
            {
                switch(__member)
                {
                case 0:
                    __typeId = "::IceGrid::BoxedString";
                    description = (BoxedString)v;
                    break;
                case 1:
                    __typeId = "::IceGrid::BoxedDistributionDescriptor";
                    distrib = (BoxedDistributionDescriptor)v;
                    break;
                }
            }
            catch(ClassCastException ex)
            {
                IceInternal.Ex.throwUOE(type(), v.ice_id());
            }
        }

        public String
        type()
        {
            return __typeId;
        }

        private int __member;
        private String __typeId;
    }

    public void
    __read(IceInternal.BasicStream __is)
    {
        name = __is.readString();
        __is.readObject(new Patcher(0));
        __is.readObject(new Patcher(1));
        variables = new java.util.TreeMap<String, String>();
        int __sz0 = __is.readSize();
        for(int __i0 = 0; __i0 < __sz0; __i0++)
        {
            String __key;
            __key = __is.readString();
            String __value;
            __value = __is.readString();
            variables.put(__key, __value);
        }
        removeVariables = Ice.StringSeqHelper.read(__is);
        propertySets = PropertySetDescriptorDictHelper.read(__is);
        removePropertySets = Ice.StringSeqHelper.read(__is);
        replicaGroups = ReplicaGroupDescriptorSeqHelper.read(__is);
        removeReplicaGroups = Ice.StringSeqHelper.read(__is);
        serverTemplates = TemplateDescriptorDictHelper.read(__is);
        removeServerTemplates = Ice.StringSeqHelper.read(__is);
        serviceTemplates = TemplateDescriptorDictHelper.read(__is);
        removeServiceTemplates = Ice.StringSeqHelper.read(__is);
        nodes = NodeUpdateDescriptorSeqHelper.read(__is);
        removeNodes = Ice.StringSeqHelper.read(__is);
    }
}
