// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `FileParser.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * <tt>icegridadmin</tt> provides a {@link FileParser}
 * object to transform XML files into {@link ApplicationDescriptor}
 * objects.
 * 
 **/
public final class FileParserPrxHelper extends Ice.ObjectPrxHelperBase implements FileParserPrx
{
    /**
     * Parse a file.
     * 
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     * @returns The application descriptor.
     * 
     * @throws ParseException Raised if an error occurred during parsing.
     * 
     **/
    public ApplicationDescriptor
    parse(String xmlFile, AdminPrx adminProxy)
        throws ParseException
    {
        return parse(xmlFile, adminProxy, null, false);
    }

    /**
     * Parse a file.
     * 
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @returns The application descriptor.
     * 
     * @throws ParseException Raised if an error occurred during parsing.
     * 
     **/
    public ApplicationDescriptor
    parse(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> __ctx)
        throws ParseException
    {
        return parse(xmlFile, adminProxy, __ctx, true);
    }

    private ApplicationDescriptor
    parse(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws ParseException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("parse");
                __delBase = __getDelegate(false);
                _FileParserDel __del = (_FileParserDel)__delBase;
                return __del.parse(xmlFile, adminProxy, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __parse_name = "parse";

    /**
     * Parse a file.
     * 
     * @param __cb The callback object for the operation.
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy)
    {
        return begin_parse(xmlFile, adminProxy, null, false, null);
    }

    /**
     * Parse a file.
     * 
     * @param __cb The callback object for the operation.
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> __ctx)
    {
        return begin_parse(xmlFile, adminProxy, __ctx, true, null);
    }

    /**
     * Parse a file.
     * 
     * @param __cb The callback object for the operation.
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, Ice.Callback __cb)
    {
        return begin_parse(xmlFile, adminProxy, null, false, __cb);
    }

    /**
     * Parse a file.
     * 
     * @param __cb The callback object for the operation.
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_parse(xmlFile, adminProxy, __ctx, true, __cb);
    }

    /**
     * Parse a file.
     * 
     * @param __cb The callback object for the operation.
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, Callback_FileParser_parse __cb)
    {
        return begin_parse(xmlFile, adminProxy, null, false, __cb);
    }

    /**
     * Parse a file.
     * 
     * @param __cb The callback object for the operation.
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> __ctx, Callback_FileParser_parse __cb)
    {
        return begin_parse(xmlFile, adminProxy, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__parse_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __parse_name, __cb);
        try
        {
            __result.__prepare(__parse_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(xmlFile);
            AdminPrxHelper.__write(__os, adminProxy);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value)s The application descriptor.
     * 
     **/
    public ApplicationDescriptor end_parse(Ice.AsyncResult __result)
        throws ParseException
    {
        Ice.AsyncResult.__check(__result, this, __parse_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(ParseException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        ApplicationDescriptor __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = new ApplicationDescriptor();
        __ret.__read(__is);
        __is.readPendingObjects();
        __is.endReadEncaps();
        return __ret;
    }

    public static FileParserPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        FileParserPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (FileParserPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceGrid::FileParser"))
                {
                    FileParserPrxHelper __h = new FileParserPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static FileParserPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        FileParserPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (FileParserPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceGrid::FileParser", __ctx))
                {
                    FileParserPrxHelper __h = new FileParserPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static FileParserPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        FileParserPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceGrid::FileParser"))
                {
                    FileParserPrxHelper __h = new FileParserPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static FileParserPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        FileParserPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceGrid::FileParser", __ctx))
                {
                    FileParserPrxHelper __h = new FileParserPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static FileParserPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        FileParserPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (FileParserPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                FileParserPrxHelper __h = new FileParserPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static FileParserPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        FileParserPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            FileParserPrxHelper __h = new FileParserPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _FileParserDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _FileParserDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, FileParserPrx v)
    {
        __os.writeProxy(v);
    }

    public static FileParserPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            FileParserPrxHelper result = new FileParserPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
