// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * Information about an IceGrid node.
 * 
 **/
public class NodeInfo implements java.lang.Cloneable, java.io.Serializable
{
    /**
     * The name of the node.
     * 
     **/
    public String name;

    /**
     * The operating system name.
     * 
     **/
    public String os;

    /**
     * The network name of the host running this node (as defined in
     * uname()).
     * 
     **/
    public String hostname;

    /**
     * The operation system release level (as defined in uname()).
     * 
     **/
    public String release;

    /**
     * The operation system version (as defined in uname()).
     * 
     **/
    public String version;

    /**
     * The machine hardware type (as defined in uname()).
     * 
     **/
    public String machine;

    /**
     * The number of processors.
     * 
     **/
    public int nProcessors;

    /**
     * The path to the node data directory.
     * 
     **/
    public String dataDir;

    public NodeInfo()
    {
    }

    public NodeInfo(String name, String os, String hostname, String release, String version, String machine, int nProcessors, String dataDir)
    {
        this.name = name;
        this.os = os;
        this.hostname = hostname;
        this.release = release;
        this.version = version;
        this.machine = machine;
        this.nProcessors = nProcessors;
        this.dataDir = dataDir;
    }

    public boolean
    equals(java.lang.Object rhs)
    {
        if(this == rhs)
        {
            return true;
        }
        NodeInfo _r = null;
        try
        {
            _r = (NodeInfo)rhs;
        }
        catch(ClassCastException ex)
        {
        }

        if(_r != null)
        {
            if(name != _r.name)
            {
                if(name == null || _r.name == null || !name.equals(_r.name))
                {
                    return false;
                }
            }
            if(os != _r.os)
            {
                if(os == null || _r.os == null || !os.equals(_r.os))
                {
                    return false;
                }
            }
            if(hostname != _r.hostname)
            {
                if(hostname == null || _r.hostname == null || !hostname.equals(_r.hostname))
                {
                    return false;
                }
            }
            if(release != _r.release)
            {
                if(release == null || _r.release == null || !release.equals(_r.release))
                {
                    return false;
                }
            }
            if(version != _r.version)
            {
                if(version == null || _r.version == null || !version.equals(_r.version))
                {
                    return false;
                }
            }
            if(machine != _r.machine)
            {
                if(machine == null || _r.machine == null || !machine.equals(_r.machine))
                {
                    return false;
                }
            }
            if(nProcessors != _r.nProcessors)
            {
                return false;
            }
            if(dataDir != _r.dataDir)
            {
                if(dataDir == null || _r.dataDir == null || !dataDir.equals(_r.dataDir))
                {
                    return false;
                }
            }

            return true;
        }

        return false;
    }

    public int
    hashCode()
    {
        int __h = 0;
        if(name != null)
        {
            __h = 5 * __h + name.hashCode();
        }
        if(os != null)
        {
            __h = 5 * __h + os.hashCode();
        }
        if(hostname != null)
        {
            __h = 5 * __h + hostname.hashCode();
        }
        if(release != null)
        {
            __h = 5 * __h + release.hashCode();
        }
        if(version != null)
        {
            __h = 5 * __h + version.hashCode();
        }
        if(machine != null)
        {
            __h = 5 * __h + machine.hashCode();
        }
        __h = 5 * __h + nProcessors;
        if(dataDir != null)
        {
            __h = 5 * __h + dataDir.hashCode();
        }
        return __h;
    }

    public java.lang.Object
    clone()
    {
        java.lang.Object o = null;
        try
        {
            o = super.clone();
        }
        catch(CloneNotSupportedException ex)
        {
            assert false; // impossible
        }
        return o;
    }

    public void
    __write(IceInternal.BasicStream __os)
    {
        __os.writeString(name);
        __os.writeString(os);
        __os.writeString(hostname);
        __os.writeString(release);
        __os.writeString(version);
        __os.writeString(machine);
        __os.writeInt(nProcessors);
        __os.writeString(dataDir);
    }

    public void
    __read(IceInternal.BasicStream __is)
    {
        name = __is.readString();
        os = __is.readString();
        hostname = __is.readString();
        release = __is.readString();
        version = __is.readString();
        machine = __is.readString();
        nProcessors = __is.readInt();
        dataDir = __is.readString();
    }
}
