// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Descriptor.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * A node update descriptor to describe the updates to apply to a
 * node of a deployed application.
 * 
 **/
public class NodeUpdateDescriptor implements java.lang.Cloneable, java.io.Serializable
{
    /**
     * The name of the node to update.
     * 
     **/
    public String name;

    /**
     * The updated description (or null if the description wasn't
     * updated.)
     * 
     **/
    public BoxedString description;

    /**
     * The variables to update.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String> variables;

    /**
     * The variables to remove.
     * 
     **/
    public String[] removeVariables;

    /**
     * The property sets to update.
     * 
     **/
    public java.util.Map<java.lang.String, PropertySetDescriptor> propertySets;

    /**
     * The property sets to remove.
     * 
     **/
    public String[] removePropertySets;

    /**
     * The server instances to update.
     * 
     **/
    public java.util.List<ServerInstanceDescriptor> serverInstances;

    /**
     * The servers which are not template instances to update.
     * 
     **/
    public java.util.List<ServerDescriptor> servers;

    /**
     * The ids of the servers to remove.
     * 
     **/
    public String[] removeServers;

    /**
     * The updated load factor of the node (or null if the load factor
     * was not updated).
     * 
     **/
    public BoxedString loadFactor;

    public NodeUpdateDescriptor()
    {
    }

    public NodeUpdateDescriptor(String name, BoxedString description, java.util.Map<java.lang.String, java.lang.String> variables, String[] removeVariables, java.util.Map<java.lang.String, PropertySetDescriptor> propertySets, String[] removePropertySets, java.util.List<ServerInstanceDescriptor> serverInstances, java.util.List<ServerDescriptor> servers, String[] removeServers, BoxedString loadFactor)
    {
        this.name = name;
        this.description = description;
        this.variables = variables;
        this.removeVariables = removeVariables;
        this.propertySets = propertySets;
        this.removePropertySets = removePropertySets;
        this.serverInstances = serverInstances;
        this.servers = servers;
        this.removeServers = removeServers;
        this.loadFactor = loadFactor;
    }

    public boolean
    equals(java.lang.Object rhs)
    {
        if(this == rhs)
        {
            return true;
        }
        NodeUpdateDescriptor _r = null;
        try
        {
            _r = (NodeUpdateDescriptor)rhs;
        }
        catch(ClassCastException ex)
        {
        }

        if(_r != null)
        {
            if(name != _r.name)
            {
                if(name == null || _r.name == null || !name.equals(_r.name))
                {
                    return false;
                }
            }
            if(description != _r.description)
            {
                if(description == null || _r.description == null || !description.equals(_r.description))
                {
                    return false;
                }
            }
            if(variables != _r.variables)
            {
                if(variables == null || _r.variables == null || !variables.equals(_r.variables))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(removeVariables, _r.removeVariables))
            {
                return false;
            }
            if(propertySets != _r.propertySets)
            {
                if(propertySets == null || _r.propertySets == null || !propertySets.equals(_r.propertySets))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(removePropertySets, _r.removePropertySets))
            {
                return false;
            }
            if(serverInstances != _r.serverInstances)
            {
                if(serverInstances == null || _r.serverInstances == null || !serverInstances.equals(_r.serverInstances))
                {
                    return false;
                }
            }
            if(servers != _r.servers)
            {
                if(servers == null || _r.servers == null || !servers.equals(_r.servers))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(removeServers, _r.removeServers))
            {
                return false;
            }
            if(loadFactor != _r.loadFactor)
            {
                if(loadFactor == null || _r.loadFactor == null || !loadFactor.equals(_r.loadFactor))
                {
                    return false;
                }
            }

            return true;
        }

        return false;
    }

    public int
    hashCode()
    {
        int __h = 0;
        if(name != null)
        {
            __h = 5 * __h + name.hashCode();
        }
        if(description != null)
        {
            __h = 5 * __h + description.hashCode();
        }
        if(variables != null)
        {
            __h = 5 * __h + variables.hashCode();
        }
        if(removeVariables != null)
        {
            for(int __i0 = 0; __i0 < removeVariables.length; __i0++)
            {
                if(removeVariables[__i0] != null)
                {
                    __h = 5 * __h + removeVariables[__i0].hashCode();
                }
            }
        }
        if(propertySets != null)
        {
            __h = 5 * __h + propertySets.hashCode();
        }
        if(removePropertySets != null)
        {
            for(int __i1 = 0; __i1 < removePropertySets.length; __i1++)
            {
                if(removePropertySets[__i1] != null)
                {
                    __h = 5 * __h + removePropertySets[__i1].hashCode();
                }
            }
        }
        if(serverInstances != null)
        {
            __h = 5 * __h + serverInstances.hashCode();
        }
        if(servers != null)
        {
            __h = 5 * __h + servers.hashCode();
        }
        if(removeServers != null)
        {
            for(int __i2 = 0; __i2 < removeServers.length; __i2++)
            {
                if(removeServers[__i2] != null)
                {
                    __h = 5 * __h + removeServers[__i2].hashCode();
                }
            }
        }
        if(loadFactor != null)
        {
            __h = 5 * __h + loadFactor.hashCode();
        }
        return __h;
    }

    public java.lang.Object
    clone()
    {
        java.lang.Object o = null;
        try
        {
            o = super.clone();
        }
        catch(CloneNotSupportedException ex)
        {
            assert false; // impossible
        }
        return o;
    }

    public void
    __write(IceInternal.BasicStream __os)
    {
        __os.writeString(name);
        __os.writeObject(description);
        StringStringDictHelper.write(__os, variables);
        Ice.StringSeqHelper.write(__os, removeVariables);
        PropertySetDescriptorDictHelper.write(__os, propertySets);
        Ice.StringSeqHelper.write(__os, removePropertySets);
        ServerInstanceDescriptorSeqHelper.write(__os, serverInstances);
        ServerDescriptorSeqHelper.write(__os, servers);
        Ice.StringSeqHelper.write(__os, removeServers);
        __os.writeObject(loadFactor);
    }

    private class Patcher implements IceInternal.Patcher
    {
        Patcher(int member)
        {
            __member = member;
        }

        public void
        patch(Ice.Object v)
        {
            try
            {
                switch(__member)
                {
                case 0:
                    __typeId = "::IceGrid::BoxedString";
                    description = (BoxedString)v;
                    break;
                case 1:
                    __typeId = "::IceGrid::BoxedString";
                    loadFactor = (BoxedString)v;
                    break;
                }
            }
            catch(ClassCastException ex)
            {
                IceInternal.Ex.throwUOE(type(), v.ice_id());
            }
        }

        public String
        type()
        {
            return __typeId;
        }

        private int __member;
        private String __typeId;
    }

    public void
    __read(IceInternal.BasicStream __is)
    {
        name = __is.readString();
        __is.readObject(new Patcher(0));
        variables = new java.util.TreeMap<String, String>();
        int __sz0 = __is.readSize();
        for(int __i0 = 0; __i0 < __sz0; __i0++)
        {
            String __key;
            __key = __is.readString();
            String __value;
            __value = __is.readString();
            variables.put(__key, __value);
        }
        removeVariables = Ice.StringSeqHelper.read(__is);
        propertySets = PropertySetDescriptorDictHelper.read(__is);
        removePropertySets = Ice.StringSeqHelper.read(__is);
        serverInstances = ServerInstanceDescriptorSeqHelper.read(__is);
        servers = ServerDescriptorSeqHelper.read(__is);
        removeServers = Ice.StringSeqHelper.read(__is);
        __is.readObject(new Patcher(1));
    }
}
