// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * A session object is used by IceGrid clients to allocate and
 * release objects. Client sessions are either created with the
 * {@link Registry} object or the registry client {@link Glacier2.SessionManager}
 * object.
 * 
 * @see Registry
 * @see Glacier2.SessionManager
 * 
 **/
public final class SessionPrxHelper extends Ice.ObjectPrxHelperBase implements SessionPrx
{
    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     **/
    public void
    destroy()
    {
        destroy(null, false);
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    destroy(java.util.Map<String, String> __ctx)
    {
        destroy(__ctx, true);
    }

    private void
    destroy(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _SessionDel __del = (_SessionDel)__delBase;
                __del.destroy(__ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __destroy_name = "destroy";

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_destroy()
    {
        return begin_destroy(null, false, null);
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx)
    {
        return begin_destroy(__ctx, true, null);
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_destroy(Ice.Callback __cb)
    {
        return begin_destroy(null, false, __cb);
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_destroy(__ctx, true, __cb);
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_destroy(Glacier2.Callback_Session_destroy __cb)
    {
        return begin_destroy(null, false, __cb);
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx, Glacier2.Callback_Session_destroy __cb)
    {
        return begin_destroy(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __destroy_name, __cb);
        try
        {
            __result.__prepare(__destroy_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_destroy(Ice.AsyncResult __result)
    {
        __end(__result, __destroy_name);
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     **/
    public boolean
    destroy_async(Glacier2.AMI_Session_destroy __cb)
    {
        Ice.AsyncResult __r = begin_destroy(null, false, __cb);
        return __r.sentSynchronously();
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    destroy_async(Glacier2.AMI_Session_destroy __cb, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r = begin_destroy(__ctx, true, __cb);
        return __r.sentSynchronously();
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * 
     * @param id The identity of the object to allocate.
     * 
     * @return The proxy of the allocated object.
     * 
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     * 
     * @throws AllocationException Raised if the object can't be
     * allocated.
     * 
     * @see #setAllocationTimeout
     * @see #releaseObject
     * 
     **/
    public Ice.ObjectPrx
    allocateObjectById(Ice.Identity id)
        throws AllocationException,
               ObjectNotRegisteredException
    {
        return allocateObjectById(id, null, false);
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * 
     * @param id The identity of the object to allocate.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The proxy of the allocated object.
     * 
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     * 
     * @throws AllocationException Raised if the object can't be
     * allocated.
     * 
     * @see #setAllocationTimeout
     * @see #releaseObject
     * 
     **/
    public Ice.ObjectPrx
    allocateObjectById(Ice.Identity id, java.util.Map<String, String> __ctx)
        throws AllocationException,
               ObjectNotRegisteredException
    {
        return allocateObjectById(id, __ctx, true);
    }

    private Ice.ObjectPrx
    allocateObjectById(Ice.Identity id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws AllocationException,
               ObjectNotRegisteredException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("allocateObjectById");
                __delBase = __getDelegate(false);
                _SessionDel __del = (_SessionDel)__delBase;
                return __del.allocateObjectById(id, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __allocateObjectById_name = "allocateObjectById";

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to allocate.
     * 
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id)
    {
        return begin_allocateObjectById(id, null, false, null);
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to allocate.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id, java.util.Map<String, String> __ctx)
    {
        return begin_allocateObjectById(id, __ctx, true, null);
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to allocate.
     * 
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id, Ice.Callback __cb)
    {
        return begin_allocateObjectById(id, null, false, __cb);
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to allocate.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_allocateObjectById(id, __ctx, true, __cb);
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to allocate.
     * 
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id, Callback_Session_allocateObjectById __cb)
    {
        return begin_allocateObjectById(id, null, false, __cb);
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to allocate.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_allocateObjectById(Ice.Identity id, java.util.Map<String, String> __ctx, Callback_Session_allocateObjectById __cb)
    {
        return begin_allocateObjectById(id, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_allocateObjectById(Ice.Identity id, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__allocateObjectById_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __allocateObjectById_name, __cb);
        try
        {
            __result.__prepare(__allocateObjectById_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            id.__write(__os);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The proxy of the allocated object.
     * 
     **/
    public Ice.ObjectPrx end_allocateObjectById(Ice.AsyncResult __result)
        throws AllocationException,
               ObjectNotRegisteredException
    {
        Ice.AsyncResult.__check(__result, this, __allocateObjectById_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(AllocationException __ex)
            {
                throw __ex;
            }
            catch(ObjectNotRegisteredException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        Ice.ObjectPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readProxy();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to allocate.
     * 
     **/
    public boolean
    allocateObjectById_async(AMI_Session_allocateObjectById __cb, Ice.Identity id)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__allocateObjectById_name);
            __r = begin_allocateObjectById(id, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __allocateObjectById_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to allocate.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    allocateObjectById_async(AMI_Session_allocateObjectById __cb, Ice.Identity id, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__allocateObjectById_name);
            __r = begin_allocateObjectById(id, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __allocateObjectById_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * 
     * @param type The type of the object.
     * 
     * @return The proxy of the allocated object.
     * 
     * @throws ObjectNotRegisteredException Raised if no objects with the given type can be allocated.
     * 
     * @throws AllocationException Raised if the object could not be allocated.
     * 
     * @see #setAllocationTimeout
     * @see #releaseObject
     * 
     **/
    public Ice.ObjectPrx
    allocateObjectByType(String type)
        throws AllocationException
    {
        return allocateObjectByType(type, null, false);
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * 
     * @param type The type of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The proxy of the allocated object.
     * 
     * @throws ObjectNotRegisteredException Raised if no objects with the given type can be allocated.
     * 
     * @throws AllocationException Raised if the object could not be allocated.
     * 
     * @see #setAllocationTimeout
     * @see #releaseObject
     * 
     **/
    public Ice.ObjectPrx
    allocateObjectByType(String type, java.util.Map<String, String> __ctx)
        throws AllocationException
    {
        return allocateObjectByType(type, __ctx, true);
    }

    private Ice.ObjectPrx
    allocateObjectByType(String type, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws AllocationException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("allocateObjectByType");
                __delBase = __getDelegate(false);
                _SessionDel __del = (_SessionDel)__delBase;
                return __del.allocateObjectByType(type, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __allocateObjectByType_name = "allocateObjectByType";

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type)
    {
        return begin_allocateObjectByType(type, null, false, null);
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type, java.util.Map<String, String> __ctx)
    {
        return begin_allocateObjectByType(type, __ctx, true, null);
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type, Ice.Callback __cb)
    {
        return begin_allocateObjectByType(type, null, false, __cb);
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_allocateObjectByType(type, __ctx, true, __cb);
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type, Callback_Session_allocateObjectByType __cb)
    {
        return begin_allocateObjectByType(type, null, false, __cb);
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_allocateObjectByType(String type, java.util.Map<String, String> __ctx, Callback_Session_allocateObjectByType __cb)
    {
        return begin_allocateObjectByType(type, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_allocateObjectByType(String type, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__allocateObjectByType_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __allocateObjectByType_name, __cb);
        try
        {
            __result.__prepare(__allocateObjectByType_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(type);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The proxy of the allocated object.
     * 
     **/
    public Ice.ObjectPrx end_allocateObjectByType(Ice.AsyncResult __result)
        throws AllocationException
    {
        Ice.AsyncResult.__check(__result, this, __allocateObjectByType_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(AllocationException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        Ice.ObjectPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readProxy();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     **/
    public boolean
    allocateObjectByType_async(AMI_Session_allocateObjectByType __cb, String type)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__allocateObjectByType_name);
            __r = begin_allocateObjectByType(type, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __allocateObjectByType_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    allocateObjectByType_async(AMI_Session_allocateObjectByType __cb, String type, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__allocateObjectByType_name);
            __r = begin_allocateObjectByType(type, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __allocateObjectByType_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @see Registry#getSessionTimeout
     * 
     **/
    public void
    keepAlive()
    {
        keepAlive(null, false);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @see Registry#getSessionTimeout
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    keepAlive(java.util.Map<String, String> __ctx)
    {
        keepAlive(__ctx, true);
    }

    private void
    keepAlive(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _SessionDel __del = (_SessionDel)__delBase;
                __del.keepAlive(__ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __keepAlive_name = "keepAlive";

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_keepAlive()
    {
        return begin_keepAlive(null, false, null);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> __ctx)
    {
        return begin_keepAlive(__ctx, true, null);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_keepAlive(Ice.Callback __cb)
    {
        return begin_keepAlive(null, false, __cb);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_keepAlive(__ctx, true, __cb);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_keepAlive(Callback_Session_keepAlive __cb)
    {
        return begin_keepAlive(null, false, __cb);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> __ctx, Callback_Session_keepAlive __cb)
    {
        return begin_keepAlive(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __keepAlive_name, __cb);
        try
        {
            __result.__prepare(__keepAlive_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_keepAlive(Ice.AsyncResult __result)
    {
        __end(__result, __keepAlive_name);
    }

    /**
     * Release an object.
     * 
     * @param id The identity of the object to release.
     * 
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     * 
     * @throws AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     * 
     * @see #allocateObjectById
     * @see #allocateObjectByType
     * 
     **/
    public void
    releaseObject(Ice.Identity id)
        throws AllocationException,
               ObjectNotRegisteredException
    {
        releaseObject(id, null, false);
    }

    /**
     * Release an object.
     * 
     * @param id The identity of the object to release.
     * 
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     * 
     * @throws AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     * 
     * @see #allocateObjectById
     * @see #allocateObjectByType
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    releaseObject(Ice.Identity id, java.util.Map<String, String> __ctx)
        throws AllocationException,
               ObjectNotRegisteredException
    {
        releaseObject(id, __ctx, true);
    }

    private void
    releaseObject(Ice.Identity id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws AllocationException,
               ObjectNotRegisteredException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("releaseObject");
                __delBase = __getDelegate(false);
                _SessionDel __del = (_SessionDel)__delBase;
                __del.releaseObject(id, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __releaseObject_name = "releaseObject";

    /**
     * Release an object.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to release.
     * 
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id)
    {
        return begin_releaseObject(id, null, false, null);
    }

    /**
     * Release an object.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to release.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id, java.util.Map<String, String> __ctx)
    {
        return begin_releaseObject(id, __ctx, true, null);
    }

    /**
     * Release an object.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to release.
     * 
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id, Ice.Callback __cb)
    {
        return begin_releaseObject(id, null, false, __cb);
    }

    /**
     * Release an object.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to release.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_releaseObject(id, __ctx, true, __cb);
    }

    /**
     * Release an object.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to release.
     * 
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id, Callback_Session_releaseObject __cb)
    {
        return begin_releaseObject(id, null, false, __cb);
    }

    /**
     * Release an object.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to release.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_releaseObject(Ice.Identity id, java.util.Map<String, String> __ctx, Callback_Session_releaseObject __cb)
    {
        return begin_releaseObject(id, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_releaseObject(Ice.Identity id, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__releaseObject_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __releaseObject_name, __cb);
        try
        {
            __result.__prepare(__releaseObject_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            id.__write(__os);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_releaseObject(Ice.AsyncResult __result)
        throws AllocationException,
               ObjectNotRegisteredException
    {
        Ice.AsyncResult.__check(__result, this, __releaseObject_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(AllocationException __ex)
            {
                throw __ex;
            }
            catch(ObjectNotRegisteredException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, the request will hang for the duration of 
     * this timeout.
     * 
     * @param timeout The timeout in milliseconds.
     * 
     * @see #allocateObjectById
     * @see #allocateObjectByType
     * 
     **/
    public void
    setAllocationTimeout(int timeout)
    {
        setAllocationTimeout(timeout, null, false);
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, the request will hang for the duration of 
     * this timeout.
     * 
     * @param timeout The timeout in milliseconds.
     * 
     * @see #allocateObjectById
     * @see #allocateObjectByType
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    setAllocationTimeout(int timeout, java.util.Map<String, String> __ctx)
    {
        setAllocationTimeout(timeout, __ctx, true);
    }

    private void
    setAllocationTimeout(int timeout, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _SessionDel __del = (_SessionDel)__delBase;
                __del.setAllocationTimeout(timeout, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __setAllocationTimeout_name = "setAllocationTimeout";

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, the request will hang for the duration of 
     * this timeout.
     * 
     * @param __cb The callback object for the operation.
     * @param timeout The timeout in milliseconds.
     * 
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout)
    {
        return begin_setAllocationTimeout(timeout, null, false, null);
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, the request will hang for the duration of 
     * this timeout.
     * 
     * @param __cb The callback object for the operation.
     * @param timeout The timeout in milliseconds.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout, java.util.Map<String, String> __ctx)
    {
        return begin_setAllocationTimeout(timeout, __ctx, true, null);
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, the request will hang for the duration of 
     * this timeout.
     * 
     * @param __cb The callback object for the operation.
     * @param timeout The timeout in milliseconds.
     * 
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout, Ice.Callback __cb)
    {
        return begin_setAllocationTimeout(timeout, null, false, __cb);
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, the request will hang for the duration of 
     * this timeout.
     * 
     * @param __cb The callback object for the operation.
     * @param timeout The timeout in milliseconds.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_setAllocationTimeout(timeout, __ctx, true, __cb);
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, the request will hang for the duration of 
     * this timeout.
     * 
     * @param __cb The callback object for the operation.
     * @param timeout The timeout in milliseconds.
     * 
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout, Callback_Session_setAllocationTimeout __cb)
    {
        return begin_setAllocationTimeout(timeout, null, false, __cb);
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, the request will hang for the duration of 
     * this timeout.
     * 
     * @param __cb The callback object for the operation.
     * @param timeout The timeout in milliseconds.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_setAllocationTimeout(int timeout, java.util.Map<String, String> __ctx, Callback_Session_setAllocationTimeout __cb)
    {
        return begin_setAllocationTimeout(timeout, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_setAllocationTimeout(int timeout, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __setAllocationTimeout_name, __cb);
        try
        {
            __result.__prepare(__setAllocationTimeout_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeInt(timeout);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_setAllocationTimeout(Ice.AsyncResult __result)
    {
        __end(__result, __setAllocationTimeout_name);
    }

    public static SessionPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        SessionPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (SessionPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceGrid::Session"))
                {
                    SessionPrxHelper __h = new SessionPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static SessionPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        SessionPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (SessionPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceGrid::Session", __ctx))
                {
                    SessionPrxHelper __h = new SessionPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static SessionPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        SessionPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceGrid::Session"))
                {
                    SessionPrxHelper __h = new SessionPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static SessionPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        SessionPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceGrid::Session", __ctx))
                {
                    SessionPrxHelper __h = new SessionPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static SessionPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        SessionPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (SessionPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                SessionPrxHelper __h = new SessionPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static SessionPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        SessionPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            SessionPrxHelper __h = new SessionPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _SessionDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _SessionDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, SessionPrx v)
    {
        __os.writeProxy(v);
    }

    public static SessionPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            SessionPrxHelper result = new SessionPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
