// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * Used by administrative clients to view,
 * update, and receive observer updates from the IceGrid
 * registry. Admin sessions are created either with the {@link Registry}
 * object or the registry admin {@link Glacier2.SessionManager} object.
 * 
 * @see Registry
 * @see Glacier2.SessionManager
 * 
 **/
public interface _AdminSessionOperationsNC extends Glacier2._SessionOperationsNC
{
    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @see Registry#getSessionTimeout
     * 
     **/
    void keepAlive();

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * 
     * @return The admin interface proxy.
     * 
     **/
    AdminPrx getAdmin();

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * 
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     * 
     **/
    Ice.ObjectPrx getAdminCallbackTemplate();

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * 
     * @param registryObs The registry observer.
     * 
     * @param nodeObs The node observer.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     * 
     **/
    void setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs)
        throws ObserverAlreadyRegisteredException;

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * 
     * @param registryObs The registry observer identity.
     * 
     * @param nodeObs The node observer identity.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     * 
     **/
    void setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs)
        throws ObserverAlreadyRegisteredException;

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * 
     * @return The current serial.
     * 
     * @throws AccessDeniedException Raised if the exclusive lock can't be
     * acquired. This might happen if the lock is currently acquired by
     * another session.
     * 
     **/
    int startUpdate()
        throws AccessDeniedException;

    /**
     * Finish updating the registry and release the exclusive lock.
     * 
     * @throws AccessDeniedException Raised if the session doesn't hold the
     * exclusive lock.
     * 
     **/
    void finishUpdate()
        throws AccessDeniedException;

    /**
     * Get the name of the registry replica hosting this session.
     * 
     * @return The replica name of the registry.
     * 
     **/
    String getReplicaName();

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param id The server id.
     * 
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    FileIteratorPrx openServerLog(String id, String path, int count)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    FileIteratorPrx openServerStdErr(String id, int count)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    FileIteratorPrx openServerStdOut(String id, int count)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     **/
    FileIteratorPrx openNodeStdErr(String name, int count)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException;

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     **/
    FileIteratorPrx openNodeStdOut(String name, int count)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException;

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     * 
     **/
    FileIteratorPrx openRegistryStdErr(String name, int count)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     * 
     **/
    FileIteratorPrx openRegistryStdOut(String name, int count)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException;
}
