// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Query.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * The IceGrid query interface. This interface is accessible to
 * Ice clients who wish to look up well-known objects.
 * 
 **/
public abstract class _QueryDisp extends Ice.ObjectImpl implements Query
{
    protected void
    ice_copyStateFrom(Ice.Object __obj)
        throws java.lang.CloneNotSupportedException
    {
        throw new java.lang.CloneNotSupportedException();
    }

    public static final String[] __ids =
    {
        "::Ice::Object",
        "::IceGrid::Query"
    };

    public boolean
    ice_isA(String s)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public boolean
    ice_isA(String s, Ice.Current __current)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public String[]
    ice_ids()
    {
        return __ids;
    }

    public String[]
    ice_ids(Ice.Current __current)
    {
        return __ids;
    }

    public String
    ice_id()
    {
        return __ids[1];
    }

    public String
    ice_id(Ice.Current __current)
    {
        return __ids[1];
    }

    public static String
    ice_staticId()
    {
        return __ids[1];
    }

    /**
     * Find all the well-known objects with the given type.
     * 
     * @param type The object type.
     * 
     * @return The proxies or an empty sequence, if no such objects
     * have been found.
     * 
     **/
    public final Ice.ObjectPrx[]
    findAllObjectsByType(String type)
    {
        return findAllObjectsByType(type, null);
    }

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * 
     * @param proxy The object proxy.
     * 
     * @return The proxies of each object replica or an empty sequence,
     * if the given proxy is not from a replica group.
     * 
     **/
    public final Ice.ObjectPrx[]
    findAllReplicas(Ice.ObjectPrx proxy)
    {
        return findAllReplicas(proxy, null);
    }

    /**
     * Find a well-known object by identity.
     * 
     * @param id The identity.
     * 
     * @return The proxy or null if no such object has been found.
     * 
     **/
    public final Ice.ObjectPrx
    findObjectById(Ice.Identity id)
    {
        return findObjectById(id, null);
    }

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * 
     * @param type The object type.
     * 
     * @return The proxy or null, if no such object has been found.
     * 
     **/
    public final Ice.ObjectPrx
    findObjectByType(String type)
    {
        return findObjectByType(type, null);
    }

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * 
     * @param type The object type.
     * 
     * @param sample The sampling interval.
     * 
     * @return The proxy or null, if no such object has been found.
     * 
     **/
    public final Ice.ObjectPrx
    findObjectByTypeOnLeastLoadedNode(String type, LoadSample sample)
    {
        return findObjectByTypeOnLeastLoadedNode(type, sample, null);
    }

    public static Ice.DispatchStatus
    ___findObjectById(Query __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        Ice.Identity id;
        id = new Ice.Identity();
        id.__read(__is);
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        Ice.ObjectPrx __ret = __obj.findObjectById(id, __current);
        __os.writeProxy(__ret);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus
    ___findObjectByType(Query __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String type;
        type = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        Ice.ObjectPrx __ret = __obj.findObjectByType(type, __current);
        __os.writeProxy(__ret);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus
    ___findObjectByTypeOnLeastLoadedNode(Query __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String type;
        type = __is.readString();
        LoadSample sample;
        sample = LoadSample.__read(__is);
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        Ice.ObjectPrx __ret = __obj.findObjectByTypeOnLeastLoadedNode(type, sample, __current);
        __os.writeProxy(__ret);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus
    ___findAllObjectsByType(Query __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        String type;
        type = __is.readString();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        Ice.ObjectPrx[] __ret = __obj.findAllObjectsByType(type, __current);
        Ice.ObjectProxySeqHelper.write(__os, __ret);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus
    ___findAllReplicas(Query __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        Ice.ObjectPrx proxy;
        proxy = __is.readProxy();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        Ice.ObjectPrx[] __ret = __obj.findAllReplicas(proxy, __current);
        Ice.ObjectProxySeqHelper.write(__os, __ret);
        return Ice.DispatchStatus.DispatchOK;
    }

    private final static String[] __all =
    {
        "findAllObjectsByType",
        "findAllReplicas",
        "findObjectById",
        "findObjectByType",
        "findObjectByTypeOnLeastLoadedNode",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping"
    };

    public Ice.DispatchStatus
    __dispatch(IceInternal.Incoming in, Ice.Current __current)
    {
        int pos = java.util.Arrays.binarySearch(__all, __current.operation);
        if(pos < 0)
        {
            throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return ___findAllObjectsByType(this, in, __current);
            }
            case 1:
            {
                return ___findAllReplicas(this, in, __current);
            }
            case 2:
            {
                return ___findObjectById(this, in, __current);
            }
            case 3:
            {
                return ___findObjectByType(this, in, __current);
            }
            case 4:
            {
                return ___findObjectByTypeOnLeastLoadedNode(this, in, __current);
            }
            case 5:
            {
                return ___ice_id(this, in, __current);
            }
            case 6:
            {
                return ___ice_ids(this, in, __current);
            }
            case 7:
            {
                return ___ice_isA(this, in, __current);
            }
            case 8:
            {
                return ___ice_ping(this, in, __current);
            }
        }

        assert(false);
        throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    public void
    __write(IceInternal.BasicStream __os)
    {
        __os.writeTypeId(ice_staticId());
        __os.startWriteSlice();
        __os.endWriteSlice();
        super.__write(__os);
    }

    public void
    __read(IceInternal.BasicStream __is, boolean __rid)
    {
        if(__rid)
        {
            __is.readTypeId();
        }
        __is.startReadSlice();
        __is.endReadSlice();
        super.__read(__is, true);
    }

    public void
    __write(Ice.OutputStream __outS)
    {
        Ice.MarshalException ex = new Ice.MarshalException();
        ex.reason = "type IceGrid::Query was not generated with stream support";
        throw ex;
    }

    public void
    __read(Ice.InputStream __inS, boolean __rid)
    {
        Ice.MarshalException ex = new Ice.MarshalException();
        ex.reason = "type IceGrid::Query was not generated with stream support";
        throw ex;
    }
}
