// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Registry.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * The IceGrid registry allows clients create sessions
 * directly with the registry.
 * 
 * @see Session
 * @see AdminSession
 * 
 **/
public interface _RegistryOperations
{
    /**
     * Create a client session.
     * 
     * @see Session
     * @see Glacier2.PermissionsVerifier
     * 
     * @param __current The Current object for the invocation.
     * @return A proxy for the newly created session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    SessionPrx createSession(String userId, String password, Ice.Current __current)
        throws PermissionDeniedException;

    /**
     * Create an administrative session.
     * 
     * @see Session
     * @see Glacier2.PermissionsVerifier
     * 
     * @param __current The Current object for the invocation.
     * @return A proxy for the newly created session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    AdminSessionPrx createAdminSession(String userId, String password, Ice.Current __current)
        throws PermissionDeniedException;

    /**
     * Create a client session from a secure connection.
     * 
     * @see Session
     * @see Glacier2.SSLPermissionsVerifier
     * 
     * @param __current The Current object for the invocation.
     * @return A proxy for the newly created session.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    SessionPrx createSessionFromSecureConnection(Ice.Current __current)
        throws PermissionDeniedException;

    /**
     * Create an administrative session from a secure connection.
     * 
     * @see Session
     * @see Glacier2.SSLPermissionsVerifier
     * 
     * @param __current The Current object for the invocation.
     * @return A proxy for the newly created session.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    AdminSessionPrx createAdminSessionFromSecureConnection(Ice.Current __current)
        throws PermissionDeniedException;

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     * 
     * @param __current The Current object for the invocation.
     * @return The timeout (in seconds).
     * 
     **/
    int getSessionTimeout(Ice.Current __current);
}
