// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceStorm;

// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * A topic manager manages topics, and subscribers to topics.
 * 
 * @see Topic
 * 
 **/
public interface TopicManagerPrx extends Ice.ObjectPrx
{
    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param name The name of the topic.
     * 
     * @return A proxy to the topic instance.
     * 
     * @throws TopicExists Raised if a topic with the same name already
     * exists.
     * 
     **/
    public TopicPrx create(String name)
        throws TopicExists;

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy to the topic instance.
     * 
     * @throws TopicExists Raised if a topic with the same name already
     * exists.
     * 
     **/
    public TopicPrx create(String name, java.util.Map<String, String> __ctx)
        throws TopicExists;

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param name The name of the topic.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name, java.util.Map<String, String> __ctx);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param name The name of the topic.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name, Ice.Callback __cb);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param name The name of the topic.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name, Callback_TopicManager_create __cb);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name, java.util.Map<String, String> __ctx, Callback_TopicManager_create __cb);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param __result The asynchronous result object.
     * @return A proxy to the topic instance.
     * 
     * @throws TopicExists Raised if a topic with the same name already
     * exists.
     * 
     **/
    public TopicPrx end_create(Ice.AsyncResult __result)
        throws TopicExists;

    /**
     * Retrieve a topic by name.
     * 
     * @param name The name of the topic.
     * 
     * @return A proxy to the topic instance.
     * 
     * @throws NoSuchTopic Raised if the topic does not exist.
     * 
     **/
    public TopicPrx retrieve(String name)
        throws NoSuchTopic;

    /**
     * Retrieve a topic by name.
     * 
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy to the topic instance.
     * 
     * @throws NoSuchTopic Raised if the topic does not exist.
     * 
     **/
    public TopicPrx retrieve(String name, java.util.Map<String, String> __ctx)
        throws NoSuchTopic;

    /**
     * Retrieve a topic by name.
     * 
     * @param name The name of the topic.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name);

    /**
     * Retrieve a topic by name.
     * 
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name, java.util.Map<String, String> __ctx);

    /**
     * Retrieve a topic by name.
     * 
     * @param name The name of the topic.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name, Ice.Callback __cb);

    /**
     * Retrieve a topic by name.
     * 
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Retrieve a topic by name.
     * 
     * @param name The name of the topic.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name, Callback_TopicManager_retrieve __cb);

    /**
     * Retrieve a topic by name.
     * 
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name, java.util.Map<String, String> __ctx, Callback_TopicManager_retrieve __cb);

    /**
     * Retrieve a topic by name.
     * 
     * @param __result The asynchronous result object.
     * @return A proxy to the topic instance.
     * 
     * @throws NoSuchTopic Raised if the topic does not exist.
     * 
     **/
    public TopicPrx end_retrieve(Ice.AsyncResult __result)
        throws NoSuchTopic;

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @return A dictionary of string, topic proxy pairs.
     * 
     **/
    public java.util.Map<java.lang.String, TopicPrx> retrieveAll();

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A dictionary of string, topic proxy pairs.
     * 
     **/
    public java.util.Map<java.lang.String, TopicPrx> retrieveAll(java.util.Map<String, String> __ctx);

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll();

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll(java.util.Map<String, String> __ctx);

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll(Ice.Callback __cb);

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll(Callback_TopicManager_retrieveAll __cb);

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll(java.util.Map<String, String> __ctx, Callback_TopicManager_retrieveAll __cb);

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @param __result The asynchronous result object.
     * @return A dictionary of string, topic proxy pairs.
     * 
     **/
    public java.util.Map<java.lang.String, TopicPrx> end_retrieveAll(Ice.AsyncResult __result);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @return A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String> getSliceChecksums();

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String> getSliceChecksums(java.util.Map<String, String> __ctx);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums();

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Ice.Callback __cb);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Callback_TopicManager_getSliceChecksums __cb);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx, Callback_TopicManager_getSliceChecksums __cb);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @param __result The asynchronous result object.
     * @return A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String> end_getSliceChecksums(Ice.AsyncResult __result);
}
