// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceStorm;

// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * Publishers publish information on a particular topic. A topic
 * logically represents a type.
 * 
 * @see TopicManager
 * 
 **/
public final class TopicPrxHelper extends Ice.ObjectPrxHelperBase implements TopicPrx
{
    /**
     * Destroy the topic.
     * 
     **/
    public void
    destroy()
    {
        destroy(null, false);
    }

    /**
     * Destroy the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    destroy(java.util.Map<String, String> __ctx)
    {
        destroy(__ctx, true);
    }

    private void
    destroy(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _TopicDel __del = (_TopicDel)__delBase;
                __del.destroy(__ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __destroy_name = "destroy";

    /**
     * Destroy the topic.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_destroy()
    {
        return begin_destroy(null, false, null);
    }

    /**
     * Destroy the topic.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx)
    {
        return begin_destroy(__ctx, true, null);
    }

    /**
     * Destroy the topic.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_destroy(Ice.Callback __cb)
    {
        return begin_destroy(null, false, __cb);
    }

    /**
     * Destroy the topic.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_destroy(__ctx, true, __cb);
    }

    /**
     * Destroy the topic.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_destroy(Callback_Topic_destroy __cb)
    {
        return begin_destroy(null, false, __cb);
    }

    /**
     * Destroy the topic.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx, Callback_Topic_destroy __cb)
    {
        return begin_destroy(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __destroy_name, __cb);
        try
        {
            __result.__prepare(__destroy_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_destroy(Ice.AsyncResult __result)
    {
        __end(__result, __destroy_name);
    }

    /**
     * Retrieve information on the current links.
     * 
     * @return A sequence of LinkInfo objects.
     * 
     **/
    public LinkInfo[]
    getLinkInfoSeq()
    {
        return getLinkInfoSeq(null, false);
    }

    /**
     * Retrieve information on the current links.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A sequence of LinkInfo objects.
     * 
     **/
    public LinkInfo[]
    getLinkInfoSeq(java.util.Map<String, String> __ctx)
    {
        return getLinkInfoSeq(__ctx, true);
    }

    private LinkInfo[]
    getLinkInfoSeq(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getLinkInfoSeq");
                __delBase = __getDelegate(false);
                _TopicDel __del = (_TopicDel)__delBase;
                return __del.getLinkInfoSeq(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getLinkInfoSeq_name = "getLinkInfoSeq";

    /**
     * Retrieve information on the current links.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq()
    {
        return begin_getLinkInfoSeq(null, false, null);
    }

    /**
     * Retrieve information on the current links.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq(java.util.Map<String, String> __ctx)
    {
        return begin_getLinkInfoSeq(__ctx, true, null);
    }

    /**
     * Retrieve information on the current links.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq(Ice.Callback __cb)
    {
        return begin_getLinkInfoSeq(null, false, __cb);
    }

    /**
     * Retrieve information on the current links.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getLinkInfoSeq(__ctx, true, __cb);
    }

    /**
     * Retrieve information on the current links.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq(Callback_Topic_getLinkInfoSeq __cb)
    {
        return begin_getLinkInfoSeq(null, false, __cb);
    }

    /**
     * Retrieve information on the current links.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq(java.util.Map<String, String> __ctx, Callback_Topic_getLinkInfoSeq __cb)
    {
        return begin_getLinkInfoSeq(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getLinkInfoSeq(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getLinkInfoSeq_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getLinkInfoSeq_name, __cb);
        try
        {
            __result.__prepare(__getLinkInfoSeq_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A sequence of LinkInfo objects.
     * 
     **/
    public LinkInfo[] end_getLinkInfoSeq(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getLinkInfoSeq_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        LinkInfo[] __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = LinkInfoSeqHelper.read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the name of this topic.
     * 
     * @return The name of the topic.
     * 
     * @see TopicManager#create
     * 
     **/
    public String
    getName()
    {
        return getName(null, false);
    }

    /**
     * Get the name of this topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The name of the topic.
     * 
     * @see TopicManager#create
     * 
     **/
    public String
    getName(java.util.Map<String, String> __ctx)
    {
        return getName(__ctx, true);
    }

    private String
    getName(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getName");
                __delBase = __getDelegate(false);
                _TopicDel __del = (_TopicDel)__delBase;
                return __del.getName(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getName_name = "getName";

    /**
     * Get the name of this topic.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getName()
    {
        return begin_getName(null, false, null);
    }

    /**
     * Get the name of this topic.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getName(java.util.Map<String, String> __ctx)
    {
        return begin_getName(__ctx, true, null);
    }

    /**
     * Get the name of this topic.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getName(Ice.Callback __cb)
    {
        return begin_getName(null, false, __cb);
    }

    /**
     * Get the name of this topic.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getName(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getName(__ctx, true, __cb);
    }

    /**
     * Get the name of this topic.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getName(Callback_Topic_getName __cb)
    {
        return begin_getName(null, false, __cb);
    }

    /**
     * Get the name of this topic.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getName(java.util.Map<String, String> __ctx, Callback_Topic_getName __cb)
    {
        return begin_getName(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getName(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getName_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getName_name, __cb);
        try
        {
            __result.__prepare(__getName_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The name of the topic.
     * 
     **/
    public String end_getName(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getName_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        String __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readString();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link #getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * 
     * @return A proxy to publish data on this topic.
     * 
     **/
    public Ice.ObjectPrx
    getNonReplicatedPublisher()
    {
        return getNonReplicatedPublisher(null, false);
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link #getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy to publish data on this topic.
     * 
     **/
    public Ice.ObjectPrx
    getNonReplicatedPublisher(java.util.Map<String, String> __ctx)
    {
        return getNonReplicatedPublisher(__ctx, true);
    }

    private Ice.ObjectPrx
    getNonReplicatedPublisher(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getNonReplicatedPublisher");
                __delBase = __getDelegate(false);
                _TopicDel __del = (_TopicDel)__delBase;
                return __del.getNonReplicatedPublisher(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getNonReplicatedPublisher_name = "getNonReplicatedPublisher";

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link #getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher()
    {
        return begin_getNonReplicatedPublisher(null, false, null);
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link #getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher(java.util.Map<String, String> __ctx)
    {
        return begin_getNonReplicatedPublisher(__ctx, true, null);
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link #getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher(Ice.Callback __cb)
    {
        return begin_getNonReplicatedPublisher(null, false, __cb);
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link #getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getNonReplicatedPublisher(__ctx, true, __cb);
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link #getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher(Callback_Topic_getNonReplicatedPublisher __cb)
    {
        return begin_getNonReplicatedPublisher(null, false, __cb);
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link #getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher(java.util.Map<String, String> __ctx, Callback_Topic_getNonReplicatedPublisher __cb)
    {
        return begin_getNonReplicatedPublisher(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getNonReplicatedPublisher(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getNonReplicatedPublisher_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getNonReplicatedPublisher_name, __cb);
        try
        {
            __result.__prepare(__getNonReplicatedPublisher_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A proxy to publish data on this topic.
     * 
     **/
    public Ice.ObjectPrx end_getNonReplicatedPublisher(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getNonReplicatedPublisher_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        Ice.ObjectPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readProxy();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link #getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * 
     * @return A proxy to publish data on this topic.
     * 
     **/
    public Ice.ObjectPrx
    getPublisher()
    {
        return getPublisher(null, false);
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link #getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy to publish data on this topic.
     * 
     **/
    public Ice.ObjectPrx
    getPublisher(java.util.Map<String, String> __ctx)
    {
        return getPublisher(__ctx, true);
    }

    private Ice.ObjectPrx
    getPublisher(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getPublisher");
                __delBase = __getDelegate(false);
                _TopicDel __del = (_TopicDel)__delBase;
                return __del.getPublisher(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getPublisher_name = "getPublisher";

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link #getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getPublisher()
    {
        return begin_getPublisher(null, false, null);
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link #getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getPublisher(java.util.Map<String, String> __ctx)
    {
        return begin_getPublisher(__ctx, true, null);
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link #getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getPublisher(Ice.Callback __cb)
    {
        return begin_getPublisher(null, false, __cb);
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link #getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getPublisher(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getPublisher(__ctx, true, __cb);
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link #getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getPublisher(Callback_Topic_getPublisher __cb)
    {
        return begin_getPublisher(null, false, __cb);
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link #getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getPublisher(java.util.Map<String, String> __ctx, Callback_Topic_getPublisher __cb)
    {
        return begin_getPublisher(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getPublisher(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getPublisher_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getPublisher_name, __cb);
        try
        {
            __result.__prepare(__getPublisher_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A proxy to publish data on this topic.
     * 
     **/
    public Ice.ObjectPrx end_getPublisher(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getPublisher_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        Ice.ObjectPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readProxy();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     * 
     * @param linkTo The topic to link to.
     * 
     * @param cost The cost to the linked topic.
     * 
     * @throws LinkExists Raised if a link to the same topic already
     * exists.
     * 
     **/
    public void
    link(TopicPrx linkTo, int cost)
        throws LinkExists
    {
        link(linkTo, cost, null, false);
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     * 
     * @param linkTo The topic to link to.
     * 
     * @param cost The cost to the linked topic.
     * 
     * @throws LinkExists Raised if a link to the same topic already
     * exists.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    link(TopicPrx linkTo, int cost, java.util.Map<String, String> __ctx)
        throws LinkExists
    {
        link(linkTo, cost, __ctx, true);
    }

    private void
    link(TopicPrx linkTo, int cost, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws LinkExists
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("link");
                __delBase = __getDelegate(false);
                _TopicDel __del = (_TopicDel)__delBase;
                __del.link(linkTo, cost, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __link_name = "link";

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param linkTo The topic to link to.
     * 
     * @param cost The cost to the linked topic.
     * 
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo, int cost)
    {
        return begin_link(linkTo, cost, null, false, null);
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param linkTo The topic to link to.
     * 
     * @param cost The cost to the linked topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo, int cost, java.util.Map<String, String> __ctx)
    {
        return begin_link(linkTo, cost, __ctx, true, null);
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param linkTo The topic to link to.
     * 
     * @param cost The cost to the linked topic.
     * 
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo, int cost, Ice.Callback __cb)
    {
        return begin_link(linkTo, cost, null, false, __cb);
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param linkTo The topic to link to.
     * 
     * @param cost The cost to the linked topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo, int cost, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_link(linkTo, cost, __ctx, true, __cb);
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param linkTo The topic to link to.
     * 
     * @param cost The cost to the linked topic.
     * 
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo, int cost, Callback_Topic_link __cb)
    {
        return begin_link(linkTo, cost, null, false, __cb);
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param linkTo The topic to link to.
     * 
     * @param cost The cost to the linked topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo, int cost, java.util.Map<String, String> __ctx, Callback_Topic_link __cb)
    {
        return begin_link(linkTo, cost, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_link(TopicPrx linkTo, int cost, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__link_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __link_name, __cb);
        try
        {
            __result.__prepare(__link_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            TopicPrxHelper.__write(__os, linkTo);
            __os.writeInt(cost);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_link(Ice.AsyncResult __result)
        throws LinkExists
    {
        Ice.AsyncResult.__check(__result, this, __link_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(LinkExists __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic. If the given
     * <tt>subscriber</tt> proxy has already been registered, it will be
     * replaced. Note that this can cause a loss of events to the
     * subscribed object.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.2.
     * 
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     * @return The per-subscriber publisher object.
     * 
     * @see #unsubscribe
     * 
     * @deprecated subscribe is deprecated, use subscribeAndGetPublisher instead
     **/
    public void
    subscribe(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber)
    {
        subscribe(theQoS, subscriber, null, false);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic. If the given
     * <tt>subscriber</tt> proxy has already been registered, it will be
     * replaced. Note that this can cause a loss of events to the
     * subscribed object.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.2.
     * 
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The per-subscriber publisher object.
     * 
     * @see #unsubscribe
     * 
     * @deprecated subscribe is deprecated, use subscribeAndGetPublisher instead
     **/
    public void
    subscribe(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx)
    {
        subscribe(theQoS, subscriber, __ctx, true);
    }

    private void
    subscribe(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _TopicDel __del = (_TopicDel)__delBase;
                __del.subscribe(theQoS, subscriber, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __subscribe_name = "subscribe";

    /**
     * Subscribe with the given <tt>qos</tt> to this topic. If the given
     * <tt>subscriber</tt> proxy has already been registered, it will be
     * replaced. Note that this can cause a loss of events to the
     * subscribed object.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.2.
     * 
     * @param __cb The callback object for the operation.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     * @deprecated subscribe is deprecated, use subscribeAndGetPublisher instead
     **/
    public Ice.AsyncResult begin_subscribe(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber)
    {
        return begin_subscribe(theQoS, subscriber, null, false, null);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic. If the given
     * <tt>subscriber</tt> proxy has already been registered, it will be
     * replaced. Note that this can cause a loss of events to the
     * subscribed object.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.2.
     * 
     * @param __cb The callback object for the operation.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @deprecated subscribe is deprecated, use subscribeAndGetPublisher instead
     **/
    public Ice.AsyncResult begin_subscribe(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx)
    {
        return begin_subscribe(theQoS, subscriber, __ctx, true, null);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic. If the given
     * <tt>subscriber</tt> proxy has already been registered, it will be
     * replaced. Note that this can cause a loss of events to the
     * subscribed object.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.2.
     * 
     * @param __cb The callback object for the operation.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     * @deprecated subscribe is deprecated, use subscribeAndGetPublisher instead
     **/
    public Ice.AsyncResult begin_subscribe(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, Ice.Callback __cb)
    {
        return begin_subscribe(theQoS, subscriber, null, false, __cb);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic. If the given
     * <tt>subscriber</tt> proxy has already been registered, it will be
     * replaced. Note that this can cause a loss of events to the
     * subscribed object.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.2.
     * 
     * @param __cb The callback object for the operation.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @deprecated subscribe is deprecated, use subscribeAndGetPublisher instead
     **/
    public Ice.AsyncResult begin_subscribe(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_subscribe(theQoS, subscriber, __ctx, true, __cb);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic. If the given
     * <tt>subscriber</tt> proxy has already been registered, it will be
     * replaced. Note that this can cause a loss of events to the
     * subscribed object.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.2.
     * 
     * @param __cb The callback object for the operation.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     * @deprecated subscribe is deprecated, use subscribeAndGetPublisher instead
     **/
    public Ice.AsyncResult begin_subscribe(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, Callback_Topic_subscribe __cb)
    {
        return begin_subscribe(theQoS, subscriber, null, false, __cb);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic. If the given
     * <tt>subscriber</tt> proxy has already been registered, it will be
     * replaced. Note that this can cause a loss of events to the
     * subscribed object.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.2.
     * 
     * @param __cb The callback object for the operation.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @deprecated subscribe is deprecated, use subscribeAndGetPublisher instead
     **/
    public Ice.AsyncResult begin_subscribe(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx, Callback_Topic_subscribe __cb)
    {
        return begin_subscribe(theQoS, subscriber, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_subscribe(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __subscribe_name, __cb);
        try
        {
            __result.__prepare(__subscribe_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            QoSHelper.write(__os, theQoS);
            __os.writeProxy(subscriber);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The per-subscriber publisher object.
     * 
     **/
    public void end_subscribe(Ice.AsyncResult __result)
    {
        __end(__result, __subscribe_name);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     * 
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     * @return The per-subscriber publisher object.
     * 
     * @throws AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     * 
     * @throws BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     * 
     * @see #unsubscribe
     * 
     **/
    public Ice.ObjectPrx
    subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber)
        throws AlreadySubscribed,
               BadQoS
    {
        return subscribeAndGetPublisher(theQoS, subscriber, null, false);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     * 
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The per-subscriber publisher object.
     * 
     * @throws AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     * 
     * @throws BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     * 
     * @see #unsubscribe
     * 
     **/
    public Ice.ObjectPrx
    subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx)
        throws AlreadySubscribed,
               BadQoS
    {
        return subscribeAndGetPublisher(theQoS, subscriber, __ctx, true);
    }

    private Ice.ObjectPrx
    subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws AlreadySubscribed,
               BadQoS
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("subscribeAndGetPublisher");
                __delBase = __getDelegate(false);
                _TopicDel __del = (_TopicDel)__delBase;
                return __del.subscribeAndGetPublisher(theQoS, subscriber, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __subscribeAndGetPublisher_name = "subscribeAndGetPublisher";

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     * 
     * @param __cb The callback object for the operation.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber)
    {
        return begin_subscribeAndGetPublisher(theQoS, subscriber, null, false, null);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     * 
     * @param __cb The callback object for the operation.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx)
    {
        return begin_subscribeAndGetPublisher(theQoS, subscriber, __ctx, true, null);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     * 
     * @param __cb The callback object for the operation.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, Ice.Callback __cb)
    {
        return begin_subscribeAndGetPublisher(theQoS, subscriber, null, false, __cb);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     * 
     * @param __cb The callback object for the operation.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_subscribeAndGetPublisher(theQoS, subscriber, __ctx, true, __cb);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     * 
     * @param __cb The callback object for the operation.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, Callback_Topic_subscribeAndGetPublisher __cb)
    {
        return begin_subscribeAndGetPublisher(theQoS, subscriber, null, false, __cb);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     * 
     * @param __cb The callback object for the operation.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx, Callback_Topic_subscribeAndGetPublisher __cb)
    {
        return begin_subscribeAndGetPublisher(theQoS, subscriber, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__subscribeAndGetPublisher_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __subscribeAndGetPublisher_name, __cb);
        try
        {
            __result.__prepare(__subscribeAndGetPublisher_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            QoSHelper.write(__os, theQoS);
            __os.writeProxy(subscriber);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The per-subscriber publisher object.
     * 
     **/
    public Ice.ObjectPrx end_subscribeAndGetPublisher(Ice.AsyncResult __result)
        throws AlreadySubscribed,
               BadQoS
    {
        Ice.AsyncResult.__check(__result, this, __subscribeAndGetPublisher_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(AlreadySubscribed __ex)
            {
                throw __ex;
            }
            catch(BadQoS __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        Ice.ObjectPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readProxy();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     * 
     * @param linkTo The topic to destroy the link to.
     * 
     * @throws NoSuchLink Raised if a link to the topic does not exist.
     * 
     **/
    public void
    unlink(TopicPrx linkTo)
        throws NoSuchLink
    {
        unlink(linkTo, null, false);
    }

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     * 
     * @param linkTo The topic to destroy the link to.
     * 
     * @throws NoSuchLink Raised if a link to the topic does not exist.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    unlink(TopicPrx linkTo, java.util.Map<String, String> __ctx)
        throws NoSuchLink
    {
        unlink(linkTo, __ctx, true);
    }

    private void
    unlink(TopicPrx linkTo, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws NoSuchLink
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("unlink");
                __delBase = __getDelegate(false);
                _TopicDel __del = (_TopicDel)__delBase;
                __del.unlink(linkTo, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __unlink_name = "unlink";

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param linkTo The topic to destroy the link to.
     * 
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo)
    {
        return begin_unlink(linkTo, null, false, null);
    }

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param linkTo The topic to destroy the link to.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo, java.util.Map<String, String> __ctx)
    {
        return begin_unlink(linkTo, __ctx, true, null);
    }

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param linkTo The topic to destroy the link to.
     * 
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo, Ice.Callback __cb)
    {
        return begin_unlink(linkTo, null, false, __cb);
    }

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param linkTo The topic to destroy the link to.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_unlink(linkTo, __ctx, true, __cb);
    }

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param linkTo The topic to destroy the link to.
     * 
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo, Callback_Topic_unlink __cb)
    {
        return begin_unlink(linkTo, null, false, __cb);
    }

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param linkTo The topic to destroy the link to.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo, java.util.Map<String, String> __ctx, Callback_Topic_unlink __cb)
    {
        return begin_unlink(linkTo, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_unlink(TopicPrx linkTo, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__unlink_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __unlink_name, __cb);
        try
        {
            __result.__prepare(__unlink_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            TopicPrxHelper.__write(__os, linkTo);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_unlink(Ice.AsyncResult __result)
        throws NoSuchLink
    {
        Ice.AsyncResult.__check(__result, this, __unlink_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(NoSuchLink __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     * 
     * @param subscriber The proxy of an existing subscriber.
     * 
     * @see #subscribe
     * 
     **/
    public void
    unsubscribe(Ice.ObjectPrx subscriber)
    {
        unsubscribe(subscriber, null, false);
    }

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     * 
     * @param subscriber The proxy of an existing subscriber.
     * 
     * @see #subscribe
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    unsubscribe(Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx)
    {
        unsubscribe(subscriber, __ctx, true);
    }

    private void
    unsubscribe(Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _TopicDel __del = (_TopicDel)__delBase;
                __del.unsubscribe(subscriber, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __unsubscribe_name = "unsubscribe";

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param subscriber The proxy of an existing subscriber.
     * 
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber)
    {
        return begin_unsubscribe(subscriber, null, false, null);
    }

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param subscriber The proxy of an existing subscriber.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx)
    {
        return begin_unsubscribe(subscriber, __ctx, true, null);
    }

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param subscriber The proxy of an existing subscriber.
     * 
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber, Ice.Callback __cb)
    {
        return begin_unsubscribe(subscriber, null, false, __cb);
    }

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param subscriber The proxy of an existing subscriber.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_unsubscribe(subscriber, __ctx, true, __cb);
    }

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param subscriber The proxy of an existing subscriber.
     * 
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber, Callback_Topic_unsubscribe __cb)
    {
        return begin_unsubscribe(subscriber, null, false, __cb);
    }

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     * 
     * @param __cb The callback object for the operation.
     * @param subscriber The proxy of an existing subscriber.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx, Callback_Topic_unsubscribe __cb)
    {
        return begin_unsubscribe(subscriber, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __unsubscribe_name, __cb);
        try
        {
            __result.__prepare(__unsubscribe_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeProxy(subscriber);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_unsubscribe(Ice.AsyncResult __result)
    {
        __end(__result, __unsubscribe_name);
    }

    public static TopicPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        TopicPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (TopicPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceStorm::Topic"))
                {
                    TopicPrxHelper __h = new TopicPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static TopicPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        TopicPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (TopicPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceStorm::Topic", __ctx))
                {
                    TopicPrxHelper __h = new TopicPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static TopicPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        TopicPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceStorm::Topic"))
                {
                    TopicPrxHelper __h = new TopicPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static TopicPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        TopicPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceStorm::Topic", __ctx))
                {
                    TopicPrxHelper __h = new TopicPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static TopicPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        TopicPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (TopicPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                TopicPrxHelper __h = new TopicPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static TopicPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        TopicPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            TopicPrxHelper __h = new TopicPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _TopicDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _TopicDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, TopicPrx v)
    {
        __os.writeProxy(v);
    }

    public static TopicPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            TopicPrxHelper result = new TopicPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
