// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceStorm;

// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * Publishers publish information on a particular topic. A topic
 * logically represents a type.
 * 
 * @see TopicManager
 * 
 **/
public abstract class _TopicDisp extends Ice.ObjectImpl implements Topic
{
    protected void
    ice_copyStateFrom(Ice.Object __obj)
        throws java.lang.CloneNotSupportedException
    {
        throw new java.lang.CloneNotSupportedException();
    }

    public static final String[] __ids =
    {
        "::Ice::Object",
        "::IceStorm::Topic"
    };

    public boolean
    ice_isA(String s)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public boolean
    ice_isA(String s, Ice.Current __current)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public String[]
    ice_ids()
    {
        return __ids;
    }

    public String[]
    ice_ids(Ice.Current __current)
    {
        return __ids;
    }

    public String
    ice_id()
    {
        return __ids[1];
    }

    public String
    ice_id(Ice.Current __current)
    {
        return __ids[1];
    }

    public static String
    ice_staticId()
    {
        return __ids[1];
    }

    /**
     * Destroy the topic.
     * 
     **/
    public final void
    destroy()
    {
        destroy(null);
    }

    /**
     * Retrieve information on the current links.
     * 
     * @return A sequence of LinkInfo objects.
     * 
     **/
    public final LinkInfo[]
    getLinkInfoSeq()
    {
        return getLinkInfoSeq(null);
    }

    /**
     * Get the name of this topic.
     * 
     * @return The name of the topic.
     * 
     * @see TopicManager#create
     * 
     **/
    public final String
    getName()
    {
        return getName(null);
    }

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link #getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * 
     * @return A proxy to publish data on this topic.
     * 
     **/
    public final Ice.ObjectPrx
    getNonReplicatedPublisher()
    {
        return getNonReplicatedPublisher(null);
    }

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link #getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * 
     * @return A proxy to publish data on this topic.
     * 
     **/
    public final Ice.ObjectPrx
    getPublisher()
    {
        return getPublisher(null);
    }

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     * 
     * @param linkTo The topic to link to.
     * 
     * @param cost The cost to the linked topic.
     * 
     * @throws LinkExists Raised if a link to the same topic already
     * exists.
     * 
     **/
    public final void
    link(TopicPrx linkTo, int cost)
        throws LinkExists
    {
        link(linkTo, cost, null);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic. If the given
     * <tt>subscriber</tt> proxy has already been registered, it will be
     * replaced. Note that this can cause a loss of events to the
     * subscribed object.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.2.
     * 
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     * @return The per-subscriber publisher object.
     * 
     * @see #unsubscribe
     * 
     * @deprecated subscribe is deprecated, use subscribeAndGetPublisher instead
     **/
    public final void
    subscribe(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber)
    {
        subscribe(theQoS, subscriber, null);
    }

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     * 
     * @param theQoS The quality of service parameters for this
     * subscription.
     * 
     * @param subscriber The subscriber's proxy.
     * 
     * @return The per-subscriber publisher object.
     * 
     * @throws AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     * 
     * @throws BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     * 
     * @see #unsubscribe
     * 
     **/
    public final Ice.ObjectPrx
    subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber)
        throws AlreadySubscribed,
               BadQoS
    {
        return subscribeAndGetPublisher(theQoS, subscriber, null);
    }

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     * 
     * @param linkTo The topic to destroy the link to.
     * 
     * @throws NoSuchLink Raised if a link to the topic does not exist.
     * 
     **/
    public final void
    unlink(TopicPrx linkTo)
        throws NoSuchLink
    {
        unlink(linkTo, null);
    }

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     * 
     * @param subscriber The proxy of an existing subscriber.
     * 
     * @see #subscribe
     * 
     **/
    public final void
    unsubscribe(Ice.ObjectPrx subscriber)
    {
        unsubscribe(subscriber, null);
    }

    public static Ice.DispatchStatus
    ___getName(Topic __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.is().skipEmptyEncaps();
        IceInternal.BasicStream __os = __inS.os();
        String __ret = __obj.getName(__current);
        __os.writeString(__ret);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus
    ___getPublisher(Topic __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.is().skipEmptyEncaps();
        IceInternal.BasicStream __os = __inS.os();
        Ice.ObjectPrx __ret = __obj.getPublisher(__current);
        __os.writeProxy(__ret);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus
    ___getNonReplicatedPublisher(Topic __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.is().skipEmptyEncaps();
        IceInternal.BasicStream __os = __inS.os();
        Ice.ObjectPrx __ret = __obj.getNonReplicatedPublisher(__current);
        __os.writeProxy(__ret);
        return Ice.DispatchStatus.DispatchOK;
    }

    /** @deprecated **/
    public static Ice.DispatchStatus
    ___subscribe(Topic __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        java.util.Map<java.lang.String, java.lang.String> theQoS;
        theQoS = QoSHelper.read(__is);
        Ice.ObjectPrx subscriber;
        subscriber = __is.readProxy();
        __is.endReadEncaps();
        __obj.subscribe(theQoS, subscriber, __current);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus
    ___subscribeAndGetPublisher(Topic __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        java.util.Map<java.lang.String, java.lang.String> theQoS;
        theQoS = QoSHelper.read(__is);
        Ice.ObjectPrx subscriber;
        subscriber = __is.readProxy();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            Ice.ObjectPrx __ret = __obj.subscribeAndGetPublisher(theQoS, subscriber, __current);
            __os.writeProxy(__ret);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(AlreadySubscribed ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(BadQoS ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___unsubscribe(Topic __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        Ice.ObjectPrx subscriber;
        subscriber = __is.readProxy();
        __is.endReadEncaps();
        __obj.unsubscribe(subscriber, __current);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus
    ___link(Topic __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        TopicPrx linkTo;
        linkTo = TopicPrxHelper.__read(__is);
        int cost;
        cost = __is.readInt();
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            __obj.link(linkTo, cost, __current);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(LinkExists ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___unlink(Topic __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.is();
        __is.startReadEncaps();
        TopicPrx linkTo;
        linkTo = TopicPrxHelper.__read(__is);
        __is.endReadEncaps();
        IceInternal.BasicStream __os = __inS.os();
        try
        {
            __obj.unlink(linkTo, __current);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(NoSuchLink ex)
        {
            __os.writeUserException(ex);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus
    ___getLinkInfoSeq(Topic __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.is().skipEmptyEncaps();
        IceInternal.BasicStream __os = __inS.os();
        LinkInfo[] __ret = __obj.getLinkInfoSeq(__current);
        LinkInfoSeqHelper.write(__os, __ret);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus
    ___destroy(Topic __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        __inS.is().skipEmptyEncaps();
        __obj.destroy(__current);
        return Ice.DispatchStatus.DispatchOK;
    }

    private final static String[] __all =
    {
        "destroy",
        "getLinkInfoSeq",
        "getName",
        "getNonReplicatedPublisher",
        "getPublisher",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "link",
        "subscribe",
        "subscribeAndGetPublisher",
        "unlink",
        "unsubscribe"
    };

    @SuppressWarnings("deprecation")
    public Ice.DispatchStatus
    __dispatch(IceInternal.Incoming in, Ice.Current __current)
    {
        int pos = java.util.Arrays.binarySearch(__all, __current.operation);
        if(pos < 0)
        {
            throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return ___destroy(this, in, __current);
            }
            case 1:
            {
                return ___getLinkInfoSeq(this, in, __current);
            }
            case 2:
            {
                return ___getName(this, in, __current);
            }
            case 3:
            {
                return ___getNonReplicatedPublisher(this, in, __current);
            }
            case 4:
            {
                return ___getPublisher(this, in, __current);
            }
            case 5:
            {
                return ___ice_id(this, in, __current);
            }
            case 6:
            {
                return ___ice_ids(this, in, __current);
            }
            case 7:
            {
                return ___ice_isA(this, in, __current);
            }
            case 8:
            {
                return ___ice_ping(this, in, __current);
            }
            case 9:
            {
                return ___link(this, in, __current);
            }
            case 10:
            {
                return ___subscribe(this, in, __current);
            }
            case 11:
            {
                return ___subscribeAndGetPublisher(this, in, __current);
            }
            case 12:
            {
                return ___unlink(this, in, __current);
            }
            case 13:
            {
                return ___unsubscribe(this, in, __current);
            }
        }

        assert(false);
        throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    public void
    __write(IceInternal.BasicStream __os)
    {
        __os.writeTypeId(ice_staticId());
        __os.startWriteSlice();
        __os.endWriteSlice();
        super.__write(__os);
    }

    public void
    __read(IceInternal.BasicStream __is, boolean __rid)
    {
        if(__rid)
        {
            __is.readTypeId();
        }
        __is.startReadSlice();
        __is.endReadSlice();
        super.__read(__is, true);
    }

    public void
    __write(Ice.OutputStream __outS)
    {
        Ice.MarshalException ex = new Ice.MarshalException();
        ex.reason = "type IceStorm::Topic was not generated with stream support";
        throw ex;
    }

    public void
    __read(Ice.InputStream __inS, boolean __rid)
    {
        Ice.MarshalException ex = new Ice.MarshalException();
        ex.reason = "type IceStorm::Topic was not generated with stream support";
        throw ex;
    }
}
