// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceStorm;

// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * A topic manager manages topics, and subscribers to topics.
 * 
 * @see Topic
 * 
 **/
public interface _TopicManagerOperations
{
    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param name The name of the topic.
     * 
     * @param __current The Current object for the invocation.
     * @return A proxy to the topic instance.
     * 
     * @throws TopicExists Raised if a topic with the same name already
     * exists.
     * 
     **/
    TopicPrx create(String name, Ice.Current __current)
        throws TopicExists;

    /**
     * Retrieve a topic by name.
     * 
     * @param name The name of the topic.
     * 
     * @param __current The Current object for the invocation.
     * @return A proxy to the topic instance.
     * 
     * @throws NoSuchTopic Raised if the topic does not exist.
     * 
     **/
    TopicPrx retrieve(String name, Ice.Current __current)
        throws NoSuchTopic;

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @param __current The Current object for the invocation.
     * @return A dictionary of string, topic proxy pairs.
     * 
     **/
    java.util.Map<java.lang.String, TopicPrx> retrieveAll(Ice.Current __current);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @param __current The Current object for the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    java.util.Map<java.lang.String, java.lang.String> getSliceChecksums(Ice.Current __current);
}
