/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SliceTask
extends Task {
    protected File _dependencyFile = null;
    protected File _outputDir = null;
    protected String _outputDirString = null;
    protected boolean _ice = false;
    protected boolean _underscore;
    protected Path _includePath = null;
    protected List<FileSet> _fileSets = new LinkedList<FileSet>();
    protected List<SliceDefine> _defines = new LinkedList<SliceDefine>();
    protected List<SliceMeta> _meta = new LinkedList<SliceMeta>();
    private String _iceHome;

    public void setDependencyFile(File file) {
        this._dependencyFile = file;
    }

    public void setOutputdir(File file) {
        this._outputDir = file;
        this._outputDirString = this._outputDir.toString();
        if (this._outputDirString.indexOf(32) != -1) {
            this._outputDirString = '\"' + this._outputDirString + '\"';
        }
    }

    public void setIce(boolean bl) {
        this._ice = bl;
    }

    public void setUnderscore(boolean bl) {
        this._underscore = bl;
    }

    public Path createIncludePath() {
        if (this._includePath == null) {
            this._includePath = new Path(this.getProject());
        }
        return this._includePath.createPath();
    }

    public void setIncludePathRef(Reference reference) {
        this.createIncludePath().setRefid(reference);
    }

    public void setIncludePath(Path path) {
        if (this._includePath == null) {
            this._includePath = path;
        } else {
            this._includePath.append(path);
        }
    }

    public FileSet createFileset() {
        FileSet fileSet = new FileSet();
        this._fileSets.add(fileSet);
        return fileSet;
    }

    public void addConfiguredDefine(SliceDefine sliceDefine) throws BuildException {
        if (sliceDefine.getName() == null) {
            throw new BuildException("The name attribute must be supplied in a <define> element");
        }
        this._defines.add(sliceDefine);
    }

    public void addConfiguredMeta(SliceMeta sliceMeta) {
        if (sliceMeta.getValue().length() > 0) {
            this._meta.add(sliceMeta);
        }
    }

    protected HashMap<String, SliceDependency> readDependencies() {
        if (this._dependencyFile == null) {
            this._dependencyFile = this._outputDir != null ? new File(this._outputDir, ".depend") : new File(".depend");
        }
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this._dependencyFile));
            HashMap hashMap = (HashMap)objectInputStream.readObject();
            objectInputStream.close();
            return hashMap;
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new HashMap<String, SliceDependency>();
    }

    protected void writeDependencies(HashMap<String, SliceDependency> hashMap) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this._dependencyFile));
            objectOutputStream.writeObject(hashMap);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            throw new BuildException("Unable to write dependencies in file " + this._dependencyFile.getPath() + ": " + iOException);
        }
    }

    protected List<SliceDependency> parseDependencies(String string) {
        LinkedList<SliceDependency> linkedList = new LinkedList<SliceDependency>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            StringBuilder stringBuilder = new StringBuilder(1024);
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                if (string2.length() == 0) continue;
                if (string2.endsWith("\\")) {
                    stringBuilder.append(string2.substring(0, string2.length() - 1));
                    continue;
                }
                stringBuilder.append(string2);
                char[] cArray = stringBuilder.toString().toCharArray();
                for (n = 0; n < cArray.length; ++n) {
                    if (cArray[n] != '\\' || n + 1 >= cArray.length || cArray[n + 1] == ' ' || cArray[n + 1] == ':' || cArray[n + 1] == '\r' || cArray[n + 1] == '\n') continue;
                    cArray[n] = 47;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                StringBuilder stringBuilder2 = new StringBuilder(128);
                for (n = 0; n < cArray.length; ++n) {
                    if (cArray[n] == '\\') {
                        if (n + 1 >= cArray.length) {
                            throw new BuildException("dependency parse failure");
                        }
                        stringBuilder2.append(cArray[++n]);
                        continue;
                    }
                    if (Character.isWhitespace(cArray[n])) {
                        if (stringBuilder2.length() <= 0) continue;
                        arrayList.add(stringBuilder2.toString());
                        stringBuilder2 = new StringBuilder(128);
                        continue;
                    }
                    stringBuilder2.append(cArray[n]);
                }
                if (stringBuilder2.length() > 0) {
                    arrayList.add(stringBuilder2.toString());
                }
                SliceDependency sliceDependency = new SliceDependency();
                sliceDependency._dependencies = new String[arrayList.size()];
                arrayList.toArray(sliceDependency._dependencies);
                sliceDependency._timeStamp = new Date().getTime();
                n = sliceDependency._dependencies[0].lastIndexOf(58);
                if (n != sliceDependency._dependencies[0].length() - 1) {
                    throw new BuildException("dependency parse failure");
                }
                sliceDependency._dependencies[0] = sliceDependency._dependencies[0].substring(0, n);
                for (int i = 0; i < sliceDependency._dependencies.length; ++i) {
                    sliceDependency._dependencies[i] = new File(sliceDependency._dependencies[i]).toString();
                }
                linkedList.add(sliceDependency);
                stringBuilder = new StringBuilder(1024);
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Unable to read dependencies from slice translator: " + iOException);
        }
        return linkedList;
    }

    protected String getDefaultTranslator(String string) {
        String string2 = this.getIceHome();
        if (string2 != null) {
            return new File(string2 + File.separator + "bin" + File.separator + string).toString();
        }
        return string;
    }

    protected void addLdLibraryPath(ExecTask execTask) {
        String string = this.getIceHome();
        boolean bl = this.getProject().getProperties().containsKey("ice.src.dist");
        if (string != null) {
            Environment.Variable variable;
            String string2;
            String string3 = null;
            String string4 = null;
            String string5 = new File(string + File.separator + "lib").toString();
            String string6 = null;
            String string7 = System.getProperty("os.name");
            if (string7.equals("Mac OS X")) {
                string3 = "DYLD_LIBRARY_PATH";
            } else if (string7.equals("AIX")) {
                string3 = "LIBPATH";
            } else if (string7.equals("HP-UX")) {
                string3 = "SHLIB_PATH";
                string4 = "LD_LIBRARY_PATH";
                string6 = bl ? string5 : new File(string + File.separator + "lib" + File.separator + "pa20_64").toString();
            } else if (!string7.startsWith("Windows")) {
                if (string7.equals("SunOS")) {
                    string3 = "LD_LIBRARY_PATH";
                    string4 = "LD_LIBRARY_PATH_64";
                    string2 = System.getProperty("os.arch");
                    string6 = bl ? string5 : (string2.equals("x86") ? new File(string + File.separator + "lib" + File.separator + "amd64").toString() : new File(string + File.separator + "lib" + File.separator + "sparcv9").toString());
                } else {
                    string3 = "LD_LIBRARY_PATH";
                    string4 = "LD_LIBRARY_PATH";
                    string6 = bl ? string5 : new File(string + File.separator + "lib64").toString();
                }
            }
            if (string3 != null) {
                if (string3.equals(string4)) {
                    string5 = string5 + File.pathSeparator + string6;
                }
                if ((string2 = this.getEnvironment(string3)) != null) {
                    string5 = string5 + File.pathSeparator + string2;
                }
                variable = new Environment.Variable();
                variable.setKey(string3);
                variable.setValue(string5);
                execTask.addEnv(variable);
            }
            if (string4 != null && !string4.equals(string3)) {
                string2 = this.getEnvironment(string4);
                if (string2 != null) {
                    string6 = string6 + File.pathSeparator + string2;
                }
                variable = new Environment.Variable();
                variable.setKey(string4);
                variable.setValue(string6);
                execTask.addEnv(variable);
            }
        }
    }

    protected String getIceHome() {
        if (this._iceHome == null) {
            this._iceHome = this.getProject().getProperties().containsKey("ice.home") ? (String)this.getProject().getProperties().get("ice.home") : this.getEnvironment("ICE_HOME");
        }
        return this._iceHome;
    }

    private String getEnvironment(String string) {
        Vector vector = Execute.getProcEnvironment();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string + "=")) continue;
            return string2.substring(string2.indexOf(61) + 1);
        }
        return null;
    }

    protected class SliceDependency
    implements Serializable {
        public String[] _dependencies;
        public long _timeStamp;

        protected SliceDependency() {
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this._dependencies);
            objectOutputStream.writeLong(this._timeStamp);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this._dependencies = (String[])objectInputStream.readObject();
            this._timeStamp = objectInputStream.readLong();
        }

        public boolean isUpToDate() {
            for (String string : this._dependencies) {
                File file = new File(string);
                if (file.exists() && this._timeStamp >= file.lastModified()) continue;
                return false;
            }
            return true;
        }
    }
}

