/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLJavaMappingRegistry {
    private Hashtable sReg = new Hashtable();
    private Hashtable dsReg = new Hashtable();
    private Hashtable xml2JavaReg = new Hashtable();
    private Hashtable java2XMLReg = new Hashtable();
    private String defaultEncodingStyle = null;

    private static String getClassName(Class clazz) {
        return clazz != null ? StringUtils.getClassName(clazz) : "null";
    }

    private static String getKey(Object object, String string) {
        return String.valueOf(String.valueOf(object)) + " + " + string;
    }

    public void mapTypes(String string, QName qName, Class clazz, Serializer serializer, Deserializer deserializer) {
        String string2 = XMLJavaMappingRegistry.getKey(clazz, string);
        String string3 = XMLJavaMappingRegistry.getKey(qName, string);
        if (serializer != null) {
            this.sReg.put(string2, serializer);
        }
        if (deserializer != null) {
            this.dsReg.put(string3, deserializer);
        }
        if (qName != null && clazz != null) {
            this.java2XMLReg.put(string2, qName);
            this.xml2JavaReg.put(string3, clazz);
        }
    }

    public void marshall(String string, Class clazz, Object object, Object object2, Writer writer, NSStack nSStack, SOAPContext sOAPContext) throws IllegalArgumentException, IOException {
        Serializer serializer = this.querySerializer(clazz, string);
        serializer.marshall(string, clazz, object, object2, writer, nSStack, this, sOAPContext);
    }

    public Deserializer queryDeserializer(QName qName, String string) throws IllegalArgumentException {
        String string2;
        Deserializer deserializer;
        if (string == null) {
            string = this.defaultEncodingStyle;
        }
        if ((deserializer = (Deserializer)this.dsReg.get(string2 = XMLJavaMappingRegistry.getKey(qName, string))) != null) {
            return deserializer;
        }
        string2 = XMLJavaMappingRegistry.getKey(null, string);
        deserializer = (Deserializer)this.dsReg.get(string2);
        if (deserializer != null) {
            return deserializer;
        }
        throw new IllegalArgumentException("No Deserializer found to deserialize a '" + qName + "' using encoding style '" + string + "'.");
    }

    public QName queryElementType(Class clazz, String string) throws IllegalArgumentException {
        String string2;
        QName qName;
        if (string == null) {
            string = this.defaultEncodingStyle;
        }
        if ((qName = (QName)this.java2XMLReg.get(string2 = XMLJavaMappingRegistry.getKey(clazz, string))) != null) {
            return qName;
        }
        throw new IllegalArgumentException("No mapping found for '" + XMLJavaMappingRegistry.getClassName(clazz) + "' using encoding style '" + string + "'.");
    }

    public Class queryJavaType(QName qName, String string) throws IllegalArgumentException {
        String string2;
        Class clazz;
        if (string == null) {
            string = this.defaultEncodingStyle;
        }
        if ((clazz = (Class)this.xml2JavaReg.get(string2 = XMLJavaMappingRegistry.getKey(qName, string))) != null) {
            return clazz;
        }
        throw new IllegalArgumentException("No mapping found for '" + qName + "' using encoding style '" + string + "'.");
    }

    public Serializer querySerializer(Class clazz, String string) throws IllegalArgumentException {
        String string2;
        Serializer serializer;
        if (string == null) {
            string = this.defaultEncodingStyle;
        }
        if ((serializer = (Serializer)this.sReg.get(string2 = XMLJavaMappingRegistry.getKey(clazz, string))) != null) {
            return serializer;
        }
        string2 = XMLJavaMappingRegistry.getKey(null, string);
        serializer = (Serializer)this.sReg.get(string2);
        if (serializer != null) {
            return serializer;
        }
        throw new IllegalArgumentException("No Serializer found to serialize a '" + XMLJavaMappingRegistry.getClassName(clazz) + "' using encoding style '" + string + "'.");
    }

    public void setDefaultEncodingStyle(String string) {
        this.defaultEncodingStyle = string;
    }

    public Bean unmarshall(String string, QName qName, Node node, SOAPContext sOAPContext) throws IllegalArgumentException {
        Deserializer deserializer = null;
        try {
            deserializer = this.queryDeserializer(qName, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string2 = ((Element)node).getAttribute("href");
            if (string2 != null && !string2.equals("")) {
                deserializer = SOAPMappingRegistry.partSer;
            }
            throw illegalArgumentException;
        }
        return deserializer.unmarshall(string, qName, node, this, sOAPContext);
    }
}

