/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.db.DatabaseEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayBinding
implements EntryBinding<byte[]> {
    private static byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];

    @Override
    public byte[] entryToObject(DatabaseEntry entry) {
        int len = entry.getSize();
        if (len == 0) {
            return ZERO_LENGTH_BYTE_ARRAY;
        }
        byte[] bytes = new byte[len];
        System.arraycopy(entry.getData(), entry.getOffset(), bytes, 0, bytes.length);
        return bytes;
    }

    @Override
    public void objectToEntry(byte[] object, DatabaseEntry entry) {
        entry.setData(object, 0, object.length);
    }
}

