/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigIntegerBinding
extends TupleBinding<BigInteger> {
    @Override
    public BigInteger entryToObject(TupleInput input) {
        return input.readBigInteger();
    }

    @Override
    public void objectToEntry(BigInteger object, TupleOutput output) {
        output.writeBigInteger(object);
    }

    @Override
    protected TupleOutput getTupleOutput(BigInteger object) {
        return BigIntegerBinding.sizedOutput(object);
    }

    public static BigInteger entryToBigInteger(DatabaseEntry entry) {
        return BigIntegerBinding.entryToInput(entry).readBigInteger();
    }

    public static void bigIntegerToEntry(BigInteger val, DatabaseEntry entry) {
        BigIntegerBinding.outputToEntry(BigIntegerBinding.sizedOutput(val).writeBigInteger(val), entry);
    }

    private static TupleOutput sizedOutput(BigInteger val) {
        int len = TupleOutput.getBigIntegerByteLength(val);
        return new TupleOutput(new byte[len]);
    }
}

