/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.util.UtfOps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringBinding
extends TupleBinding<String> {
    @Override
    public String entryToObject(TupleInput input) {
        return input.readString();
    }

    @Override
    public void objectToEntry(String object, TupleOutput output) {
        output.writeString(object);
    }

    @Override
    protected TupleOutput getTupleOutput(String object) {
        return StringBinding.sizedOutput(object);
    }

    public static String entryToString(DatabaseEntry entry) {
        return StringBinding.entryToInput(entry).readString();
    }

    public static void stringToEntry(String val, DatabaseEntry entry) {
        StringBinding.outputToEntry(StringBinding.sizedOutput(val).writeString(val), entry);
    }

    private static TupleOutput sizedOutput(String val) {
        int stringLength = val == null ? 1 : UtfOps.getByteLength(val.toCharArray());
        return new TupleOutput(new byte[++stringLength]);
    }
}

