/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleBase<E> {
    private int outputBufferSize = 0;

    public void setTupleBufferSize(int byteSize) {
        this.outputBufferSize = byteSize;
    }

    public int getTupleBufferSize() {
        return this.outputBufferSize;
    }

    protected TupleOutput getTupleOutput(E object) {
        int byteSize = this.getTupleBufferSize();
        if (byteSize != 0) {
            return new TupleOutput(new byte[byteSize]);
        }
        return new TupleOutput();
    }

    public static void outputToEntry(TupleOutput output, DatabaseEntry entry) {
        entry.setData(output.getBufferBytes(), output.getBufferOffset(), output.getBufferLength());
    }

    public static void inputToEntry(TupleInput input, DatabaseEntry entry) {
        entry.setData(input.getBufferBytes(), input.getBufferOffset(), input.getBufferLength());
    }

    public static TupleInput entryToInput(DatabaseEntry entry) {
        return new TupleInput(entry.getData(), entry.getOffset(), entry.getSize());
    }

    public static TupleOutput newOutput() {
        return new TupleOutput();
    }

    public static TupleOutput newOutput(byte[] buffer) {
        return new TupleOutput(buffer);
    }
}

