/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.BlockIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.JoinConfig;
import com.sleepycat.db.OperationStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StoredCollection<E>
extends StoredContainer
implements Collection<E> {
    public static final int DEFAULT_ITERATOR_BLOCK_SIZE = 10;
    private int iteratorBlockSize = 10;

    StoredCollection(DataView view) {
        super(view);
    }

    public int getIteratorBlockSize() {
        return this.iteratorBlockSize;
    }

    public void setIteratorBlockSize(int blockSize) {
        if (blockSize < 2) {
            throw new IllegalArgumentException("blockSize is less than two: " + blockSize);
        }
        this.iteratorBlockSize = blockSize;
    }

    final boolean add(Object key, Object value) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            OperationStatus status = cursor.putNoDupData(key, value, null, false);
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return status == OperationStatus.SUCCESS;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    BlockIterator blockIterator() {
        return new BlockIterator(this, this.isWriteAllowed(), this.iteratorBlockSize);
    }

    @Override
    public Iterator<E> iterator() {
        return this.blockIterator();
    }

    public StoredIterator<E> storedIterator() {
        return this.storedIterator(this.isWriteAllowed());
    }

    public StoredIterator<E> storedIterator(boolean writeAllowed) {
        try {
            return new StoredIterator(this, writeAllowed && this.isWriteAllowed(), null);
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public StoredIterator<E> iterator(boolean writeAllowed) {
        return this.storedIterator(writeAllowed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ArrayList<E> list = new ArrayList<E>();
        StoredIterator<E> i = this.storedIterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
        }
        finally {
            i.close();
        }
        return list.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        int j = 0;
        StoredIterator<E> i = this.storedIterator();
        try {
            while (j < a.length && i.hasNext()) {
                a[j++] = i.next();
            }
            if (j < a.length) {
                a[j] = null;
            } else if (i.hasNext()) {
                ArrayList<T> list = new ArrayList<T>(Arrays.asList(a));
                while (i.hasNext()) {
                    list.add(i.next());
                }
                a = list.toArray(a);
            }
        }
        finally {
            i.close();
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> coll) {
        Iterator i = this.storedOrExternalIterator(coll);
        try {
            while (i.hasNext()) {
                if (this.contains(i.next())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            StoredIterator.close(i);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        Iterator i = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            i = this.storedOrExternalIterator(coll);
            boolean changed = false;
            while (i.hasNext()) {
                if (!this.add(i.next())) continue;
                changed = true;
            }
            StoredIterator.close(i);
            this.commitAutoCommit(doAutoCommit);
            return changed;
        }
        catch (Exception e) {
            StoredIterator.close(i);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return this.removeAll(coll, true);
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        return this.removeAll(coll, false);
    }

    private boolean removeAll(Collection<?> coll, boolean ifExistsInColl) {
        StoredIterator<E> i = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            boolean changed = false;
            i = this.storedIterator();
            while (i.hasNext()) {
                if (ifExistsInColl != coll.contains(i.next())) continue;
                i.remove();
                changed = true;
            }
            i.close();
            this.commitAutoCommit(doAutoCommit);
            return changed;
        }
        catch (Exception e) {
            if (i != null) {
                i.close();
            }
            throw this.handleException(e, doAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object other) {
        if (other instanceof Collection) {
            Collection otherColl = StoredCollection.copyCollection(other);
            StoredIterator<E> i = this.storedIterator();
            try {
                while (i.hasNext()) {
                    if (otherColl.remove(i.next())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = otherColl.isEmpty();
                return bl;
            }
            finally {
                i.close();
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> toList() {
        ArrayList<E> list = new ArrayList<E>();
        StoredIterator<E> i = this.storedIterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
            ArrayList<E> arrayList = list;
            return arrayList;
        }
        finally {
            i.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        StoredIterator<E> i = this.storedIterator();
        try {
            while (i.hasNext()) {
                if (buf.length() > 1) {
                    buf.append(',');
                }
                buf.append(i.next().toString());
            }
            buf.append(']');
            String string = buf.toString();
            return string;
        }
        finally {
            i.close();
        }
    }

    @Override
    public int size() {
        boolean countDups = this.iterateDuplicates();
        int count = 0;
        CursorConfig cursorConfig = this.view.currentTxn.isLockingMode() ? CursorConfig.READ_UNCOMMITTED : null;
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false, cursorConfig);
            OperationStatus status = cursor.getFirst(false);
            while (status == OperationStatus.SUCCESS) {
                count = countDups ? (count += cursor.count()) : ++count;
                status = cursor.getNextNoDup(false);
            }
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return count;
    }

    public StoredIterator<E> join(StoredContainer[] indices, Object[] indexKeys, JoinConfig joinConfig) {
        try {
            DataView[] indexViews = new DataView[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                indexViews[i] = indices[i].view;
            }
            DataCursor cursor = this.view.join(indexViews, indexKeys, joinConfig);
            return new StoredIterator(this, false, cursor);
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    final E getFirstOrLast(boolean doGetFirst) {
        E e;
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            OperationStatus status = doGetFirst ? cursor.getFirst(false) : cursor.getLast(false);
            e = status == OperationStatus.SUCCESS ? (E)this.makeIteratorData(null, cursor) : null;
        }
        catch (Exception e2) {
            try {
                throw StoredContainer.convertException(e2);
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return e;
    }

    E makeIteratorData(BaseIterator iterator, DataCursor cursor) {
        return this.makeIteratorData(iterator, cursor.getKeyThang(), cursor.getPrimaryKeyThang(), cursor.getValueThang());
    }

    abstract E makeIteratorData(BaseIterator var1, DatabaseEntry var2, DatabaseEntry var3, DatabaseEntry var4);

    abstract boolean hasValues();

    boolean iterateDuplicates() {
        return true;
    }

    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (!this.areDuplicatesAllowed()) {
            throw new UnsupportedOperationException("duplicates required");
        }
    }

    int getIndexOffset() {
        return 0;
    }

    private static Collection copyCollection(Object other) {
        if (other instanceof StoredCollection) {
            return ((StoredCollection)other).toList();
        }
        return new ArrayList((Collection)other);
    }
}

