/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.OperationStatus;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredValueSet<E>
extends StoredCollection<E>
implements Set<E> {
    public StoredValueSet(Database database, EntryBinding<E> valueBinding, boolean writeAllowed) {
        super(new DataView(database, null, valueBinding, null, writeAllowed, null));
    }

    public StoredValueSet(Database database, EntityBinding<E> valueEntityBinding, boolean writeAllowed) {
        super(new DataView(database, null, null, valueEntityBinding, writeAllowed, null));
    }

    StoredValueSet(DataView valueSetView) {
        super(valueSetView);
    }

    @Override
    public boolean add(E entity) {
        if (this.view.isSecondary()) {
            throw new UnsupportedOperationException("add() not allowed with index");
        }
        if (this.view.range.isSingleKey()) {
            if (!this.view.dupsAllowed) {
                throw new UnsupportedOperationException("duplicates required");
            }
            DataCursor cursor = null;
            boolean doAutoCommit = this.beginAutoCommit();
            try {
                cursor = new DataCursor(this.view, true);
                cursor.useRangeKey();
                OperationStatus status = cursor.putNoDupData(null, entity, null, true);
                this.closeCursor(cursor);
                this.commitAutoCommit(doAutoCommit);
                return status == OperationStatus.SUCCESS;
            }
            catch (Exception e) {
                this.closeCursor(cursor);
                throw this.handleException(e, doAutoCommit);
            }
        }
        if (this.view.entityBinding == null) {
            throw new UnsupportedOperationException("add() requires entity binding");
        }
        return this.add(null, entity);
    }

    @Override
    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public boolean remove(Object value) {
        return this.removeValue(value);
    }

    @Override
    E makeIteratorData(BaseIterator iterator, DatabaseEntry keyEntry, DatabaseEntry priKeyEntry, DatabaseEntry valueEntry) {
        return (E)this.view.makeValue(priKeyEntry, valueEntry);
    }

    @Override
    boolean hasValues() {
        return true;
    }
}

