/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.db.internal.Dbc;

public class CursorConfig
implements Cloneable {
    public static final CursorConfig DEFAULT = new CursorConfig();
    public static final CursorConfig BULK_CURSOR = new CursorConfig();
    public static final CursorConfig READ_COMMITTED;
    public static final CursorConfig READ_UNCOMMITTED;
    public static final CursorConfig SNAPSHOT;
    public static final CursorConfig WRITECURSOR;
    public static final CursorConfig DIRTY_READ;
    public static final CursorConfig DEGREE_2;
    private boolean bulkCursor = false;
    private boolean readCommitted = false;
    private boolean readUncommitted = false;
    private boolean snapshot = false;
    private boolean writeCursor = false;

    static CursorConfig checkNull(CursorConfig config) {
        return config == null ? DEFAULT : config;
    }

    public void setBulkCursor(boolean bulkCursor) {
        this.bulkCursor = bulkCursor;
    }

    public boolean getBulkCursor() {
        return this.bulkCursor;
    }

    public void setReadCommitted(boolean readCommitted) {
        this.readCommitted = readCommitted;
    }

    public boolean getReadCommitted() {
        return this.readCommitted;
    }

    public void setDegree2(boolean degree2) {
        this.setReadCommitted(degree2);
    }

    public boolean getDegree2() {
        return this.getReadCommitted();
    }

    public void setReadUncommitted(boolean readUncommitted) {
        this.readUncommitted = readUncommitted;
    }

    public boolean getReadUncommitted() {
        return this.readUncommitted;
    }

    public void setDirtyRead(boolean dirtyRead) {
        this.setReadUncommitted(dirtyRead);
    }

    public boolean getDirtyRead() {
        return this.getReadUncommitted();
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    public boolean getSnapshot() {
        return this.snapshot;
    }

    public void setWriteCursor(boolean writeCursor) {
        this.writeCursor = writeCursor;
    }

    public boolean getWriteCursor() {
        return this.writeCursor;
    }

    Dbc openCursor(Db db, DbTxn txn) throws DatabaseException {
        int flags = 0;
        flags |= this.bulkCursor ? 1 : 0;
        flags |= this.readCommitted ? 1024 : 0;
        flags |= this.readUncommitted ? 512 : 0;
        flags |= this.snapshot ? 2 : 0;
        return db.cursor(txn, flags |= this.writeCursor ? 8 : 0);
    }

    static {
        BULK_CURSOR.setBulkCursor(true);
        READ_COMMITTED = new CursorConfig();
        READ_COMMITTED.setReadCommitted(true);
        READ_UNCOMMITTED = new CursorConfig();
        READ_UNCOMMITTED.setReadUncommitted(true);
        SNAPSHOT = new CursorConfig();
        SNAPSHOT.setSnapshot(true);
        WRITECURSOR = new CursorConfig();
        WRITECURSOR.setWriteCursor(true);
        DIRTY_READ = READ_UNCOMMITTED;
        DEGREE_2 = READ_COMMITTED;
    }
}

