/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.Lock;
import com.sleepycat.db.LockOperation;
import com.sleepycat.db.LockRequestMode;
import com.sleepycat.db.internal.DbLock;

public class LockRequest {
    private DbLock lock;
    private LockRequestMode mode;
    private int modeFlag;
    private DatabaseEntry obj;
    private int op;
    private int timeout;

    public LockRequest(LockOperation op, LockRequestMode mode, DatabaseEntry obj) {
        this(op, mode, obj, null, 0);
    }

    public LockRequest(LockOperation op, LockRequestMode mode, DatabaseEntry obj, Lock lock) {
        this(op, mode, obj, lock, 0);
    }

    public LockRequest(LockOperation op, LockRequestMode mode, DatabaseEntry obj, Lock lock, int timeout) {
        this.setOp(op);
        this.setMode(mode);
        this.setObj(obj);
        this.setLock(lock);
        this.setTimeout(timeout);
    }

    public void setLock(Lock lock) {
        this.lock = lock == null ? null : lock.unwrap();
    }

    public void setMode(LockRequestMode mode) {
        this.mode = mode;
        this.modeFlag = mode.getFlag();
    }

    public void setObj(DatabaseEntry obj) {
        this.obj = obj;
    }

    public void setOp(LockOperation op) {
        this.op = op.getFlag();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Lock getLock() {
        if (this.lock != null && this.lock.wrapper != null) {
            return this.lock.wrapper;
        }
        return Lock.wrap(this.lock);
    }

    public LockRequestMode getMode() {
        return this.mode;
    }

    public DatabaseEntry getObj() {
        return this.obj;
    }

    public LockOperation getOp() {
        return LockOperation.fromFlag(this.op);
    }

    public int getTimeout() {
        return this.timeout;
    }
}

