/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.DbUtil;
import java.nio.ByteBuffer;

public abstract class MultipleEntry
extends DatabaseEntry {
    int pos;

    MultipleEntry(byte[] data, int offset, int size) {
        super(data, offset, size);
        this.setUserBuffer(data != null ? data.length - offset : 0, true);
        this.flags |= 2;
    }

    MultipleEntry(ByteBuffer data) {
        super(data);
        this.flags |= 2;
    }

    public void setUserBuffer(int length, boolean usermem) {
        if (!usermem) {
            throw new IllegalArgumentException("User buffer required");
        }
        super.setUserBuffer(length, usermem);
    }

    protected boolean append_internal(byte[] newdata, int offset, int len, int recno) throws DatabaseException {
        int curr_off;
        if (this.pos == 0) {
            this.pos = this.ulen;
            curr_off = 0;
        } else {
            curr_off = DbUtil.array2int(this.data, this.pos + 4);
            curr_off += DbUtil.array2int(this.data, this.pos);
        }
        if (curr_off + len > this.pos - 8 - (recno > 0 ? 4 : 0)) {
            return false;
        }
        if (recno > 0) {
            this.pos -= 4;
            DbUtil.int2array(curr_off, this.data, this.pos);
        }
        this.pos -= 4;
        DbUtil.int2array(curr_off, this.data, this.pos);
        this.pos -= 4;
        DbUtil.int2array(len, this.data, this.pos);
        DbUtil.int2array(recno > 0 ? 0 : -1, this.data, this.pos - 4);
        for (int i = 0; i < len; ++i) {
            this.data[curr_off + i] = newdata[i + offset];
        }
        return true;
    }

    protected boolean append_internal(byte[] newdata, int offset, int len) throws DatabaseException {
        return this.append_internal(newdata, offset, len, 0);
    }
}

