/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.MultipleEntry;
import com.sleepycat.db.internal.DbUtil;
import java.nio.ByteBuffer;

public class MultipleKeyNIODataEntry
extends MultipleEntry {
    public MultipleKeyNIODataEntry() {
        super((ByteBuffer)null);
    }

    public MultipleKeyNIODataEntry(ByteBuffer data) {
        super(data);
    }

    int getMultiFlag() {
        this.pos = 0;
        return 16384;
    }

    public boolean next(DatabaseEntry key, DatabaseEntry data) {
        if (this.pos == 0) {
            this.pos = this.ulen - 4;
        }
        if (this.data_nio.capacity() < 16) {
            return false;
        }
        byte[] intarr = new byte[16];
        int saveoffset = this.data_nio.position();
        this.data_nio.position(this.pos - 12);
        this.data_nio.get(intarr, 0, 16);
        this.data_nio.position(saveoffset);
        int keyoff = DbUtil.array2int(intarr, 12);
        if (keyoff < 0) {
            return false;
        }
        int keysz = DbUtil.array2int(intarr, 8);
        int dataoff = DbUtil.array2int(intarr, 4);
        int datasz = DbUtil.array2int(intarr, 0);
        this.pos -= 16;
        key.setDataNIO(this.data_nio);
        key.setOffset(keyoff);
        key.setSize(keysz);
        data.setDataNIO(this.data_nio);
        data.setOffset(dataoff);
        data.setSize(datasz);
        return true;
    }
}

