/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.MultipleEntry;
import com.sleepycat.db.internal.DbUtil;

public class MultipleRecnoDataEntry
extends MultipleEntry {
    public MultipleRecnoDataEntry() {
        super(null, 0, 0);
    }

    public MultipleRecnoDataEntry(byte[] data) {
        super(data, 0, data == null ? 0 : data.length);
    }

    public MultipleRecnoDataEntry(byte[] data, int offset, int size) {
        super(data, offset, size);
    }

    int getMultiFlag() {
        this.pos = 0;
        return 16384;
    }

    public boolean next(DatabaseEntry recnoEntry, DatabaseEntry data) {
        int recno;
        if (this.pos == 0) {
            this.pos = this.ulen - 4;
        }
        if ((recno = DbUtil.array2int(this.data, this.pos)) == 0) {
            return false;
        }
        this.pos -= 4;
        int dataoff = DbUtil.array2int(this.data, this.pos);
        this.pos -= 4;
        int datasz = DbUtil.array2int(this.data, this.pos);
        this.pos -= 4;
        recnoEntry.setRecordNumber(recno);
        data.setData(this.data);
        data.setOffset(dataoff);
        data.setSize(datasz);
        return true;
    }

    public boolean append(int recno, byte[] data, int offset, int len) throws DatabaseException {
        return this.append_internal(data, this.doff, this.dlen, recno);
    }

    public boolean append(int recno, DatabaseEntry data) throws DatabaseException {
        return this.append(recno, data.data, data.offset, data.size);
    }

    public boolean append(int recno, byte[] data) throws DatabaseException {
        return this.append(recno, data, 0, data.length);
    }
}

