/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.SecondaryCursor;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.internal.Db;
import java.io.FileNotFoundException;

public class SecondaryDatabase
extends Database {
    private final Database primaryDatabase;

    SecondaryDatabase(Db db, Database primaryDatabase) throws DatabaseException {
        super(db);
        this.primaryDatabase = primaryDatabase;
    }

    public SecondaryDatabase(String fileName, String databaseName, Database primaryDatabase, SecondaryConfig config) throws DatabaseException, FileNotFoundException {
        this(SecondaryConfig.checkNull(config).openSecondaryDatabase(null, null, fileName, databaseName, primaryDatabase.db), primaryDatabase);
    }

    public Cursor openCursor(Transaction txn, CursorConfig config) throws DatabaseException {
        return this.openSecondaryCursor(txn, config);
    }

    public SecondaryCursor openSecondaryCursor(Transaction txn, CursorConfig config) throws DatabaseException {
        return new SecondaryCursor(this, CursorConfig.checkNull(config).openCursor(this.db, txn == null ? null : txn.txn), config);
    }

    public Database getPrimaryDatabase() {
        return this.primaryDatabase;
    }

    public DatabaseConfig getConfig() throws DatabaseException {
        return this.getSecondaryConfig();
    }

    public SecondaryConfig getSecondaryConfig() throws DatabaseException {
        return new SecondaryConfig(this.db);
    }

    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.db.pget(txn == null ? null : txn.txn, key, pKey, data, LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.db.pget(txn == null ? null : txn.txn, key, pKey, data, 8 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getSearchRecordNumber(Transaction txn, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.db.pget(txn == null ? null : txn.txn, key, pKey, data, 0x1D | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }
}

