/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.Sequence;
import com.sleepycat.db.SequenceConfig;
import com.sleepycat.db.Transaction;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.StoreExistsException;
import com.sleepycat.persist.StoreNotFoundException;
import com.sleepycat.persist.evolve.EvolveConfig;
import com.sleepycat.persist.evolve.EvolveStats;
import com.sleepycat.persist.evolve.IncompatibleClassException;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.impl.Store;
import com.sleepycat.persist.model.EntityModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityStore {
    private Store store;

    public EntityStore(Environment env, String storeName, StoreConfig config) throws StoreExistsException, StoreNotFoundException, IncompatibleClassException, DatabaseException {
        this.store = new Store(env, storeName, config, false);
    }

    public Environment getEnvironment() {
        return this.store.getEnvironment();
    }

    public StoreConfig getConfig() {
        return this.store.getConfig();
    }

    public String getStoreName() {
        return this.store.getStoreName();
    }

    public EntityModel getModel() {
        return this.store.getModel();
    }

    public Mutations getMutations() {
        return this.store.getMutations();
    }

    public <PK, E> PrimaryIndex<PK, E> getPrimaryIndex(Class<PK> primaryKeyClass, Class<E> entityClass) throws DatabaseException {
        return this.store.getPrimaryIndex(primaryKeyClass, primaryKeyClass.getName(), entityClass, entityClass.getName());
    }

    public <SK, PK, E> SecondaryIndex<SK, PK, E> getSecondaryIndex(PrimaryIndex<PK, E> primaryIndex, Class<SK> keyClass, String keyName) throws DatabaseException {
        return this.store.getSecondaryIndex(primaryIndex, primaryIndex.getEntityClass(), primaryIndex.getEntityClass().getName(), keyClass, keyClass.getName(), keyName);
    }

    public <SK, PK, E1, E2 extends E1> SecondaryIndex<SK, PK, E2> getSubclassIndex(PrimaryIndex<PK, E1> primaryIndex, Class<E2> entitySubclass, Class<SK> keyClass, String keyName) throws DatabaseException {
        this.getModel().getClassMetadata(entitySubclass.getName());
        return this.store.getSecondaryIndex(primaryIndex, entitySubclass, primaryIndex.getEntityClass().getName(), keyClass, keyClass.getName(), keyName);
    }

    public EvolveStats evolve(EvolveConfig config) throws DatabaseException {
        return this.store.evolve(config);
    }

    public void truncateClass(Class entityClass) throws DatabaseException {
        this.store.truncateClass(null, entityClass);
    }

    public void truncateClass(Transaction txn, Class entityClass) throws DatabaseException {
        this.store.truncateClass(txn, entityClass);
    }

    public void closeClass(Class entityClass) throws DatabaseException {
        this.store.closeClass(entityClass);
    }

    public void close() throws DatabaseException {
        this.store.close();
    }

    public Sequence getSequence(String name) throws DatabaseException {
        return this.store.getSequence(name);
    }

    public SequenceConfig getSequenceConfig(String name) {
        return this.store.getSequenceConfig(name);
    }

    public void setSequenceConfig(String name, SequenceConfig config) {
        this.store.setSequenceConfig(name, config);
    }

    public DatabaseConfig getPrimaryConfig(Class entityClass) {
        return this.store.getPrimaryConfig(entityClass);
    }

    public void setPrimaryConfig(Class entityClass, DatabaseConfig config) {
        this.store.setPrimaryConfig(entityClass, config);
    }

    public SecondaryConfig getSecondaryConfig(Class entityClass, String keyName) {
        return this.store.getSecondaryConfig(entityClass, keyName);
    }

    public void setSecondaryConfig(Class entityClass, String keyName, SecondaryConfig config) {
        this.store.setSecondaryConfig(entityClass, keyName, config);
    }
}

