/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Sequence;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyBinding;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;

public class PersistKeyAssigner {
    private Catalog catalog;
    private Format keyFieldFormat;
    private Format entityFormat;
    private boolean rawAccess;
    private Sequence sequence;

    PersistKeyAssigner(PersistKeyBinding keyBinding, PersistEntityBinding entityBinding, Sequence sequence) {
        this.catalog = keyBinding.catalog;
        this.keyFieldFormat = keyBinding.keyFormat.getSequenceKeyFormat();
        this.entityFormat = entityBinding.entityFormat;
        this.rawAccess = entityBinding.rawAccess;
        this.sequence = sequence;
    }

    public boolean assignPrimaryKey(Object entity, DatabaseEntry key) throws DatabaseException {
        if (this.entityFormat.isPriKeyNullOrZero(entity, this.rawAccess)) {
            Long value = this.sequence.get(null, 1);
            RecordOutput output = new RecordOutput(this.catalog, this.rawAccess);
            this.keyFieldFormat.writeObject(value, output, this.rawAccess);
            TupleBase.outputToEntry(output, key);
            RecordInput input = new RecordInput(this.catalog, this.rawAccess, null, 0, key.getData(), key.getOffset(), key.getSize());
            this.entityFormat.getReader().readPriKey(entity, input, this.rawAccess);
            return true;
        }
        return false;
    }
}

