/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;

public class PersistKeyBinding
implements EntryBinding {
    Catalog catalog;
    Format keyFormat;
    boolean rawAccess;

    public PersistKeyBinding(Catalog catalog, String clsName, boolean rawAccess) {
        this.catalog = catalog;
        this.keyFormat = PersistEntityBinding.getOrCreateFormat(catalog, clsName, rawAccess);
        if (!(this.keyFormat.isSimple() || this.keyFormat.isEnum() || this.keyFormat.getClassMetadata() != null && this.keyFormat.getClassMetadata().getCompositeKeyFields() != null)) {
            throw new IllegalArgumentException("Key class is not a simple type, an enum, or a composite key class (composite keys must include @KeyField annotations): " + clsName);
        }
        this.rawAccess = rawAccess;
    }

    PersistKeyBinding(Catalog catalog, Class cls, String[] compositeFieldOrder) {
        this.catalog = catalog;
        this.keyFormat = new CompositeKeyFormat(cls, compositeFieldOrder);
        this.keyFormat.initializeIfNeeded(catalog, null);
    }

    Object bytesToObject(byte[] bytes, int offset, int length) {
        return PersistKeyBinding.readKey(this.keyFormat, this.catalog, bytes, offset, length, this.rawAccess);
    }

    static Object readKey(Format keyFormat, Catalog catalog, byte[] bytes, int offset, int length, boolean rawAccess) {
        RecordInput input = new RecordInput(catalog, rawAccess, null, 0, bytes, offset, length);
        return input.readKeyObject(keyFormat);
    }

    public Object entryToObject(DatabaseEntry entry) {
        return this.bytesToObject(entry.getData(), entry.getOffset(), entry.getSize());
    }

    public void objectToEntry(Object object, DatabaseEntry entry) {
        RecordOutput output = new RecordOutput(this.catalog, this.rawAccess);
        output.writeKeyObject(object, this.keyFormat);
        TupleBase.outputToEntry(output, entry);
    }
}

