/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.model;

import com.sleepycat.asm.AnnotationVisitor;
import com.sleepycat.asm.Attribute;
import com.sleepycat.asm.ClassAdapter;
import com.sleepycat.asm.ClassVisitor;
import com.sleepycat.asm.FieldVisitor;
import com.sleepycat.asm.Label;
import com.sleepycat.asm.MethodVisitor;
import com.sleepycat.asm.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BytecodeEnhancer
extends ClassAdapter {
    private static final NotPersistentException NOT_PERSISTENT = new NotPersistentException();
    private static final Map<String, Integer> PRIMITIVE_WRAPPERS = new HashMap<String, Integer>();
    private String className;
    private String superclassName;
    private boolean isPersistent;
    private boolean isAbstract;
    private boolean hasDefaultConstructor;
    private boolean hasPersistentSuperclass;
    private boolean isCompositeKey;
    private FieldInfo priKeyField;
    private List<FieldInfo> secKeyFields = new ArrayList<FieldInfo>();
    private List<FieldInfo> nonKeyFields = new ArrayList<FieldInfo>();
    private String staticBlockMethod;

    BytecodeEnhancer(ClassVisitor parentVisitor) {
        super(parentVisitor);
    }

    @Override
    public void visit(int version, int access, String name, String sig, String superName, String[] interfaces) {
        this.className = name;
        this.superclassName = superName;
        String ENHANCED = "com/sleepycat/persist/impl/Enhanced";
        if (BytecodeEnhancer.containsString(interfaces, "com/sleepycat/persist/impl/Enhanced")) {
            throw this.abort();
        }
        interfaces = BytecodeEnhancer.appendString(interfaces, "com/sleepycat/persist/impl/Enhanced");
        this.isAbstract = (access & 0x400) != 0;
        this.hasPersistentSuperclass = superName != null && !superName.equals("java/lang/Object");
        super.visit(version, access, name, sig, superName, interfaces);
    }

    @Override
    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc.equals("Lcom/sleepycat/persist/model/Entity;") || desc.equals("Lcom/sleepycat/persist/model/Persistent;")) {
            this.isPersistent = true;
        }
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String sig, Object value) {
        if (!this.isPersistent) {
            throw this.abort();
        }
        FieldVisitor ret = super.visitField(access, name, desc, sig, value);
        if ((access & 8) == 0) {
            FieldInfo info = new FieldInfo(ret, name, desc, (access & 0x80) != 0);
            this.nonKeyFields.add(info);
            ret = info;
        }
        return ret;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] exceptions) {
        if (!this.isPersistent) {
            throw this.abort();
        }
        if ("<init>".equals(name) && "()V".equals(desc)) {
            this.hasDefaultConstructor = true;
        }
        if ("<clinit>".equals(name)) {
            if (this.staticBlockMethod != null) {
                throw new IllegalStateException();
            }
            this.staticBlockMethod = "bdbExistingStaticBlock";
            return this.cv.visitMethod(10, this.staticBlockMethod, "()V", null, null);
        }
        return super.visitMethod(access, name, desc, sig, exceptions);
    }

    @Override
    public void visitEnd() {
        if (!this.isPersistent || !this.hasDefaultConstructor) {
            throw this.abort();
        }
        this.sortFields();
        this.genBdbNewInstance();
        this.genBdbNewArray();
        this.genBdbIsPriKeyFieldNullOrZero();
        this.genBdbWritePriKeyField();
        this.genBdbReadPriKeyField();
        this.genBdbWriteSecKeyFields();
        this.genBdbReadSecKeyFields();
        this.genBdbWriteNonKeyFields();
        this.genBdbReadNonKeyFields();
        this.genBdbWriteCompositeKeyFields();
        this.genBdbReadCompositeKeyFields();
        this.genBdbGetField();
        this.genBdbSetField();
        this.genStaticBlock();
        super.visitEnd();
    }

    private void sortFields() {
        if (this.nonKeyFields.size() == 0) {
            return;
        }
        this.isCompositeKey = true;
        for (FieldInfo field : this.nonKeyFields) {
            if (field.order != null) continue;
            this.isCompositeKey = false;
        }
        if (this.isCompositeKey) {
            Collections.sort(this.nonKeyFields, new Comparator<FieldInfo>(){

                @Override
                public int compare(FieldInfo f1, FieldInfo f2) {
                    return f1.order.value - f2.order.value;
                }
            });
        } else {
            int i = 0;
            while (i < this.nonKeyFields.size()) {
                FieldInfo field;
                field = this.nonKeyFields.get(i);
                if (field.isTransient) {
                    this.nonKeyFields.remove(i);
                    continue;
                }
                if (field.isPriKey) {
                    if (this.priKeyField != null) continue;
                    this.priKeyField = field;
                    this.nonKeyFields.remove(i);
                    continue;
                }
                if (field.isSecKey) {
                    this.secKeyFields.add(field);
                    this.nonKeyFields.remove(i);
                    continue;
                }
                ++i;
            }
            Comparator<FieldInfo> cmp = new Comparator<FieldInfo>(){

                @Override
                public int compare(FieldInfo f1, FieldInfo f2) {
                    return f1.name.compareTo(f2.name);
                }
            };
            Collections.sort(this.secKeyFields, cmp);
            Collections.sort(this.nonKeyFields, cmp);
        }
    }

    private void genStaticBlock() {
        MethodVisitor mv = this.cv.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        if (this.staticBlockMethod != null) {
            mv.visitMethodInsn(184, this.className, this.staticBlockMethod, "()V");
        }
        mv.visitLdcInsn(this.className.replace('/', '.'));
        if (this.isAbstract) {
            mv.visitInsn(1);
        } else {
            mv.visitTypeInsn(187, this.className);
            mv.visitInsn(89);
            mv.visitMethodInsn(183, this.className, "<init>", "()V");
        }
        mv.visitMethodInsn(184, "com/sleepycat/persist/impl/EnhancedAccessor", "registerClass", "(Ljava/lang/String;Lcom/sleepycat/persist/impl/Enhanced;)V");
        mv.visitInsn(177);
        mv.visitMaxs(3, 0);
        mv.visitEnd();
    }

    private void genBdbNewInstance() {
        MethodVisitor mv = this.cv.visitMethod(1, "bdbNewInstance", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        if (this.isAbstract) {
            mv.visitInsn(1);
            mv.visitInsn(176);
            mv.visitMaxs(1, 1);
        } else {
            mv.visitTypeInsn(187, this.className);
            mv.visitInsn(89);
            mv.visitMethodInsn(183, this.className, "<init>", "()V");
            mv.visitInsn(176);
            mv.visitMaxs(2, 1);
        }
        mv.visitEnd();
    }

    private void genBdbNewArray() {
        MethodVisitor mv = this.cv.visitMethod(1, "bdbNewArray", "(I)Ljava/lang/Object;", null, null);
        mv.visitCode();
        if (this.isAbstract) {
            mv.visitInsn(1);
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
        } else {
            mv.visitVarInsn(21, 1);
            mv.visitTypeInsn(189, this.className);
            mv.visitInsn(176);
            mv.visitMaxs(1, 2);
            mv.visitEnd();
        }
    }

    private void genBdbIsPriKeyFieldNullOrZero() {
        MethodVisitor mv = this.cv.visitMethod(1, "bdbIsPriKeyFieldNullOrZero", "()Z", null, null);
        mv.visitCode();
        if (this.priKeyField != null) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.className, this.priKeyField.name, this.priKeyField.type.getDescriptor());
            Label l0 = new Label();
            if (BytecodeEnhancer.isRefType(this.priKeyField.type)) {
                mv.visitJumpInsn(199, l0);
            } else {
                BytecodeEnhancer.genBeforeCompareToZero(mv, this.priKeyField.type);
                mv.visitJumpInsn(154, l0);
            }
            mv.visitInsn(4);
            Label l1 = new Label();
            mv.visitJumpInsn(167, l1);
            mv.visitLabel(l0);
            mv.visitInsn(3);
            mv.visitLabel(l1);
        } else if (this.hasPersistentSuperclass) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, this.superclassName, "bdbIsPriKeyFieldNullOrZero", "()Z");
        } else {
            mv.visitInsn(3);
        }
        mv.visitInsn(172);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void genBdbWritePriKeyField() {
        MethodVisitor mv = this.cv.visitMethod(1, "bdbWritePriKeyField", "(Lcom/sleepycat/persist/impl/EntityOutput;Lcom/sleepycat/persist/impl/Format;)V", null, null);
        mv.visitCode();
        if (this.priKeyField != null) {
            if (!this.genWriteSimpleKeyField(mv, this.priKeyField)) {
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.className, this.priKeyField.name, this.priKeyField.type.getDescriptor());
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeKeyObject", "(Ljava/lang/Object;Lcom/sleepycat/persist/impl/Format;)V");
            }
        } else if (this.hasPersistentSuperclass) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(183, this.superclassName, "bdbWritePriKeyField", "(Lcom/sleepycat/persist/impl/EntityOutput;Lcom/sleepycat/persist/impl/Format;)V");
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
    }

    private void genBdbReadPriKeyField() {
        MethodVisitor mv = this.cv.visitMethod(1, "bdbReadPriKeyField", "(Lcom/sleepycat/persist/impl/EntityInput;Lcom/sleepycat/persist/impl/Format;)V", null, null);
        mv.visitCode();
        if (this.priKeyField != null) {
            if (!this.genReadSimpleKeyField(mv, this.priKeyField)) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readKeyObject", "(Lcom/sleepycat/persist/impl/Format;)Ljava/lang/Object;");
                mv.visitTypeInsn(192, BytecodeEnhancer.getTypeInstName(this.priKeyField.type));
                mv.visitFieldInsn(181, this.className, this.priKeyField.name, this.priKeyField.type.getDescriptor());
            }
        } else if (this.hasPersistentSuperclass) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(183, this.superclassName, "bdbReadPriKeyField", "(Lcom/sleepycat/persist/impl/EntityInput;Lcom/sleepycat/persist/impl/Format;)V");
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
    }

    private void genBdbWriteSecKeyFields() {
        MethodVisitor mv = this.cv.visitMethod(1, "bdbWriteSecKeyFields", "(Lcom/sleepycat/persist/impl/EntityOutput;)V", null, null);
        mv.visitCode();
        if (this.priKeyField != null && BytecodeEnhancer.isRefType(this.priKeyField.type)) {
            this.genRegisterPrimaryKey(mv, false);
        }
        if (this.hasPersistentSuperclass) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, this.superclassName, "bdbWriteSecKeyFields", "(Lcom/sleepycat/persist/impl/EntityOutput;)V");
        }
        for (FieldInfo field : this.secKeyFields) {
            this.genWriteField(mv, field);
        }
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private void genBdbReadSecKeyFields() {
        MethodVisitor mv = this.cv.visitMethod(1, "bdbReadSecKeyFields", "(Lcom/sleepycat/persist/impl/EntityInput;III)V", null, null);
        mv.visitCode();
        if (this.priKeyField != null && BytecodeEnhancer.isRefType(this.priKeyField.type)) {
            this.genRegisterPrimaryKey(mv, true);
        }
        this.genReadSuperKeyFields(mv, true);
        this.genReadFieldSwitch(mv, this.secKeyFields);
        mv.visitInsn(177);
        mv.visitMaxs(5, 5);
        mv.visitEnd();
    }

    private void genRegisterPrimaryKey(MethodVisitor mv, boolean input) {
        String entityInputOrOutputClass = input ? "com/sleepycat/persist/impl/EntityInput" : "com/sleepycat/persist/impl/EntityOutput";
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.className, this.priKeyField.name, this.priKeyField.type.getDescriptor());
        mv.visitMethodInsn(185, entityInputOrOutputClass, "registerPriKeyObject", "(Ljava/lang/Object;)V");
    }

    private void genBdbWriteNonKeyFields() {
        MethodVisitor mv = this.cv.visitMethod(1, "bdbWriteNonKeyFields", "(Lcom/sleepycat/persist/impl/EntityOutput;)V", null, null);
        mv.visitCode();
        if (!this.isCompositeKey) {
            if (this.hasPersistentSuperclass) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(183, this.superclassName, "bdbWriteNonKeyFields", "(Lcom/sleepycat/persist/impl/EntityOutput;)V");
            }
            for (FieldInfo field : this.nonKeyFields) {
                this.genWriteField(mv, field);
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private void genBdbReadNonKeyFields() {
        MethodVisitor mv = this.cv.visitMethod(1, "bdbReadNonKeyFields", "(Lcom/sleepycat/persist/impl/EntityInput;III)V", null, null);
        mv.visitCode();
        if (!this.isCompositeKey) {
            this.genReadSuperKeyFields(mv, false);
            this.genReadFieldSwitch(mv, this.nonKeyFields);
        }
        mv.visitInsn(177);
        mv.visitMaxs(5, 5);
        mv.visitEnd();
    }

    private void genBdbWriteCompositeKeyFields() {
        MethodVisitor mv = this.cv.visitMethod(1, "bdbWriteCompositeKeyFields", "(Lcom/sleepycat/persist/impl/EntityOutput;[Lcom/sleepycat/persist/impl/Format;)V", null, null);
        mv.visitCode();
        if (this.isCompositeKey) {
            for (int i = 0; i < this.nonKeyFields.size(); ++i) {
                FieldInfo field = this.nonKeyFields.get(i);
                if (this.genWriteSimpleKeyField(mv, field)) continue;
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.className, field.name, field.type.getDescriptor());
                mv.visitVarInsn(25, 2);
                if (i <= 127) {
                    mv.visitIntInsn(16, i);
                } else {
                    mv.visitLdcInsn(new Integer(i));
                }
                mv.visitInsn(50);
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeKeyObject", "(Ljava/lang/Object;Lcom/sleepycat/persist/impl/Format;)V");
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
    }

    private void genBdbReadCompositeKeyFields() {
        MethodVisitor mv = this.cv.visitMethod(1, "bdbReadCompositeKeyFields", "(Lcom/sleepycat/persist/impl/EntityInput;[Lcom/sleepycat/persist/impl/Format;)V", null, null);
        mv.visitCode();
        if (this.isCompositeKey) {
            for (int i = 0; i < this.nonKeyFields.size(); ++i) {
                FieldInfo field = this.nonKeyFields.get(i);
                if (this.genReadSimpleKeyField(mv, field)) continue;
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                if (i <= 127) {
                    mv.visitIntInsn(16, i);
                } else {
                    mv.visitLdcInsn(new Integer(i));
                }
                mv.visitInsn(50);
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readKeyObject", "(Lcom/sleepycat/persist/impl/Format;)Ljava/lang/Object;");
                mv.visitTypeInsn(192, BytecodeEnhancer.getTypeInstName(field.type));
                mv.visitFieldInsn(181, this.className, field.name, field.type.getDescriptor());
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(5, 5);
        mv.visitEnd();
    }

    private void genWriteField(MethodVisitor mv, FieldInfo field) {
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.className, field.name, field.type.getDescriptor());
        int sort = field.type.getSort();
        if (sort == 10 || sort == 9) {
            mv.visitInsn(1);
            mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeObject", "(Ljava/lang/Object;Lcom/sleepycat/persist/impl/Format;)V");
        } else {
            this.genWritePrimitive(mv, sort);
        }
    }

    private boolean genWriteSimpleKeyField(MethodVisitor mv, FieldInfo field) {
        if (this.genWritePrimitiveField(mv, field)) {
            return true;
        }
        String fieldClassName = field.type.getClassName();
        if (!BytecodeEnhancer.isSimpleRefType(fieldClassName)) {
            return false;
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.className, field.name, field.type.getDescriptor());
        Integer sort = PRIMITIVE_WRAPPERS.get(fieldClassName);
        if (sort != null) {
            this.genUnwrapPrimitive(mv, sort);
            this.genWritePrimitive(mv, sort);
        } else if (fieldClassName.equals(Date.class.getName())) {
            mv.visitMethodInsn(182, "java/util/Date", "getTime", "()J");
            this.genWritePrimitive(mv, 7);
        } else if (fieldClassName.equals(String.class.getName())) {
            mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeString", "(Ljava/lang/String;)Lcom/sleepycat/bind/tuple/TupleOutput;");
            mv.visitInsn(87);
        } else if (fieldClassName.equals(BigInteger.class.getName())) {
            mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeBigInteger", "(Ljava/math/BigInteger;)Lcom/sleepycat/bind/tuple/TupleOutput;");
            mv.visitInsn(87);
        } else {
            throw new IllegalStateException(fieldClassName);
        }
        return true;
    }

    private boolean genWritePrimitiveField(MethodVisitor mv, FieldInfo field) {
        int sort = field.type.getSort();
        if (sort == 10 || sort == 9) {
            return false;
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.className, field.name, field.type.getDescriptor());
        this.genWritePrimitive(mv, sort);
        return true;
    }

    private void genReadSuperKeyFields(MethodVisitor mv, boolean areSecKeyFields) {
        if (this.hasPersistentSuperclass) {
            Label next = new Label();
            mv.visitVarInsn(21, 4);
            mv.visitJumpInsn(153, next);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 2);
            mv.visitVarInsn(21, 3);
            mv.visitVarInsn(21, 4);
            mv.visitInsn(4);
            mv.visitInsn(100);
            String name = areSecKeyFields ? "bdbReadSecKeyFields" : "bdbReadNonKeyFields";
            mv.visitMethodInsn(183, this.superclassName, name, "(Lcom/sleepycat/persist/impl/EntityInput;III)V");
            mv.visitLabel(next);
        }
    }

    private void genReadFieldSwitch(MethodVisitor mv, List<FieldInfo> fields) {
        int nFields = fields.size();
        if (nFields > 0) {
            int i;
            mv.visitVarInsn(21, 4);
            Label pastSwitch = new Label();
            mv.visitJumpInsn(157, pastSwitch);
            Label[] labels = new Label[nFields];
            for (i = 0; i < nFields; ++i) {
                labels[i] = new Label();
            }
            mv.visitVarInsn(21, 2);
            mv.visitTableSwitchInsn(0, nFields - 1, pastSwitch, labels);
            for (i = 0; i < nFields; ++i) {
                FieldInfo field = fields.get(i);
                mv.visitLabel(labels[i]);
                this.genReadField(mv, field);
                if (i >= nFields - 1) continue;
                Label nextCase = labels[i + 1];
                mv.visitVarInsn(21, 3);
                if (i == 0) {
                    mv.visitJumpInsn(154, nextCase);
                } else {
                    switch (i) {
                        case 1: {
                            mv.visitInsn(4);
                            break;
                        }
                        case 2: {
                            mv.visitInsn(5);
                            break;
                        }
                        case 3: {
                            mv.visitInsn(6);
                            break;
                        }
                        case 4: {
                            mv.visitInsn(7);
                            break;
                        }
                        case 5: {
                            mv.visitInsn(8);
                            break;
                        }
                        default: {
                            mv.visitIntInsn(16, i);
                        }
                    }
                    mv.visitJumpInsn(160, nextCase);
                }
                mv.visitJumpInsn(167, pastSwitch);
            }
            mv.visitLabel(pastSwitch);
        }
    }

    private void genReadField(MethodVisitor mv, FieldInfo field) {
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        if (BytecodeEnhancer.isRefType(field.type)) {
            mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readObject", "()Ljava/lang/Object;");
            mv.visitTypeInsn(192, BytecodeEnhancer.getTypeInstName(field.type));
        } else {
            this.genReadPrimitive(mv, field.type.getSort());
        }
        mv.visitFieldInsn(181, this.className, field.name, field.type.getDescriptor());
    }

    private boolean genReadSimpleKeyField(MethodVisitor mv, FieldInfo field) {
        if (this.genReadPrimitiveField(mv, field)) {
            return true;
        }
        String fieldClassName = field.type.getClassName();
        if (!BytecodeEnhancer.isSimpleRefType(fieldClassName)) {
            return false;
        }
        Integer sort = PRIMITIVE_WRAPPERS.get(fieldClassName);
        if (sort != null) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            this.genReadPrimitive(mv, sort);
            this.genWrapPrimitive(mv, sort);
        } else if (fieldClassName.equals(Date.class.getName())) {
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(187, "java/util/Date");
            mv.visitInsn(89);
            mv.visitVarInsn(25, 1);
            this.genReadPrimitive(mv, 7);
            mv.visitMethodInsn(183, "java/util/Date", "<init>", "(J)V");
        } else if (fieldClassName.equals(String.class.getName())) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readString", "()Ljava/lang/String;");
        } else if (fieldClassName.equals(BigInteger.class.getName())) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readBigInteger", "()Ljava/math/BigInteger;");
        } else {
            throw new IllegalStateException(fieldClassName);
        }
        mv.visitFieldInsn(181, this.className, field.name, field.type.getDescriptor());
        return true;
    }

    private boolean genReadPrimitiveField(MethodVisitor mv, FieldInfo field) {
        int sort = field.type.getSort();
        if (sort == 10 || sort == 9) {
            return false;
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        this.genReadPrimitive(mv, sort);
        mv.visitFieldInsn(181, this.className, field.name, field.type.getDescriptor());
        return true;
    }

    private void genBdbGetField() {
        MethodVisitor mv = this.cv.visitMethod(1, "bdbGetField", "(Ljava/lang/Object;IIZ)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(21, 3);
        Label l0 = new Label();
        mv.visitJumpInsn(158, l0);
        Label l1 = new Label();
        if (this.hasPersistentSuperclass) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 2);
            mv.visitVarInsn(21, 3);
            mv.visitInsn(4);
            mv.visitInsn(100);
            mv.visitVarInsn(21, 4);
            mv.visitMethodInsn(183, this.className, "bdbGetField", "(Ljava/lang/Object;IIZ)Ljava/lang/Object;");
            mv.visitInsn(176);
        } else {
            mv.visitJumpInsn(167, l1);
        }
        mv.visitLabel(l0);
        mv.visitVarInsn(21, 4);
        Label l2 = new Label();
        mv.visitJumpInsn(153, l2);
        this.genGetFieldSwitch(mv, this.secKeyFields, l1);
        mv.visitLabel(l2);
        this.genGetFieldSwitch(mv, this.nonKeyFields, l1);
        mv.visitLabel(l1);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitMaxs(1, 5);
        mv.visitEnd();
    }

    private void genGetFieldSwitch(MethodVisitor mv, List<FieldInfo> fields, Label defaultLabel) {
        int i;
        int nFields = fields.size();
        if (nFields == 0) {
            mv.visitJumpInsn(167, defaultLabel);
            return;
        }
        Label[] labels = new Label[nFields];
        for (i = 0; i < nFields; ++i) {
            labels[i] = new Label();
        }
        mv.visitVarInsn(21, 2);
        mv.visitTableSwitchInsn(0, nFields - 1, defaultLabel, labels);
        for (i = 0; i < nFields; ++i) {
            FieldInfo field = fields.get(i);
            mv.visitLabel(labels[i]);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.className, field.name, field.type.getDescriptor());
            if (!BytecodeEnhancer.isRefType(field.type)) {
                this.genWrapPrimitive(mv, field.type.getSort());
            }
            mv.visitInsn(176);
        }
    }

    private void genBdbSetField() {
        MethodVisitor mv = this.cv.visitMethod(1, "bdbSetField", "(Ljava/lang/Object;IIZLjava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(21, 3);
        Label l0 = new Label();
        mv.visitJumpInsn(158, l0);
        if (this.hasPersistentSuperclass) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 2);
            mv.visitVarInsn(21, 3);
            mv.visitInsn(4);
            mv.visitInsn(100);
            mv.visitVarInsn(21, 4);
            mv.visitVarInsn(25, 5);
            mv.visitMethodInsn(183, this.className, "bdbSetField", "(Ljava/lang/Object;IIZLjava/lang/Object;)V");
        }
        mv.visitInsn(177);
        mv.visitLabel(l0);
        mv.visitVarInsn(21, 4);
        Label l2 = new Label();
        mv.visitJumpInsn(153, l2);
        Label l1 = new Label();
        this.genSetFieldSwitch(mv, this.secKeyFields, l1);
        mv.visitLabel(l2);
        this.genSetFieldSwitch(mv, this.nonKeyFields, l1);
        mv.visitLabel(l1);
        mv.visitInsn(177);
        mv.visitMaxs(2, 6);
        mv.visitEnd();
    }

    private void genSetFieldSwitch(MethodVisitor mv, List<FieldInfo> fields, Label defaultLabel) {
        int i;
        int nFields = fields.size();
        if (nFields == 0) {
            mv.visitJumpInsn(167, defaultLabel);
            return;
        }
        Label[] labels = new Label[nFields];
        for (i = 0; i < nFields; ++i) {
            labels[i] = new Label();
        }
        mv.visitVarInsn(21, 2);
        mv.visitTableSwitchInsn(0, nFields - 1, defaultLabel, labels);
        for (i = 0; i < nFields; ++i) {
            FieldInfo field = fields.get(i);
            mv.visitLabel(labels[i]);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 5);
            if (BytecodeEnhancer.isRefType(field.type)) {
                mv.visitTypeInsn(192, BytecodeEnhancer.getTypeInstName(field.type));
            } else {
                int sort = field.type.getSort();
                mv.visitTypeInsn(192, BytecodeEnhancer.getPrimitiveWrapperClass(sort).replace('.', '/'));
                this.genUnwrapPrimitive(mv, sort);
            }
            mv.visitFieldInsn(181, this.className, field.name, field.type.getDescriptor());
            mv.visitInsn(177);
        }
    }

    private void genWritePrimitive(MethodVisitor mv, int sort) {
        switch (sort) {
            case 1: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeBoolean", "(Z)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            case 2: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeChar", "(I)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            case 3: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeByte", "(I)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            case 4: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeShort", "(I)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            case 5: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeInt", "(I)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            case 7: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeLong", "(J)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            case 6: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeSortedFloat", "(F)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            case 8: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeSortedDouble", "(D)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(sort));
            }
        }
        mv.visitInsn(87);
    }

    private void genReadPrimitive(MethodVisitor mv, int sort) {
        switch (sort) {
            case 1: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readBoolean", "()Z");
                break;
            }
            case 2: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readChar", "()C");
                break;
            }
            case 3: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readByte", "()B");
                break;
            }
            case 4: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readShort", "()S");
                break;
            }
            case 5: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readInt", "()I");
                break;
            }
            case 7: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readLong", "()J");
                break;
            }
            case 6: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readSortedFloat", "()F");
                break;
            }
            case 8: {
                mv.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readSortedDouble", "()D");
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(sort));
            }
        }
    }

    private void genWrapPrimitive(MethodVisitor mv, int sort) {
        switch (sort) {
            case 1: {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                break;
            }
            case 2: {
                mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                break;
            }
            case 4: {
                mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                break;
            }
            case 5: {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                break;
            }
            case 7: {
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                break;
            }
            case 8: {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(sort));
            }
        }
    }

    private void genUnwrapPrimitive(MethodVisitor mv, int sort) {
        switch (sort) {
            case 1: {
                mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                break;
            }
            case 2: {
                mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                break;
            }
            case 3: {
                mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                break;
            }
            case 4: {
                mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                break;
            }
            case 5: {
                mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                break;
            }
            case 7: {
                mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                break;
            }
            case 6: {
                mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                break;
            }
            case 8: {
                mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(sort));
            }
        }
    }

    private static String getTypeInstName(Type type) {
        if (type.getSort() == 10) {
            return type.getInternalName();
        }
        if (type.getSort() == 9) {
            return type.getDescriptor();
        }
        throw new IllegalStateException();
    }

    private static void genBeforeCompareToZero(MethodVisitor mv, Type type) {
        switch (type.getSort()) {
            case 7: {
                mv.visitInsn(9);
                mv.visitInsn(148);
                break;
            }
            case 6: {
                mv.visitInsn(11);
                mv.visitInsn(149);
                break;
            }
            case 8: {
                mv.visitInsn(14);
                mv.visitInsn(151);
            }
        }
    }

    static boolean isSimpleRefType(String className) {
        return PRIMITIVE_WRAPPERS.containsKey(className) || className.equals(BigInteger.class.getName()) || className.equals(Date.class.getName()) || className.equals(String.class.getName());
    }

    static String getPrimitiveWrapperClass(int primitiveSort) {
        for (Map.Entry<String, Integer> entry : PRIMITIVE_WRAPPERS.entrySet()) {
            if (entry.getValue() != primitiveSort) continue;
            return entry.getKey();
        }
        throw new IllegalStateException(String.valueOf(primitiveSort));
    }

    private static boolean isRefType(Type type) {
        int sort = type.getSort();
        return sort == 10 || sort == 9;
    }

    private static boolean containsString(String[] a, String s) {
        if (a != null) {
            for (String t : a) {
                if (!s.equals(t)) continue;
                return true;
            }
        }
        return false;
    }

    private static String[] appendString(String[] a, String s) {
        if (a != null) {
            int len = a.length;
            String[] a2 = new String[len + 1];
            System.arraycopy(a, 0, a2, 0, len);
            a2[len] = s;
            return a2;
        }
        return new String[]{s};
    }

    private NotPersistentException abort() {
        return NOT_PERSISTENT;
    }

    static {
        PRIMITIVE_WRAPPERS.put(Boolean.class.getName(), 1);
        PRIMITIVE_WRAPPERS.put(Character.class.getName(), 2);
        PRIMITIVE_WRAPPERS.put(Byte.class.getName(), 3);
        PRIMITIVE_WRAPPERS.put(Short.class.getName(), 4);
        PRIMITIVE_WRAPPERS.put(Integer.class.getName(), 5);
        PRIMITIVE_WRAPPERS.put(Long.class.getName(), 7);
        PRIMITIVE_WRAPPERS.put(Float.class.getName(), 6);
        PRIMITIVE_WRAPPERS.put(Double.class.getName(), 8);
    }

    private static abstract class AnnotationInfo
    implements AnnotationVisitor {
        AnnotationVisitor parent;

        AnnotationInfo(AnnotationVisitor parent) {
            this.parent = parent;
        }

        public void visit(String name, Object value) {
            this.parent.visit(name, value);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return this.parent.visitAnnotation(name, desc);
        }

        public AnnotationVisitor visitArray(String name) {
            return this.parent.visitArray(name);
        }

        public void visitEnum(String name, String desc, String value) {
            this.parent.visitEnum(name, desc, value);
        }

        public void visitEnd() {
            this.parent.visitEnd();
        }
    }

    private static class OrderInfo
    extends AnnotationInfo {
        int value;

        OrderInfo(AnnotationVisitor parent) {
            super(parent);
        }

        public void visit(String name, Object value) {
            if (name.equals("value")) {
                this.value = (Integer)value;
            }
            this.parent.visit(name, value);
        }
    }

    private static class FieldInfo
    implements FieldVisitor {
        FieldVisitor parent;
        String name;
        Type type;
        OrderInfo order;
        boolean isPriKey;
        boolean isSecKey;
        boolean isTransient;

        FieldInfo(FieldVisitor parent, String name, String desc, boolean isTransient) {
            this.parent = parent;
            this.name = name;
            this.isTransient = isTransient;
            this.type = Type.getType(desc);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor ret = this.parent.visitAnnotation(desc, visible);
            if (desc.equals("Lcom/sleepycat/persist/model/KeyField;")) {
                this.order = new OrderInfo(ret);
                ret = this.order;
            } else if (desc.equals("Lcom/sleepycat/persist/model/PrimaryKey;")) {
                this.isPriKey = true;
            } else if (desc.equals("Lcom/sleepycat/persist/model/SecondaryKey;")) {
                this.isSecKey = true;
            } else if (desc.equals("Lcom/sleepycat/persist/model/NotPersistent;")) {
                this.isTransient = true;
            } else if (desc.equals("Lcom/sleepycat/persist/model/NotTransient;")) {
                this.isTransient = false;
            }
            return ret;
        }

        public void visitAttribute(Attribute attr) {
            this.parent.visitAttribute(attr);
        }

        public void visitEnd() {
            this.parent.visitEnd();
        }

        public String toString() {
            String label = this.isPriKey ? "PrimaryKey" : (this.isSecKey ? "SecondaryKey" : (this.order != null ? "CompositeKeyField " + this.order.value : "NonKeyField"));
            return "[" + label + ' ' + this.name + ' ' + this.type + ']';
        }
    }

    static class NotPersistentException
    extends RuntimeException {
        NotPersistentException() {
        }
    }
}

